# modelcatalog-api [![Build Status](https://travis-ci.org/mintproject/model-catalog-python-api-client.svg?branch=master)](https://travis-ci.org/mintproject/model-catalog-python-api-client)
This is the API of the  Software Description Ontology at [https://mintproject.github.io/Mint-ModelCatalog-Ontology/release/1.3.0/index-en.html](https://w3id.org/okn/o/sdm)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1.4.0
- Package version: 2.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install modelcatalog-api
```
(you may need to run `pip` with root permission: `sudo pip install modelcatalog-api`)

Then import the package:
```python
import modelcatalog 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import modelcatalog
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import modelcatalog
from modelcatalog.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = modelcatalog.CausalDiagramApi(modelcatalog.ApiClient(configuration))
username = 'username_example' # str | Username to query (optional)
label = 'label_example' # str | Filter by label (optional)

try:
    # List all CausalDiagram entities
    api_response = api_instance.causaldiagrams_get(username=username, label=label)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CausalDiagramApi->causaldiagrams_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.models.mint.isi.edu/v1.4.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CausalDiagramApi* | [**causaldiagrams_get**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_get) | **GET** /causaldiagrams | List all CausalDiagram entities
*CausalDiagramApi* | [**causaldiagrams_id_delete**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_id_delete) | **DELETE** /causaldiagrams/{id} | Delete a CausalDiagram
*CausalDiagramApi* | [**causaldiagrams_id_get**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_id_get) | **GET** /causaldiagrams/{id} | Get a CausalDiagram
*CausalDiagramApi* | [**causaldiagrams_id_put**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_id_put) | **PUT** /causaldiagrams/{id} | Update a CausalDiagram
*CausalDiagramApi* | [**causaldiagrams_post**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_post) | **POST** /causaldiagrams | Create a CausalDiagram
*ConfigurationSetupApi* | [**configurationsetups_get**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_get) | **GET** /configurationsetups | List all ConfigurationSetup entities
*ConfigurationSetupApi* | [**configurationsetups_id_delete**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_id_delete) | **DELETE** /configurationsetups/{id} | Delete a ConfigurationSetup
*ConfigurationSetupApi* | [**configurationsetups_id_get**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_id_get) | **GET** /configurationsetups/{id} | Get a ConfigurationSetup
*ConfigurationSetupApi* | [**configurationsetups_id_put**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_id_put) | **PUT** /configurationsetups/{id} | Update a ConfigurationSetup
*ConfigurationSetupApi* | [**configurationsetups_post**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_post) | **POST** /configurationsetups | Create a ConfigurationSetup
*ConfigurationSetupApi* | [**custom_configurationsetups_id_get**](docs/endpoints/ConfigurationSetupApi.md#custom_configurationsetups_id_get) | **GET** /custom/configurationsetups/{id} | Get a ModelConfigurationSetup
*DatasetSpecificationApi* | [**datasetspecifications_get**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_get) | **GET** /datasetspecifications | List all DatasetSpecification entities
*DatasetSpecificationApi* | [**datasetspecifications_id_delete**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_id_delete) | **DELETE** /datasetspecifications/{id} | Delete a DatasetSpecification
*DatasetSpecificationApi* | [**datasetspecifications_id_get**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_id_get) | **GET** /datasetspecifications/{id} | Get a DatasetSpecification
*DatasetSpecificationApi* | [**datasetspecifications_id_put**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_id_put) | **PUT** /datasetspecifications/{id} | Update a DatasetSpecification
*DatasetSpecificationApi* | [**datasetspecifications_post**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_post) | **POST** /datasetspecifications | Create a DatasetSpecification
*EmpiricalModelApi* | [**empiricalmodels_get**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_get) | **GET** /empiricalmodels | List all EmpiricalModel entities
*EmpiricalModelApi* | [**empiricalmodels_id_delete**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_id_delete) | **DELETE** /empiricalmodels/{id} | Delete a EmpiricalModel
*EmpiricalModelApi* | [**empiricalmodels_id_get**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_id_get) | **GET** /empiricalmodels/{id} | Get a EmpiricalModel
*EmpiricalModelApi* | [**empiricalmodels_id_put**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_id_put) | **PUT** /empiricalmodels/{id} | Update a EmpiricalModel
*EmpiricalModelApi* | [**empiricalmodels_post**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_post) | **POST** /empiricalmodels | Create a EmpiricalModel
*EmulatorApi* | [**emulators_get**](docs/endpoints/EmulatorApi.md#emulators_get) | **GET** /emulators | List all Emulator entities
*EmulatorApi* | [**emulators_id_delete**](docs/endpoints/EmulatorApi.md#emulators_id_delete) | **DELETE** /emulators/{id} | Delete a Emulator
*EmulatorApi* | [**emulators_id_get**](docs/endpoints/EmulatorApi.md#emulators_id_get) | **GET** /emulators/{id} | Get a Emulator
*EmulatorApi* | [**emulators_id_put**](docs/endpoints/EmulatorApi.md#emulators_id_put) | **PUT** /emulators/{id} | Update a Emulator
*EmulatorApi* | [**emulators_post**](docs/endpoints/EmulatorApi.md#emulators_post) | **POST** /emulators | Create a Emulator
*EquationApi* | [**equations_get**](docs/endpoints/EquationApi.md#equations_get) | **GET** /equations | List all Equation entities
*EquationApi* | [**equations_id_delete**](docs/endpoints/EquationApi.md#equations_id_delete) | **DELETE** /equations/{id} | Delete a Equation
*EquationApi* | [**equations_id_get**](docs/endpoints/EquationApi.md#equations_id_get) | **GET** /equations/{id} | Get a Equation
*EquationApi* | [**equations_id_put**](docs/endpoints/EquationApi.md#equations_id_put) | **PUT** /equations/{id} | Update a Equation
*EquationApi* | [**equations_post**](docs/endpoints/EquationApi.md#equations_post) | **POST** /equations | Create a Equation
*FarmingPracticesApi* | [**farmingpracticess_get**](docs/endpoints/FarmingPracticesApi.md#farmingpracticess_get) | **GET** /farmingpracticess | List all FarmingPractices entities
*FarmingPracticesApi* | [**farmingpracticess_id_delete**](docs/endpoints/FarmingPracticesApi.md#farmingpracticess_id_delete) | **DELETE** /farmingpracticess/{id} | Delete a FarmingPractices
*FarmingPracticesApi* | [**farmingpracticess_id_get**](docs/endpoints/FarmingPracticesApi.md#farmingpracticess_id_get) | **GET** /farmingpracticess/{id} | Get a FarmingPractices
*FarmingPracticesApi* | [**farmingpracticess_id_put**](docs/endpoints/FarmingPracticesApi.md#farmingpracticess_id_put) | **PUT** /farmingpracticess/{id} | Update a FarmingPractices
*FarmingPracticesApi* | [**farmingpracticess_post**](docs/endpoints/FarmingPracticesApi.md#farmingpracticess_post) | **POST** /farmingpracticess | Create a FarmingPractices
*FundingInformationApi* | [**fundinginformations_get**](docs/endpoints/FundingInformationApi.md#fundinginformations_get) | **GET** /fundinginformations | List all FundingInformation entities
*FundingInformationApi* | [**fundinginformations_id_delete**](docs/endpoints/FundingInformationApi.md#fundinginformations_id_delete) | **DELETE** /fundinginformations/{id} | Delete a FundingInformation
*FundingInformationApi* | [**fundinginformations_id_get**](docs/endpoints/FundingInformationApi.md#fundinginformations_id_get) | **GET** /fundinginformations/{id} | Get a FundingInformation
*FundingInformationApi* | [**fundinginformations_id_put**](docs/endpoints/FundingInformationApi.md#fundinginformations_id_put) | **PUT** /fundinginformations/{id} | Update a FundingInformation
*FundingInformationApi* | [**fundinginformations_post**](docs/endpoints/FundingInformationApi.md#fundinginformations_post) | **POST** /fundinginformations | Create a FundingInformation
*GeoCoordinatesApi* | [**geocoordinatess_get**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_get) | **GET** /geocoordinatess | List all GeoCoordinates entities
*GeoCoordinatesApi* | [**geocoordinatess_id_delete**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_id_delete) | **DELETE** /geocoordinatess/{id} | Delete a GeoCoordinates
*GeoCoordinatesApi* | [**geocoordinatess_id_get**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_id_get) | **GET** /geocoordinatess/{id} | Get a GeoCoordinates
*GeoCoordinatesApi* | [**geocoordinatess_id_put**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_id_put) | **PUT** /geocoordinatess/{id} | Update a GeoCoordinates
*GeoCoordinatesApi* | [**geocoordinatess_post**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_post) | **POST** /geocoordinatess | Create a GeoCoordinates
*GeoShapeApi* | [**geoshapes_get**](docs/endpoints/GeoShapeApi.md#geoshapes_get) | **GET** /geoshapes | List all GeoShape entities
*GeoShapeApi* | [**geoshapes_id_delete**](docs/endpoints/GeoShapeApi.md#geoshapes_id_delete) | **DELETE** /geoshapes/{id} | Delete a GeoShape
*GeoShapeApi* | [**geoshapes_id_get**](docs/endpoints/GeoShapeApi.md#geoshapes_id_get) | **GET** /geoshapes/{id} | Get a GeoShape
*GeoShapeApi* | [**geoshapes_id_put**](docs/endpoints/GeoShapeApi.md#geoshapes_id_put) | **PUT** /geoshapes/{id} | Update a GeoShape
*GeoShapeApi* | [**geoshapes_post**](docs/endpoints/GeoShapeApi.md#geoshapes_post) | **POST** /geoshapes | Create a GeoShape
*GridApi* | [**grids_get**](docs/endpoints/GridApi.md#grids_get) | **GET** /grids | List all Grid entities
*GridApi* | [**grids_id_delete**](docs/endpoints/GridApi.md#grids_id_delete) | **DELETE** /grids/{id} | Delete a Grid
*GridApi* | [**grids_id_get**](docs/endpoints/GridApi.md#grids_id_get) | **GET** /grids/{id} | Get a Grid
*GridApi* | [**grids_id_put**](docs/endpoints/GridApi.md#grids_id_put) | **PUT** /grids/{id} | Update a Grid
*GridApi* | [**grids_post**](docs/endpoints/GridApi.md#grids_post) | **POST** /grids | Create a Grid
*HybridModelApi* | [**hybridmodels_get**](docs/endpoints/HybridModelApi.md#hybridmodels_get) | **GET** /hybridmodels | List all HybridModel entities
*HybridModelApi* | [**hybridmodels_id_delete**](docs/endpoints/HybridModelApi.md#hybridmodels_id_delete) | **DELETE** /hybridmodels/{id} | Delete a HybridModel
*HybridModelApi* | [**hybridmodels_id_get**](docs/endpoints/HybridModelApi.md#hybridmodels_id_get) | **GET** /hybridmodels/{id} | Get a HybridModel
*HybridModelApi* | [**hybridmodels_id_put**](docs/endpoints/HybridModelApi.md#hybridmodels_id_put) | **PUT** /hybridmodels/{id} | Update a HybridModel
*HybridModelApi* | [**hybridmodels_post**](docs/endpoints/HybridModelApi.md#hybridmodels_post) | **POST** /hybridmodels | Create a HybridModel
*ICASAVariableApi* | [**icasavariables_get**](docs/endpoints/ICASAVariableApi.md#icasavariables_get) | **GET** /icasavariables | List all ICASAVariable entities
*ICASAVariableApi* | [**icasavariables_id_delete**](docs/endpoints/ICASAVariableApi.md#icasavariables_id_delete) | **DELETE** /icasavariables/{id} | Delete a ICASAVariable
*ICASAVariableApi* | [**icasavariables_id_get**](docs/endpoints/ICASAVariableApi.md#icasavariables_id_get) | **GET** /icasavariables/{id} | Get a ICASAVariable
*ICASAVariableApi* | [**icasavariables_id_put**](docs/endpoints/ICASAVariableApi.md#icasavariables_id_put) | **PUT** /icasavariables/{id} | Update a ICASAVariable
*ICASAVariableApi* | [**icasavariables_post**](docs/endpoints/ICASAVariableApi.md#icasavariables_post) | **POST** /icasavariables | Create a ICASAVariable
*ImageApi* | [**images_get**](docs/endpoints/ImageApi.md#images_get) | **GET** /images | List all Image entities
*ImageApi* | [**images_id_delete**](docs/endpoints/ImageApi.md#images_id_delete) | **DELETE** /images/{id} | Delete a Image
*ImageApi* | [**images_id_get**](docs/endpoints/ImageApi.md#images_id_get) | **GET** /images/{id} | Get a Image
*ImageApi* | [**images_id_put**](docs/endpoints/ImageApi.md#images_id_put) | **PUT** /images/{id} | Update a Image
*ImageApi* | [**images_post**](docs/endpoints/ImageApi.md#images_post) | **POST** /images | Create a Image
*InterventionApi* | [**interventions_get**](docs/endpoints/InterventionApi.md#interventions_get) | **GET** /interventions | List all Intervention entities
*InterventionApi* | [**interventions_id_delete**](docs/endpoints/InterventionApi.md#interventions_id_delete) | **DELETE** /interventions/{id} | Delete a Intervention
*InterventionApi* | [**interventions_id_get**](docs/endpoints/InterventionApi.md#interventions_id_get) | **GET** /interventions/{id} | Get a Intervention
*InterventionApi* | [**interventions_id_put**](docs/endpoints/InterventionApi.md#interventions_id_put) | **PUT** /interventions/{id} | Update a Intervention
*InterventionApi* | [**interventions_post**](docs/endpoints/InterventionApi.md#interventions_post) | **POST** /interventions | Create a Intervention
*ModelApi* | [**custom_model_index_get**](docs/endpoints/ModelApi.md#custom_model_index_get) | **GET** /custom/model/index | Get a Model
*ModelApi* | [**custom_model_intervention_get**](docs/endpoints/ModelApi.md#custom_model_intervention_get) | **GET** /custom/model/intervention | Get a Model
*ModelApi* | [**custom_model_region_get**](docs/endpoints/ModelApi.md#custom_model_region_get) | **GET** /custom/model/region | Get a Model
*ModelApi* | [**models_get**](docs/endpoints/ModelApi.md#models_get) | **GET** /models | List all Model entities
*ModelApi* | [**models_id_delete**](docs/endpoints/ModelApi.md#models_id_delete) | **DELETE** /models/{id} | Delete a Model
*ModelApi* | [**models_id_get**](docs/endpoints/ModelApi.md#models_id_get) | **GET** /models/{id} | Get a Model
*ModelApi* | [**models_id_put**](docs/endpoints/ModelApi.md#models_id_put) | **PUT** /models/{id} | Update a Model
*ModelApi* | [**models_post**](docs/endpoints/ModelApi.md#models_post) | **POST** /models | Create a Model
*ModelConfigurationApi* | [**custom_modelconfigurations_id_get**](docs/endpoints/ModelConfigurationApi.md#custom_modelconfigurations_id_get) | **GET** /custom/modelconfigurations/{id} | Get a ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_get**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_get) | **GET** /modelconfigurations | List all ModelConfiguration entities
*ModelConfigurationApi* | [**modelconfigurations_id_delete**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_id_delete) | **DELETE** /modelconfigurations/{id} | Delete a ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_id_get**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_id_get) | **GET** /modelconfigurations/{id} | Get a ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_id_put**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_id_put) | **PUT** /modelconfigurations/{id} | Update a ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_post**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_post) | **POST** /modelconfigurations | Create a ModelConfiguration
*ModelConfigurationSetupApi* | [**custom_modelconfigurationsetups_id_get**](docs/endpoints/ModelConfigurationSetupApi.md#custom_modelconfigurationsetups_id_get) | **GET** /custom/modelconfigurationsetups/{id} | Get a ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_get**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_get) | **GET** /modelconfigurationsetups | List all ModelConfigurationSetup entities
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_id_delete**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_id_delete) | **DELETE** /modelconfigurationsetups/{id} | Delete a ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_id_get**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_id_get) | **GET** /modelconfigurationsetups/{id} | Get a ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_id_put**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_id_put) | **PUT** /modelconfigurationsetups/{id} | Update a ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_post**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_post) | **POST** /modelconfigurationsetups | Create a ModelConfigurationSetup
*NumericalIndexApi* | [**numericalindexs_get**](docs/endpoints/NumericalIndexApi.md#numericalindexs_get) | **GET** /numericalindexs | List all NumericalIndex entities
*NumericalIndexApi* | [**numericalindexs_id_delete**](docs/endpoints/NumericalIndexApi.md#numericalindexs_id_delete) | **DELETE** /numericalindexs/{id} | Delete a NumericalIndex
*NumericalIndexApi* | [**numericalindexs_id_get**](docs/endpoints/NumericalIndexApi.md#numericalindexs_id_get) | **GET** /numericalindexs/{id} | Get a NumericalIndex
*NumericalIndexApi* | [**numericalindexs_id_put**](docs/endpoints/NumericalIndexApi.md#numericalindexs_id_put) | **PUT** /numericalindexs/{id} | Update a NumericalIndex
*NumericalIndexApi* | [**numericalindexs_post**](docs/endpoints/NumericalIndexApi.md#numericalindexs_post) | **POST** /numericalindexs | Create a NumericalIndex
*OrganizationApi* | [**organizations_get**](docs/endpoints/OrganizationApi.md#organizations_get) | **GET** /organizations | List all Organization entities
*OrganizationApi* | [**organizations_id_delete**](docs/endpoints/OrganizationApi.md#organizations_id_delete) | **DELETE** /organizations/{id} | Delete a Organization
*OrganizationApi* | [**organizations_id_get**](docs/endpoints/OrganizationApi.md#organizations_id_get) | **GET** /organizations/{id} | Get a Organization
*OrganizationApi* | [**organizations_id_put**](docs/endpoints/OrganizationApi.md#organizations_id_put) | **PUT** /organizations/{id} | Update a Organization
*OrganizationApi* | [**organizations_post**](docs/endpoints/OrganizationApi.md#organizations_post) | **POST** /organizations | Create a Organization
*ParameterApi* | [**parameters_get**](docs/endpoints/ParameterApi.md#parameters_get) | **GET** /parameters | List all Parameter entities
*ParameterApi* | [**parameters_id_delete**](docs/endpoints/ParameterApi.md#parameters_id_delete) | **DELETE** /parameters/{id} | Delete a Parameter
*ParameterApi* | [**parameters_id_get**](docs/endpoints/ParameterApi.md#parameters_id_get) | **GET** /parameters/{id} | Get a Parameter
*ParameterApi* | [**parameters_id_put**](docs/endpoints/ParameterApi.md#parameters_id_put) | **PUT** /parameters/{id} | Update a Parameter
*ParameterApi* | [**parameters_post**](docs/endpoints/ParameterApi.md#parameters_post) | **POST** /parameters | Create a Parameter
*PersonApi* | [**persons_get**](docs/endpoints/PersonApi.md#persons_get) | **GET** /persons | List all Person entities
*PersonApi* | [**persons_id_delete**](docs/endpoints/PersonApi.md#persons_id_delete) | **DELETE** /persons/{id} | Delete a Person
*PersonApi* | [**persons_id_get**](docs/endpoints/PersonApi.md#persons_id_get) | **GET** /persons/{id} | Get a Person
*PersonApi* | [**persons_id_put**](docs/endpoints/PersonApi.md#persons_id_put) | **PUT** /persons/{id} | Update a Person
*PersonApi* | [**persons_post**](docs/endpoints/PersonApi.md#persons_post) | **POST** /persons | Create a Person
*PointBasedGridApi* | [**pointbasedgrids_get**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_get) | **GET** /pointbasedgrids | List all PointBasedGrid entities
*PointBasedGridApi* | [**pointbasedgrids_id_delete**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_id_delete) | **DELETE** /pointbasedgrids/{id} | Delete a PointBasedGrid
*PointBasedGridApi* | [**pointbasedgrids_id_get**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_id_get) | **GET** /pointbasedgrids/{id} | Get a PointBasedGrid
*PointBasedGridApi* | [**pointbasedgrids_id_put**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_id_put) | **PUT** /pointbasedgrids/{id} | Update a PointBasedGrid
*PointBasedGridApi* | [**pointbasedgrids_post**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_post) | **POST** /pointbasedgrids | Create a PointBasedGrid
*ProcessApi* | [**processs_get**](docs/endpoints/ProcessApi.md#processs_get) | **GET** /processs | List all Process entities
*ProcessApi* | [**processs_id_delete**](docs/endpoints/ProcessApi.md#processs_id_delete) | **DELETE** /processs/{id} | Delete a Process
*ProcessApi* | [**processs_id_get**](docs/endpoints/ProcessApi.md#processs_id_get) | **GET** /processs/{id} | Get a Process
*ProcessApi* | [**processs_id_put**](docs/endpoints/ProcessApi.md#processs_id_put) | **PUT** /processs/{id} | Update a Process
*ProcessApi* | [**processs_post**](docs/endpoints/ProcessApi.md#processs_post) | **POST** /processs | Create a Process
*RegionApi* | [**regions_get**](docs/endpoints/RegionApi.md#regions_get) | **GET** /regions | List all Region entities
*RegionApi* | [**regions_id_delete**](docs/endpoints/RegionApi.md#regions_id_delete) | **DELETE** /regions/{id} | Delete a Region
*RegionApi* | [**regions_id_get**](docs/endpoints/RegionApi.md#regions_id_get) | **GET** /regions/{id} | Get a Region
*RegionApi* | [**regions_id_put**](docs/endpoints/RegionApi.md#regions_id_put) | **PUT** /regions/{id} | Update a Region
*RegionApi* | [**regions_post**](docs/endpoints/RegionApi.md#regions_post) | **POST** /regions | Create a Region
*SVOVariableApi* | [**svovariables_get**](docs/endpoints/SVOVariableApi.md#svovariables_get) | **GET** /svovariables | List all SVOVariable entities
*SVOVariableApi* | [**svovariables_id_delete**](docs/endpoints/SVOVariableApi.md#svovariables_id_delete) | **DELETE** /svovariables/{id} | Delete a SVOVariable
*SVOVariableApi* | [**svovariables_id_get**](docs/endpoints/SVOVariableApi.md#svovariables_id_get) | **GET** /svovariables/{id} | Get a SVOVariable
*SVOVariableApi* | [**svovariables_id_put**](docs/endpoints/SVOVariableApi.md#svovariables_id_put) | **PUT** /svovariables/{id} | Update a SVOVariable
*SVOVariableApi* | [**svovariables_post**](docs/endpoints/SVOVariableApi.md#svovariables_post) | **POST** /svovariables | Create a SVOVariable
*SampleCollectionApi* | [**samplecollections_get**](docs/endpoints/SampleCollectionApi.md#samplecollections_get) | **GET** /samplecollections | List all SampleCollection entities
*SampleCollectionApi* | [**samplecollections_id_delete**](docs/endpoints/SampleCollectionApi.md#samplecollections_id_delete) | **DELETE** /samplecollections/{id} | Delete a SampleCollection
*SampleCollectionApi* | [**samplecollections_id_get**](docs/endpoints/SampleCollectionApi.md#samplecollections_id_get) | **GET** /samplecollections/{id} | Get a SampleCollection
*SampleCollectionApi* | [**samplecollections_id_put**](docs/endpoints/SampleCollectionApi.md#samplecollections_id_put) | **PUT** /samplecollections/{id} | Update a SampleCollection
*SampleCollectionApi* | [**samplecollections_post**](docs/endpoints/SampleCollectionApi.md#samplecollections_post) | **POST** /samplecollections | Create a SampleCollection
*SampleExecutionApi* | [**sampleexecutions_get**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_get) | **GET** /sampleexecutions | List all SampleExecution entities
*SampleExecutionApi* | [**sampleexecutions_id_delete**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_id_delete) | **DELETE** /sampleexecutions/{id} | Delete a SampleExecution
*SampleExecutionApi* | [**sampleexecutions_id_get**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_id_get) | **GET** /sampleexecutions/{id} | Get a SampleExecution
*SampleExecutionApi* | [**sampleexecutions_id_put**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_id_put) | **PUT** /sampleexecutions/{id} | Update a SampleExecution
*SampleExecutionApi* | [**sampleexecutions_post**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_post) | **POST** /sampleexecutions | Create a SampleExecution
*SampleResourceApi* | [**sampleresources_get**](docs/endpoints/SampleResourceApi.md#sampleresources_get) | **GET** /sampleresources | List all SampleResource entities
*SampleResourceApi* | [**sampleresources_id_delete**](docs/endpoints/SampleResourceApi.md#sampleresources_id_delete) | **DELETE** /sampleresources/{id} | Delete a SampleResource
*SampleResourceApi* | [**sampleresources_id_get**](docs/endpoints/SampleResourceApi.md#sampleresources_id_get) | **GET** /sampleresources/{id} | Get a SampleResource
*SampleResourceApi* | [**sampleresources_id_put**](docs/endpoints/SampleResourceApi.md#sampleresources_id_put) | **PUT** /sampleresources/{id} | Update a SampleResource
*SampleResourceApi* | [**sampleresources_post**](docs/endpoints/SampleResourceApi.md#sampleresources_post) | **POST** /sampleresources | Create a SampleResource
*SoftwareApi* | [**softwares_get**](docs/endpoints/SoftwareApi.md#softwares_get) | **GET** /softwares | List all Software entities
*SoftwareApi* | [**softwares_id_delete**](docs/endpoints/SoftwareApi.md#softwares_id_delete) | **DELETE** /softwares/{id} | Delete a Software
*SoftwareApi* | [**softwares_id_get**](docs/endpoints/SoftwareApi.md#softwares_id_get) | **GET** /softwares/{id} | Get a Software
*SoftwareApi* | [**softwares_id_put**](docs/endpoints/SoftwareApi.md#softwares_id_put) | **PUT** /softwares/{id} | Update a Software
*SoftwareApi* | [**softwares_post**](docs/endpoints/SoftwareApi.md#softwares_post) | **POST** /softwares | Create a Software
*SoftwareConfigurationApi* | [**softwareconfigurations_get**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_get) | **GET** /softwareconfigurations | List all SoftwareConfiguration entities
*SoftwareConfigurationApi* | [**softwareconfigurations_id_delete**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_id_delete) | **DELETE** /softwareconfigurations/{id} | Delete a SoftwareConfiguration
*SoftwareConfigurationApi* | [**softwareconfigurations_id_get**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_id_get) | **GET** /softwareconfigurations/{id} | Get a SoftwareConfiguration
*SoftwareConfigurationApi* | [**softwareconfigurations_id_put**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_id_put) | **PUT** /softwareconfigurations/{id} | Update a SoftwareConfiguration
*SoftwareConfigurationApi* | [**softwareconfigurations_post**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_post) | **POST** /softwareconfigurations | Create a SoftwareConfiguration
*SoftwareImageApi* | [**softwareimages_get**](docs/endpoints/SoftwareImageApi.md#softwareimages_get) | **GET** /softwareimages | List all SoftwareImage entities
*SoftwareImageApi* | [**softwareimages_id_delete**](docs/endpoints/SoftwareImageApi.md#softwareimages_id_delete) | **DELETE** /softwareimages/{id} | Delete a SoftwareImage
*SoftwareImageApi* | [**softwareimages_id_get**](docs/endpoints/SoftwareImageApi.md#softwareimages_id_get) | **GET** /softwareimages/{id} | Get a SoftwareImage
*SoftwareImageApi* | [**softwareimages_id_put**](docs/endpoints/SoftwareImageApi.md#softwareimages_id_put) | **PUT** /softwareimages/{id} | Update a SoftwareImage
*SoftwareImageApi* | [**softwareimages_post**](docs/endpoints/SoftwareImageApi.md#softwareimages_post) | **POST** /softwareimages | Create a SoftwareImage
*SoftwareVersionApi* | [**softwareversions_get**](docs/endpoints/SoftwareVersionApi.md#softwareversions_get) | **GET** /softwareversions | List all SoftwareVersion entities
*SoftwareVersionApi* | [**softwareversions_id_delete**](docs/endpoints/SoftwareVersionApi.md#softwareversions_id_delete) | **DELETE** /softwareversions/{id} | Delete a SoftwareVersion
*SoftwareVersionApi* | [**softwareversions_id_get**](docs/endpoints/SoftwareVersionApi.md#softwareversions_id_get) | **GET** /softwareversions/{id} | Get a SoftwareVersion
*SoftwareVersionApi* | [**softwareversions_id_put**](docs/endpoints/SoftwareVersionApi.md#softwareversions_id_put) | **PUT** /softwareversions/{id} | Update a SoftwareVersion
*SoftwareVersionApi* | [**softwareversions_post**](docs/endpoints/SoftwareVersionApi.md#softwareversions_post) | **POST** /softwareversions | Create a SoftwareVersion
*SourceCodeApi* | [**sourcecodes_get**](docs/endpoints/SourceCodeApi.md#sourcecodes_get) | **GET** /sourcecodes | List all SourceCode entities
*SourceCodeApi* | [**sourcecodes_id_delete**](docs/endpoints/SourceCodeApi.md#sourcecodes_id_delete) | **DELETE** /sourcecodes/{id} | Delete a SourceCode
*SourceCodeApi* | [**sourcecodes_id_get**](docs/endpoints/SourceCodeApi.md#sourcecodes_id_get) | **GET** /sourcecodes/{id} | Get a SourceCode
*SourceCodeApi* | [**sourcecodes_id_put**](docs/endpoints/SourceCodeApi.md#sourcecodes_id_put) | **PUT** /sourcecodes/{id} | Update a SourceCode
*SourceCodeApi* | [**sourcecodes_post**](docs/endpoints/SourceCodeApi.md#sourcecodes_post) | **POST** /sourcecodes | Create a SourceCode
*SpatialResolutionApi* | [**spatialresolutions_get**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_get) | **GET** /spatialresolutions | List all SpatialResolution entities
*SpatialResolutionApi* | [**spatialresolutions_id_delete**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_id_delete) | **DELETE** /spatialresolutions/{id} | Delete a SpatialResolution
*SpatialResolutionApi* | [**spatialresolutions_id_get**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_id_get) | **GET** /spatialresolutions/{id} | Get a SpatialResolution
*SpatialResolutionApi* | [**spatialresolutions_id_put**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_id_put) | **PUT** /spatialresolutions/{id} | Update a SpatialResolution
*SpatialResolutionApi* | [**spatialresolutions_post**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_post) | **POST** /spatialresolutions | Create a SpatialResolution
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_get**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_get) | **GET** /spatiallydistributedgrids | List all SpatiallyDistributedGrid entities
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_id_delete**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_id_delete) | **DELETE** /spatiallydistributedgrids/{id} | Delete a SpatiallyDistributedGrid
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_id_get**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_id_get) | **GET** /spatiallydistributedgrids/{id} | Get a SpatiallyDistributedGrid
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_id_put**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_id_put) | **PUT** /spatiallydistributedgrids/{id} | Update a SpatiallyDistributedGrid
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_post**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_post) | **POST** /spatiallydistributedgrids | Create a SpatiallyDistributedGrid
*StandardVariableApi* | [**standardvariables_get**](docs/endpoints/StandardVariableApi.md#standardvariables_get) | **GET** /standardvariables | List all StandardVariable entities
*StandardVariableApi* | [**standardvariables_id_delete**](docs/endpoints/StandardVariableApi.md#standardvariables_id_delete) | **DELETE** /standardvariables/{id} | Delete a StandardVariable
*StandardVariableApi* | [**standardvariables_id_get**](docs/endpoints/StandardVariableApi.md#standardvariables_id_get) | **GET** /standardvariables/{id} | Get a StandardVariable
*StandardVariableApi* | [**standardvariables_id_put**](docs/endpoints/StandardVariableApi.md#standardvariables_id_put) | **PUT** /standardvariables/{id} | Update a StandardVariable
*StandardVariableApi* | [**standardvariables_post**](docs/endpoints/StandardVariableApi.md#standardvariables_post) | **POST** /standardvariables | Create a StandardVariable
*SubsidyApi* | [**subsidys_get**](docs/endpoints/SubsidyApi.md#subsidys_get) | **GET** /subsidys | List all Subsidy entities
*SubsidyApi* | [**subsidys_id_delete**](docs/endpoints/SubsidyApi.md#subsidys_id_delete) | **DELETE** /subsidys/{id} | Delete a Subsidy
*SubsidyApi* | [**subsidys_id_get**](docs/endpoints/SubsidyApi.md#subsidys_id_get) | **GET** /subsidys/{id} | Get a Subsidy
*SubsidyApi* | [**subsidys_id_put**](docs/endpoints/SubsidyApi.md#subsidys_id_put) | **PUT** /subsidys/{id} | Update a Subsidy
*SubsidyApi* | [**subsidys_post**](docs/endpoints/SubsidyApi.md#subsidys_post) | **POST** /subsidys | Create a Subsidy
*TheoryGuidedModelApi* | [**theory_guidedmodels_get**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_get) | **GET** /theory-guidedmodels | List all Theory-GuidedModel entities
*TheoryGuidedModelApi* | [**theory_guidedmodels_id_delete**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_id_delete) | **DELETE** /theory-guidedmodels/{id} | Delete a Theory-GuidedModel
*TheoryGuidedModelApi* | [**theory_guidedmodels_id_get**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_id_get) | **GET** /theory-guidedmodels/{id} | Get a Theory-GuidedModel
*TheoryGuidedModelApi* | [**theory_guidedmodels_id_put**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_id_put) | **PUT** /theory-guidedmodels/{id} | Update a Theory-GuidedModel
*TheoryGuidedModelApi* | [**theory_guidedmodels_post**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_post) | **POST** /theory-guidedmodels | Create a Theory-GuidedModel
*TimeIntervalApi* | [**timeintervals_get**](docs/endpoints/TimeIntervalApi.md#timeintervals_get) | **GET** /timeintervals | List all TimeInterval entities
*TimeIntervalApi* | [**timeintervals_id_delete**](docs/endpoints/TimeIntervalApi.md#timeintervals_id_delete) | **DELETE** /timeintervals/{id} | Delete a TimeInterval
*TimeIntervalApi* | [**timeintervals_id_get**](docs/endpoints/TimeIntervalApi.md#timeintervals_id_get) | **GET** /timeintervals/{id} | Get a TimeInterval
*TimeIntervalApi* | [**timeintervals_id_put**](docs/endpoints/TimeIntervalApi.md#timeintervals_id_put) | **PUT** /timeintervals/{id} | Update a TimeInterval
*TimeIntervalApi* | [**timeintervals_post**](docs/endpoints/TimeIntervalApi.md#timeintervals_post) | **POST** /timeintervals | Create a TimeInterval
*UnitApi* | [**units_get**](docs/endpoints/UnitApi.md#units_get) | **GET** /units | List all Unit entities
*UnitApi* | [**units_id_delete**](docs/endpoints/UnitApi.md#units_id_delete) | **DELETE** /units/{id} | Delete a Unit
*UnitApi* | [**units_id_get**](docs/endpoints/UnitApi.md#units_id_get) | **GET** /units/{id} | Get a Unit
*UnitApi* | [**units_id_put**](docs/endpoints/UnitApi.md#units_id_put) | **PUT** /units/{id} | Update a Unit
*UnitApi* | [**units_post**](docs/endpoints/UnitApi.md#units_post) | **POST** /units | Create a Unit
*VariableApi* | [**variables_get**](docs/endpoints/VariableApi.md#variables_get) | **GET** /variables | List all Variable entities
*VariableApi* | [**variables_id_delete**](docs/endpoints/VariableApi.md#variables_id_delete) | **DELETE** /variables/{id} | Delete a Variable
*VariableApi* | [**variables_id_get**](docs/endpoints/VariableApi.md#variables_id_get) | **GET** /variables/{id} | Get a Variable
*VariableApi* | [**variables_id_put**](docs/endpoints/VariableApi.md#variables_id_put) | **PUT** /variables/{id} | Update a Variable
*VariableApi* | [**variables_post**](docs/endpoints/VariableApi.md#variables_post) | **POST** /variables | Create a Variable
*VariablePresentationApi* | [**variablepresentations_get**](docs/endpoints/VariablePresentationApi.md#variablepresentations_get) | **GET** /variablepresentations | List all VariablePresentation entities
*VariablePresentationApi* | [**variablepresentations_id_delete**](docs/endpoints/VariablePresentationApi.md#variablepresentations_id_delete) | **DELETE** /variablepresentations/{id} | Delete a VariablePresentation
*VariablePresentationApi* | [**variablepresentations_id_get**](docs/endpoints/VariablePresentationApi.md#variablepresentations_id_get) | **GET** /variablepresentations/{id} | Get a VariablePresentation
*VariablePresentationApi* | [**variablepresentations_id_put**](docs/endpoints/VariablePresentationApi.md#variablepresentations_id_put) | **PUT** /variablepresentations/{id} | Update a VariablePresentation
*VariablePresentationApi* | [**variablepresentations_post**](docs/endpoints/VariablePresentationApi.md#variablepresentations_post) | **POST** /variablepresentations | Create a VariablePresentation
*VisualizationApi* | [**visualizations_get**](docs/endpoints/VisualizationApi.md#visualizations_get) | **GET** /visualizations | List all Visualization entities
*VisualizationApi* | [**visualizations_id_delete**](docs/endpoints/VisualizationApi.md#visualizations_id_delete) | **DELETE** /visualizations/{id} | Delete a Visualization
*VisualizationApi* | [**visualizations_id_get**](docs/endpoints/VisualizationApi.md#visualizations_id_get) | **GET** /visualizations/{id} | Get a Visualization
*VisualizationApi* | [**visualizations_id_put**](docs/endpoints/VisualizationApi.md#visualizations_id_put) | **PUT** /visualizations/{id} | Update a Visualization
*VisualizationApi* | [**visualizations_post**](docs/endpoints/VisualizationApi.md#visualizations_post) | **POST** /visualizations | Create a Visualization
*DefaultApi* | [**user_login_get**](docs/endpoints/DefaultApi.md#user_login_get) | **GET** /user/login | 


## Documentation For Models

 - [CausalDiagram](docs/endpoints/CausalDiagram.md)
 - [ConfigurationSetup](docs/endpoints/ConfigurationSetup.md)
 - [DatasetSpecification](docs/endpoints/DatasetSpecification.md)
 - [EmpiricalModel](docs/endpoints/EmpiricalModel.md)
 - [Emulator](docs/endpoints/Emulator.md)
 - [Equation](docs/endpoints/Equation.md)
 - [FarmingPractices](docs/endpoints/FarmingPractices.md)
 - [FundingInformation](docs/endpoints/FundingInformation.md)
 - [GeoCoordinates](docs/endpoints/GeoCoordinates.md)
 - [GeoShape](docs/endpoints/GeoShape.md)
 - [Grid](docs/endpoints/Grid.md)
 - [HybridModel](docs/endpoints/HybridModel.md)
 - [ICASAVariable](docs/endpoints/ICASAVariable.md)
 - [Image](docs/endpoints/Image.md)
 - [Intervention](docs/endpoints/Intervention.md)
 - [Model](docs/endpoints/Model.md)
 - [ModelConfiguration](docs/endpoints/ModelConfiguration.md)
 - [ModelConfigurationSetup](docs/endpoints/ModelConfigurationSetup.md)
 - [NumericalIndex](docs/endpoints/NumericalIndex.md)
 - [Organization](docs/endpoints/Organization.md)
 - [Parameter](docs/endpoints/Parameter.md)
 - [Person](docs/endpoints/Person.md)
 - [PointBasedGrid](docs/endpoints/PointBasedGrid.md)
 - [Process](docs/endpoints/Process.md)
 - [Region](docs/endpoints/Region.md)
 - [SVOVariable](docs/endpoints/SVOVariable.md)
 - [SampleCollection](docs/endpoints/SampleCollection.md)
 - [SampleExecution](docs/endpoints/SampleExecution.md)
 - [SampleResource](docs/endpoints/SampleResource.md)
 - [Software](docs/endpoints/Software.md)
 - [SoftwareConfiguration](docs/endpoints/SoftwareConfiguration.md)
 - [SoftwareImage](docs/endpoints/SoftwareImage.md)
 - [SoftwareVersion](docs/endpoints/SoftwareVersion.md)
 - [SourceCode](docs/endpoints/SourceCode.md)
 - [SpatialResolution](docs/endpoints/SpatialResolution.md)
 - [SpatiallyDistributedGrid](docs/endpoints/SpatiallyDistributedGrid.md)
 - [StandardVariable](docs/endpoints/StandardVariable.md)
 - [Subsidy](docs/endpoints/Subsidy.md)
 - [TheoryGuidedModel](docs/endpoints/TheoryGuidedModel.md)
 - [TimeInterval](docs/endpoints/TimeInterval.md)
 - [Unit](docs/endpoints/Unit.md)
 - [User](docs/endpoints/User.md)
 - [Variable](docs/endpoints/Variable.md)
 - [VariablePresentation](docs/endpoints/VariablePresentation.md)
 - [Visualization](docs/endpoints/Visualization.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication (JWT)


## Author




