# coding: utf-8

"""
    Influx API Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    OpenAPI spec version: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from influxdb_client.api_client import ApiClient


class TelegrafsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_telegrafs_id(self, telegraf_id, **kwargs):  # noqa: E501
        """Delete a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501
        """Delete a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telegrafs_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_telegrafs_id_labels_id(self, telegraf_id, label_id, **kwargs):  # noqa: E501
        """Delete a label from a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_labels_id(telegraf_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_labels_id_with_http_info(telegraf_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_labels_id_with_http_info(telegraf_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_labels_id_with_http_info(self, telegraf_id, label_id, **kwargs):  # noqa: E501
        """Delete a label from a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_labels_id_with_http_info(telegraf_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'label_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telegrafs_id_labels_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_telegrafs_id_labels_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_telegrafs_id_members_id(self, user_id, telegraf_id, **kwargs):  # noqa: E501
        """Remove a member from a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_members_id(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_members_id_with_http_info(self, user_id, telegraf_id, **kwargs):  # noqa: E501
        """Remove a member from a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user_id', 'telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telegrafs_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_telegrafs_id_members_id`")  # noqa: E501
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_telegrafs_id_owners_id(self, user_id, telegraf_id, **kwargs):  # noqa: E501
        """Remove an owner from a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_owners_id(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_owners_id_with_http_info(self, user_id, telegraf_id, **kwargs):  # noqa: E501
        """Remove an owner from a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user_id', 'telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telegrafs_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_telegrafs_id_owners_id`")  # noqa: E501
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telegrafs(self, **kwargs):  # noqa: E501
        """get_telegrafs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: The organization ID the Telegraf config belongs to.
        :return: Telegrafs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_telegrafs_with_http_info(self, **kwargs):  # noqa: E501
        """get_telegrafs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: The organization ID the Telegraf config belongs to.
        :return: Telegrafs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['zap_trace_span', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Telegrafs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telegrafs_id(self, telegraf_id, **kwargs):  # noqa: E501
        """Retrieve a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str accept:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501
        """Retrieve a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str accept:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span', 'accept']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/toml', 'application/json', 'application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telegrafs_id_labels(self, telegraf_id, **kwargs):  # noqa: E501
        """List all labels for a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_labels(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_labels_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_labels_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_labels_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501
        """List all labels for a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_labels_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telegrafs_id_members(self, telegraf_id, **kwargs):  # noqa: E501
        """List all users with member privileges for a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_members(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_members_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_members_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_members_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501
        """List all users with member privileges for a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_members_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telegrafs_id_owners(self, telegraf_id, **kwargs):  # noqa: E501
        """List all owners of a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_owners(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_owners_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_owners_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_owners_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501
        """List all owners of a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_owners_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_telegrafs(self, telegraf_request, **kwargs):  # noqa: E501
        """Create a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs(telegraf_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TelegrafRequest telegraf_request: Telegraf config to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_with_http_info(telegraf_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_with_http_info(telegraf_request, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_with_http_info(self, telegraf_request, **kwargs):  # noqa: E501
        """Create a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_with_http_info(telegraf_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TelegrafRequest telegraf_request: Telegraf config to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_request', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telegrafs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_request' is set
        if ('telegraf_request' not in local_var_params or
                local_var_params['telegraf_request'] is None):
            raise ValueError("Missing the required parameter `telegraf_request` when calling `post_telegrafs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'telegraf_request' in local_var_params:
            body_params = local_var_params['telegraf_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Telegraf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_telegrafs_id_labels(self, telegraf_id, label_mapping, **kwargs):  # noqa: E501
        """Add a label to a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_labels(telegraf_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_labels_with_http_info(telegraf_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_labels_with_http_info(telegraf_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_labels_with_http_info(self, telegraf_id, label_mapping, **kwargs):  # noqa: E501
        """Add a label to a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_labels_with_http_info(telegraf_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telegrafs_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_telegrafs_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_telegrafs_id_members(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add a member to a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_members(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_members_with_http_info(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add a member to a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telegrafs_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_telegrafs_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_telegrafs_id_owners(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add an owner to a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_owners(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_owners_with_http_info(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501
        """Add an owner to a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telegrafs_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_telegrafs_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_telegrafs_id(self, telegraf_id, telegraf_request, **kwargs):  # noqa: E501
        """Update a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_telegrafs_id(telegraf_id, telegraf_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param TelegrafRequest telegraf_request: Telegraf config update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_telegrafs_id_with_http_info(telegraf_id, telegraf_request, **kwargs)  # noqa: E501
        else:
            (data) = self.put_telegrafs_id_with_http_info(telegraf_id, telegraf_request, **kwargs)  # noqa: E501
            return data

    def put_telegrafs_id_with_http_info(self, telegraf_id, telegraf_request, **kwargs):  # noqa: E501
        """Update a Telegraf config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_telegrafs_id_with_http_info(telegraf_id, telegraf_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param TelegrafRequest telegraf_request: Telegraf config update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['telegraf_id', 'telegraf_request', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telegrafs_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `put_telegrafs_id`")  # noqa: E501
        # verify the required parameter 'telegraf_request' is set
        if ('telegraf_request' not in local_var_params or
                local_var_params['telegraf_request'] is None):
            raise ValueError("Missing the required parameter `telegraf_request` when calling `put_telegrafs_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'telegraf_request' in local_var_params:
            body_params = local_var_params['telegraf_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Telegraf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
