# API

The great flexibility of `imc` comes from the ability to compose workflows using the API.

It provides a rich but abstract `imc.analysis.Project` object and implements various modules building on it depending on the data type.

In addition, the `imc.operations` module contains several analysis-independent methods and the `imc.utils` module provides low-level functions of general use.

## imc.data_models.project
```{eval-rst}
.. automodule:: imc.data_models.project
   :members:
```

## imc.data_models.sample
```{eval-rst}
.. automodule:: imc.data_models.sample
   :members:
```

## imc.data_models.roi
```{eval-rst}
.. automodule:: imc.data_models.roi
   :members:
```

## imc.operations
### imc.ops.signal
```{eval-rst}
.. automodule:: imc.ops.signal
   :members:
```
### imc.ops.compensation
```{eval-rst}
.. automodule:: imc.ops.compensation
   :members:
```
### imc.ops.mixture
```{eval-rst}
.. automodule:: imc.ops.mixture
   :members:
```
### imc.ops.domain
```{eval-rst}
.. automodule:: imc.ops.domain
   :members:
```
### imc.ops.quant
```{eval-rst}
.. automodule:: imc.ops.quant
   :members:
```
### imc.ops.clustering
```{eval-rst}
.. automodule:: imc.ops.clustering
   :members:
```
### imc.ops.adjacency
```{eval-rst}
.. automodule:: imc.ops.adjacency
   :members:
```
### imc.ops.community
```{eval-rst}
.. automodule:: imc.ops.community
   :members:
```
## imc.graphics
```{eval-rst}
.. automodule:: imc.graphics
   :members:
```

## imc.utils
```{eval-rst}
.. automodule:: imc.utils
   :members:
```

## imc.types
```{eval-rst}
.. automodule:: imc.types
   :members:
```