from collections.abc import Mapping, Set
from typing import Any

class NodeView(Mapping, Set):
    def __init__(self, graph) -> None: ...
    def __len__(self): ...
    def __iter__(self): ...
    def __getitem__(self, n): ...
    def __contains__(self, n): ...
    def __call__(self, data: bool = ..., default: Any | None = ...): ...
    def data(self, data: bool = ..., default: Any | None = ...): ...

class NodeDataView(Set):
    def __init__(
        self, nodedict, data: bool = ..., default: Any | None = ...
    ) -> None: ...
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, n): ...
    def __getitem__(self, n): ...

class DiDegreeView:
    def __init__(
        self, G, nbunch: Any | None = ..., weight: Any | None = ...
    ) -> None: ...
    def __call__(self, nbunch: Any | None = ..., weight: Any | None = ...): ...
    def __getitem__(self, n): ...
    def __iter__(self): ...
    def __len__(self): ...

class DegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class OutDegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class InDegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class MultiDegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class DiMultiDegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class InMultiDegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class OutMultiDegreeView(DiDegreeView):
    def __getitem__(self, n): ...
    def __iter__(self): ...

class OutEdgeDataView:
    def __init__(
        self,
        viewer,
        nbunch: Any | None = ...,
        data: bool = ...,
        default: Any | None = ...,
    ): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, e): ...

class EdgeDataView(OutEdgeDataView):
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, e): ...

class InEdgeDataView(OutEdgeDataView):
    def __iter__(self): ...
    def __contains__(self, e): ...

class OutMultiEdgeDataView(OutEdgeDataView):
    keys: Any
    def __init__(
        self,
        viewer,
        nbunch: Any | None = ...,
        data: bool = ...,
        keys: bool = ...,
        default: Any | None = ...,
    ): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, e): ...

class MultiEdgeDataView(OutMultiEdgeDataView):
    def __iter__(self): ...
    def __contains__(self, e): ...

class InMultiEdgeDataView(OutMultiEdgeDataView):
    def __iter__(self): ...
    def __contains__(self, e): ...

class OutEdgeView(Set, Mapping):
    dataview: Any
    def __init__(self, G) -> None: ...
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, e): ...
    def __getitem__(self, e): ...
    def __call__(
        self, nbunch: Any | None = ..., data: bool = ..., default: Any | None = ...
    ): ...
    def data(
        self, data: bool = ..., default: Any | None = ..., nbunch: Any | None = ...
    ): ...

class EdgeView(OutEdgeView):
    dataview: Any
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, e): ...

class InEdgeView(OutEdgeView):
    dataview: Any
    def __init__(self, G) -> None: ...
    def __iter__(self): ...
    def __contains__(self, e): ...
    def __getitem__(self, e): ...

class OutMultiEdgeView(OutEdgeView):
    dataview: Any
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, e): ...
    def __getitem__(self, e): ...
    def __call__(
        self,
        nbunch: Any | None = ...,
        data: bool = ...,
        keys: bool = ...,
        default: Any | None = ...,
    ): ...
    def data(
        self,
        data: bool = ...,
        keys: bool = ...,
        default: Any | None = ...,
        nbunch: Any | None = ...,
    ): ...

class MultiEdgeView(OutMultiEdgeView):
    dataview: Any
    def __len__(self): ...
    def __iter__(self): ...

class InMultiEdgeView(OutMultiEdgeView):
    dataview: Any
    def __init__(self, G) -> None: ...
    def __iter__(self): ...
    def __contains__(self, e): ...
    def __getitem__(self, e): ...
