from collections.abc import Generator
from typing import Any

def flow_matrix_row(
    G, weight: Any | None = ..., dtype=..., solver: str = ...
) -> Generator[Any, None, None]: ...

class InverseLaplacian:
    dtype: Any
    n: Any
    w: Any
    C: Any
    L1: Any
    def __init__(self, L, width: Any | None = ..., dtype: Any | None = ...) -> None: ...
    def init_solver(self, L) -> None: ...
    def solve(self, r) -> None: ...
    def solve_inverse(self, r) -> None: ...
    def get_rows(self, r1, r2): ...
    def get_row(self, r): ...
    def width(self, L): ...

class FullInverseLaplacian(InverseLaplacian):
    IL: Any
    def init_solver(self, L) -> None: ...
    def solve(self, rhs): ...
    def solve_inverse(self, r): ...

class SuperLUInverseLaplacian(InverseLaplacian):
    lusolve: Any
    def init_solver(self, L) -> None: ...
    def solve_inverse(self, r): ...
    def solve(self, rhs): ...

class CGInverseLaplacian(InverseLaplacian):
    M: Any
    def init_solver(self, L) -> None: ...
    def solve(self, rhs): ...
    def solve_inverse(self, r): ...
