# Generated by Django 4.2.7 on 2024-11-07 07:47

from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields


def add_default_languages(apps, schema_editor):
    CapSetting = apps.get_model('capeditor', 'CapSetting')
    AlertLanguage = apps.get_model('capeditor', 'AlertLanguage')

    cap_settings = CapSetting.objects.all()

    for cap_setting in cap_settings:
        AlertLanguage.objects.create(
            setting=cap_setting,
            code='en',
            name='English',
            sort_order=0,
        )
        AlertLanguage.objects.create(
            setting=cap_setting,
            code='fr',
            name='French',
            sort_order=1,
        )


def backwards(apps, schema_editor):
    """nothing to do"""
    pass


class Migration(migrations.Migration):
    dependencies = [
        ('capeditor', '0010_alter_capsetting_un_country_boundary_geojson'),
    ]

    operations = [
        migrations.CreateModel(
            name='AlertLanguage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('code',
                 models.CharField(help_text='ISO 639-1 language code', max_length=10, verbose_name='Language Code')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Language Name')),
                ('setting', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.PROTECT,
                                                            related_name='alert_languages', to='capeditor.capsetting')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.RunPython(add_default_languages, backwards),
    ]
