# Copyright (c) 2019 Dell Inc. or its subsidiaries.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""performance_constants.py"""

# Unisphere REST performance constants
PERFORMANCE = 'performance'
CATEGORY = 'category'
CATEGORIES = 'categories'
KEYS = 'keys'
METRICS = 'metrics'
METRIC = 'metric'
METRICS_ALL = 'metrics_all'
METRICS_KPI = 'metrics_kpi'
KPI = 'kpi'
ALL = 'all'
AVERAGE = 'Average'
MAXIMUM = 'Maximum'
LIST = 'list'
UPDATE = 'update'
START_DATE = 'startDate'
END_DATE = 'endDate'
FA_DATE = 'firstAvailableDate'
LA_DATE = 'lastAvailableDate'
DATA_FORMAT = 'dataFormat'
RESULT = 'result'
REP_LEVEL = 'reporting_level'
ONE_MINUTE = 60000
ONE_HOUR = 3600000

# Director Tags
BE_DIR_TAGS = ['DF', 'DX']
FE_DIR_TAGS = ['EF', 'FA', 'FE', 'SE']
RDF_DIR_TAGS = ['RF', 'RE']
IM_DIR_TAGS = ['IM']
EDS_DIR_TAGS = ['ED']

# Performance categories and keys
ARRAY = 'Array'
ARRAY_ID = 'array_id'
ARRAY_INFO = 'arrayInfo'
BE_DIR = 'BEDirector'
BE_DIR_INFO = 'beDirectorInfo'
BE_EMU = 'BeEmulation'
BE_EMU_ID = 'beEmulationId'
BE_EMU_INFO = 'beEmulationInfo'
BE_PORT = 'BEPort'
BE_PORT_INFO = 'bePortInfo'
BOARD = 'Board'
BOARD_ID = 'boardId'
BOARD_INFO = 'boardInfo'
CACHE_PART = 'CachePartition'
CACHE_PART_ID = 'cachePartitionId'
CACHE_PART_INFO = 'cachePartitionInfo'
CORE = 'Core'
CORE_ID = 'coreId'
CORE_INFO = 'coreInfo'
DAYS_TO_FULL = 'daystofull'
DAYS_TO_FULL_RESULT = 'daysToFullObjectResultType'
DB = 'Database'
DB_ID = 'databaseId'
DB_INFO = 'databaseInfo'
DEV_GRP = 'DeviceGroup'
DEV_GRP_ID = 'deviceGroupId'
DEV_GRP_INFO = 'deviceGroupInfo'
DIR_ID = 'directorId'
DISK = 'Disk'
DISK_ID = 'diskId'
DISK_INFO = 'diskInfo'
DISK_GRP = 'DiskGroup'
DISK_GRP_ID = 'diskGroupId'
DISK_GRP_INFO = 'diskGroupInfo'
DISK_TECH = 'diskTechnology'
DISK_TECH_POOL = 'DiskTechPool'
DISK_TECH_POOL_INFO = 'diskTechPoolInfo'
EDS_DIR = 'EDSDirector'
EDS_DIR_INFO = 'edsDirectorInfo'
EDS_EMU = 'EDSEmulation'
EDS_EMU_ID = 'edsEmulationId'
EDS_EMU_INFO = 'edsEmulationInfo'
EXT_DIR = 'ExternalDirector'
EXT_DIR_INFO = 'externalDirectorInfo'
EXT_DISK = 'ExternalDisk'
EXT_DISK_INFO = 'externalDiskInfo'
EXT_DISK_GRP = 'ExternalDiskGroup'
EXT_DISK_GRP_INFO = 'externalDiskGroupInfo'
EXT_PORT = 'ExternalPort'
FE_DIR = 'FEDirector'
FE_DIR_INFO = 'feDirectorInfo'
FE_EMU = 'FeEmulation'
FE_EMU_ID = 'feEmulationId'
FE_EMU_INFO = 'feEmulationInfo'
FE_PORT = 'FEPort'
FE_PORT_INFO = 'fePortInfo'
FICON_EMU = 'FiconEmulation'
FICON_EMU_ID = 'ficonEmulationId'
FICON_EMU_INFO = 'ficonEmulationInfo'
FICON_EMU_THR = 'FiconEmulationThread'
FICON_EMU_THR_ID = 'ficonEmulationThreadId'
FICON_EMU_THR_INFO = 'ficonEmulationThreadInfo'
FICON_PORT_THR = 'FiconPortThread'
FICON_PORT_THR_ID = 'ficonPortThreadId'
FICON_PORT_THR_INFO = 'ficonPortThreadInfo'
HOST = 'Host'
HOST_ID = 'hostId'
HOST_INFO = 'hostInfo'
IM_DIR = 'IMDirector'
IM_DIR_INFO = 'imDirectorInfo'
IM_EMU = 'IMEmulation'
IM_EMU_ID = 'imEmulationId'
IM_EMU_INFO = 'iMEmulationInfo'
INIT = 'Initiator'
INIT_ID = 'initiatorId'
INIT_INFO = 'initiatorInfo'
INIT_BY_PORT = 'InitiatorByPort'
INIT_BY_PORT_ID = 'initiatorByPortId'
INIT_BY_PORT_INFO = 'initiatorByPortInfo'
IP_INT = 'IPInterface'
IP_INT_ID = 'ipInterfaceId'
ISCSI_CLIENT_INFO = 'iSCSIClientInfo'
ISCSI_TGT = 'ISCSITarget'
ISCSI_TGT_ID_KEY = 'iscsiTargetId'
ISCSI_TGT_ID_METRICS = 'iSCSITargetId'
ISCSI_TGT_INFO = 'iSCSITargetInfo'
PG = 'PortGroup'
PG_ID = 'portGroupId'
PG_INFO = 'portGroupInfo'
POOL_ID = 'poolId'
POOL_INFO = 'poolInfo'
PORT_ID = 'portId'
PROJECTION = 'projection'
RA_GRP_ID = 'raGroupId'
RA_GRP_INFO = 'raGroupId'
REG_DETAILS = 'registrationdetails'
REG_DETAILS_INFO = 'registrationDetailsInfo'
REG_DIAGNOSTIC = 'diagnostic'
RDF_DIR = 'RDFDirector'
RDF_DIR_INFO = 'rdfDirectorInfo'
RDF_EMU = 'RDFEmulation'
RDF_EMU_ID = 'rdfEmulationId'
RDF_EMU_INFO = 'rdfEmulationInfo'
RDF_PORT = 'RDFPort'
RDF_PORT_INFO = 'rdfPortInfo'
RDFA = 'RDFA'
RDFA_INFO = 'rdfaInfo'
RDFS = 'RDFS'
RDFS_INFO = 'rdfsInfo'
SG = 'StorageGroup'
SG_ID = 'storageGroupId'
SG_INFO = 'storageGroupInfo'
SG_BY_POOL = 'StorageGroupByPool'
SRP = 'SRP'
SRP_ID = 'srpId'
SRP_INFO = 'srpInfo'
STORAGE_CONT = 'StorageContainer'
STORAGE_CONT_ID = 'storageContainerId'
STORAGE_CONT_INFO = 'storageContainerInfo'
STORAGE_RES = 'StorageResource'
STORAGE_RES_ID = 'storageResourceId'
STORAGE_RES_INFO = 'storageResourceInfo'
STORAGE_RES_BY_POOL = 'StorageResourceByPool'
STORAGE_TIER = 'StorageTier'
SUMMARY = 'Summary'
SYMM_ID = 'symmetrixId'
THIN_POOL = 'ThinPool'

# Threshold constants
ALERT = 'alert'
ALERT_ERR = 'alertError'
THRESHOLD = 'threshold'
PERF_THRESH = 'performanceThreshold'
THRESH_CAT = 'endpoint'
INFO_LVL = 'INFORMATION'
WARN_LVL = 'WARNING'
CRIT_LVL = 'CRITICAL'
FIRST_THRESH = 'firstThreshold'
FIRST_THRESH_OCC = 'firstThresholdOccurrrences'
FIRST_THRESH_SAMP = 'firstThresholdSamples'
FIRST_THRESH_SEV = 'firstThresholdSeverity'
SEC_THRESH = 'secondThreshold'
SEC_THRESH_OCC = 'secondThresholdOccurrrences'
SEC_THRESH_SAMP = 'secondThresholdSamples'
SEC_THRESH_SEV = 'secondThresholdSeverity'
