# Copyright (c) 2019 Dell Inc. or its subsidiaries.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""performance_category_map.py."""

performance_data = {
    'ARRAY': {
        'category': 'Array',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'CriticalAlertCount', 'InfoAlertCount', 'WarningAlertCount',
            'AllocatedCapacity', 'AllocatedCapacityTB',
            'SubscribedAllocatedCapGB', 'SubscribedAllocatedCapTB',
            'AvgFallThruTime', 'Cache_Balance', 'DA_Balance', 'DX_Balance',
            'EFD_Balance', 'FC_Balance', 'FE_Balance', 'RDF_Balance',
            'SATA_Balance', 'SCM_Balance', 'BEIOs', 'BEReadReqs',
            'BEUtilization', 'BEWriteReqs', 'CapacityHS',
            'OverallCompressionRatio', 'CopySlotCount',
            'DeviceWPEvents', 'DiskUtilization', 'OverallEfficiencyRatio',
            'FEReadReqs', 'FEUtilization', 'FEWriteReqs', 'HostMBs',
            'FEHitReqs', 'HWConfigHS', 'HardwareHealthScore', 'HostIOs',
            'HostMBReads', 'HostMBWritten', 'AvgOptimizedReadMissSize',
            'OptimizedMBReadMisses', 'OptimizedReadMisses',
            'OverallHealthScore', 'PercentEffectiveUsedCapacity', 'PercentHit',
            'PercentMetaBEUsed', 'PercentMetaFEUsed', 'PercentMetaRepUsed',
            'PercentMetaSystemUsed', 'PercentReads', 'PercentSnapshotSaved',
            'PercentSubscribedCapacity', 'PercentVPSaved', 'PercentWrites',
            'PrefetchedTracks', 'QueueDepthUtilization', 'RDFA_WPCount',
            'RDFUtilization', 'HostReads', 'FEReadHitReqs', 'FEReadMissReqs',
            'FEReqs', 'ReadResponseTime', 'WriteResponseTime',
            'SloHealthScore', 'SnapCapGB', 'SnapCapTB',
            'SnapshotCompressionRatio', 'SnapshotEfficiencyRatio',
            'SnapModifiedCapGB', 'SnapModifiedCapTB', 'SnapshotSharedRatio',
            'SubscribedCapacity', 'SubscribedCapacityTB',
            'SoftwareHealthScore', 'SystemWPEvents', 'BEReqs',
            'PercentCacheWP', 'UsableCapacity', 'UsableCapacityTB',
            'UsedUsableCapGB', 'UsedUsableCapTB', 'VPCompressionRatio',
            'VPEfficiencyRatio', 'VPSharedRatio', 'WPCount',
            'SystemMaxWPLimit', 'HostWrites', 'FEWriteHitReqs',
            'FEWriteMissReqs'],
        'metrics_kpi': [
            'AllocatedCapacity', 'AllocatedCapacityTB',
            'SubscribedAllocatedCapTB', 'Cache_Balance', 'DA_Balance',
            'DX_Balance', 'EFD_Balance', 'FC_Balance', 'FE_Balance',
            'RDF_Balance', 'SATA_Balance', 'SCM_Balance', 'BEIOs',
            'BEUtilization', 'OverallCompressionRatio', 'DiskUtilization',
            'FEUtilization', 'HostMBs', 'HostIOs', 'PercentHit',
            'PercentMetaBEUsed', 'PercentMetaFEUsed', 'PercentMetaRepUsed',
            'PercentMetaSystemUsed', 'PercentReads', 'PercentWrites',
            'RDFUtilization', 'ReadResponseTime', 'WriteResponseTime',
            'SnapCapTB', 'SnapModifiedCapTB', 'SubscribedCapacityTB',
            'SystemWPEvents', 'PercentCacheWP', 'UsableCapacityTB',
            'UsedUsableCapTB', 'WPCount', 'SystemMaxWPLimit']},
    'BEDIRECTOR': {
        'category': 'BEDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgTimePerSyscall', 'CompressedMBs', 'CompressedReadMBs',
            'CompressedWriteMBs', 'CompressedReadReqs', 'CompressedReqs',
            'CompressedWriteReqs', 'IOs', 'MBs', 'MBRead', 'MBWritten',
            'PercentBusy', 'PercentBusyLogicalCore_0',
            'PercentBusyLogicalCore_1', 'PercentNonIOBusy',
            'PercentNonIOBusyLogicalCore_0', 'PercentNonIOBusyLogicalCore_1',
            'PercentReadReqs', 'PercentWriteReqs', 'PrefetchedTracks',
            'ReadReqs', 'Reqs', 'SyscallCount', 'Syscall_RDF_DirCount',
            'SyscallRemoteDirCount', 'WriteReqs'],
        'metrics_kpi': [
            'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'PercentNonIOBusy', 'ReadReqs', 'Reqs', 'SyscallCount',
            'WriteReqs']},
    'BEEMULATION': {
        'category': 'BeEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'BEPORT': {
        'category': 'BEPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MaxSpeedGBs', 'MBs', 'MBRead', 'MBWritten',
            'PercentBusy', 'Reads', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'Reads', 'Writes']},
    'BOARD': {
        'category': 'Board',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'InboundMBs', 'MaxSpeedMBs', 'OutboundMBs', 'InterConnect'],
        'metrics_kpi': [
            'InboundMBs', 'MaxSpeedMBs', 'OutboundMBs', 'InterConnect']},
    'CORE': {
        'category': 'Core',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': ['PercentBusy', 'SymmkIdleTime'],
        'metrics_kpi': ['PercentBusy']},
    'CACHEPARTITION': {
        'category': 'CachePartition',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AcquiredSlotCount', 'AgeNonWPSlots', 'AvgAgeGivenDestage',
            'AvgAgeOfWriteToNonWPSlots', 'CacheAgeGT_10_Min',
            'CacheAgeGT_1_Hour', 'CacheAgeGT_1_Min', 'CacheHitAges_1',
            'CacheHitAges_2', 'CacheHitAges_3', 'CacheHitAges_4',
            'CacheHitAges_5', 'CacheHitAges_6', 'CacheHitAges_7',
            'CacheHitAges_8', 'CacheSlotAges_1', 'CacheSlotAges_2',
            'CacheSlotAges_3', 'CacheSlotAges_4', 'CacheSlotAges_5',
            'CacheSlotAges_6', 'CacheSlotAges_7', 'CacheSlotAges_8',
            'CacheSlotsUsed', 'DestageSlotAge', 'DestagedSlotCount',
            'DonationGiveCount', 'DonationTakeCount', 'DonationTime',
            'HostIOs', 'LocalWPCount', 'PercentMaxCache', 'HostMBs',
            'PercentMinCache', 'PercentWPUtilization', 'PercentHit',
            'RemoteWPCount', 'PercentCacheUsed', 'PercentTargetCache',
            'TotalReplaceSlots', 'WPCount', 'SystemMaxWPLimit',
            'WritesToAllNonWPSlots', 'WritesToYoungNonWPSlots'],
        'metrics_kpi': [
            'CacheSlotsUsed', 'HostIOs', 'PercentMaxCache', 'HostMBs',
            'PercentMinCache', 'PercentWPUtilization', 'PercentHit',
            'PercentTargetCache', 'WPCount', 'SystemMaxWPLimit']},
    'DATABASE': {
        'category': 'Database',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'CriticalAlertCount', 'InfoAlertCount', 'WarningAlertCount',
            'AllocatedCapacity', 'BEReadRequestTime', 'BEReadTaskTime',
            'AvgIOSize', 'AvgReadResponseTime6', 'AvgReadResponseTime7',
            'AvgReadSize', 'AvgWritePacedDelay', 'AvgWriteResponseTime6',
            'AvgWriteResponseTime7', 'AvgWriteSize', 'BEMBReads',
            'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedTrackss', 'BEPrefetchedTrackUsed',
            'BEReadReqs', 'BEWriteReqs', 'BlockSize', 'HostMBs', 'IODensity',
            'HostIOs', 'MaxWPThreshold', 'HostMBReads', 'HostMBWritten',
            'PercentHit', 'PercentMisses', 'PercentRandomIO',
            'PercentRandomReads', 'PercentRandomReadHit',
            'PercentRandomReadMiss', 'PercentRandomWrites',
            'PercentRandomWriteHit', 'PercentRandomWriteMiss', 'PercentRead',
            'PercentReadHit', 'PercentReadMiss', 'PercentSeqIO',
            'PercentSeqRead', 'PercentSeqReadHit', 'PercentSeqReadMiss',
            'PercentSeqWrites', 'PercentSeqWriteHit', 'PercentSeqWriteMiss',
            'PercentWrite', 'PercentWriteHit', 'PercentWriteMiss',
            'BEPrefetchedMBs', 'RandomIOs', 'RandomReadHits',
            'RandomReadMisses', 'RandomReads', 'RandomWriteHits',
            'RandomWriteMisses', 'RandomWrites', 'IOServiceTimeLong',
            'IOServiceTimeShort', 'MaxIOServiceTime', 'RdfMBRead',
            'RdfMBWritten', 'MinIOServiceTime', 'RdfReads', 'RdfReadHits',
            'RdfResponseTime', 'RDFRewrites', 'RdfWrites', 'HostReads',
            'HostReadHits', 'HostReadMisses', 'ReadResponseTimeCount1',
            'ReadResponseTimeCount2', 'ReadResponseTimeCount3',
            'ReadResponseTimeCount4', 'ReadResponseTimeCount5',
            'ReadResponseTimeCount6', 'ReadResponseTimeCount7', 'ResponseTime',
            'RDFS_WriteResponseTime', 'ReadMissResponseTime',
            'ReadResponseTime', 'WriteMissResponseTime', 'WriteResponseTime',
            'SeqReadHits', 'SeqReadMisses', 'SeqReads', 'SeqWriteHits',
            'SeqWriteMisses', 'SeqWrites', 'Skew', 'BEReqs', 'HostHits',
            'HostMisses', 'SeqIOs', 'WPCount', 'HostWrites', 'HostWriteHits',
            'HostWriteMisses', 'WritePacedDelay', 'WriteResponseTimeCount1',
            'WriteResponseTimeCount2', 'WriteResponseTimeCount3',
            'WriteResponseTimeCount4', 'WriteResponseTimeCount5',
            'WriteResponseTimeCount6', 'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEWriteReqs', 'HostMBs',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite', 'RdfResponseTime',
            'HostReads', 'ResponseTime', 'RDFS_WriteResponseTime',
            'ReadResponseTime', 'WriteResponseTime', 'BEReqs', 'HostHits',
            'HostMisses', 'WPCount', 'HostWrites', 'WritePacedDelay']},
    'DEVICEGROUP': {
        'category': 'DeviceGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AllocatedCapacity', 'BEReadRequestTime', 'BEReadTaskTime',
            'AvgIOSize', 'AvgReadSize', 'AvgWritePacedDelay', 'AvgWriteSize',
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedTrackss', 'BEPrefetchedTrackUsed',
            'BEReadReqs', 'BEWriteReqs', 'BERdfCopyMB', 'BERdfCopy',
            'BlockSize', 'HostMBs', 'IODensity', 'HostIOs', 'MaxWPThreshold',
            'HostMBReads', 'HostMBWritten', 'PercentHit', 'PercentMisses',
            'PercentRandomIO', 'PercentRandomReads', 'PercentRandomReadHit',
            'PercentRandomReadMiss', 'PercentRandomWrites',
            'PercentRandomWriteHit', 'PercentRandomWriteMiss', 'PercentRead',
            'PercentReadHit', 'PercentReadMiss', 'PercentSeqIO',
            'PercentSeqRead', 'PercentSeqReadHit', 'PercentSeqReadMiss',
            'PercentSeqWrites', 'PercentSeqWriteHit', 'PercentSeqWriteMiss',
            'PercentWrite', 'PercentWriteHit', 'PercentWriteMiss',
            'BEPrefetchedMBs', 'RandomIOs', 'RandomReadHits',
            'RandomReadMisses', 'RandomReads', 'RandomWriteHits',
            'RandomWriteMisses', 'RandomWrites', 'RdfMBRead', 'RdfMBWritten',
            'RdfReads', 'RdfResponseTime', 'RDFRewrites', 'RdfWrites',
            'HostReads', 'HostReadHits', 'HostReadMisses', 'ResponseTime',
            'RDFS_WriteResponseTime', 'ReadMissResponseTime',
            'ReadResponseTime', 'WriteMissResponseTime', 'WriteResponseTime',
            'SeqReadHits', 'SeqReadMisses', 'SeqReads', 'SeqWriteHits',
            'SeqWriteMisses', 'SeqWrites', 'BEReqs', 'HostHits', 'HostMisses',
            'SeqIOs', 'WPCount', 'HostWrites', 'HostWriteHits',
            'HostWriteMisses', 'WritePacedDelay'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEWriteReqs', 'HostMBs',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite', 'RandomIOs',
            'RandomReads', 'RandomWrites', 'RdfResponseTime', 'HostReads',
            'ResponseTime', 'RDFS_WriteResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'SeqReads', 'SeqWrites', 'BEReqs', 'HostHits',
            'HostMisses', 'SeqIOs', 'WPCount', 'HostWrites',
            'WritePacedDelay']},
    'DISK': {
        'category': 'Disk',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AvgHypersPerSeek', 'AvgReadSize', 'AvgWriteSize', 'AvgQueueDepth',
            'IOs', 'MBs', 'MBReads', 'MBWritten', 'PercentBusy', 'PercentIdle',
            'PercentCapacityFree', 'PercentCapacityUsed', 'DiskReads',
            'AvgResponseTime', 'ReadResponseTime', 'WriteResponseTime',
            'TotalSCSICommands', 'TotalCapacity', 'UnmapCommandCount',
            'UsedCapacity', 'DiskWrites'],
        'metrics_kpi': [
            'IOs', 'MBs', 'MBReads', 'MBWritten', 'PercentBusy',
            'PercentCapacityFree', 'PercentCapacityUsed', 'DiskReads',
            'AvgResponseTime', 'ReadResponseTime', 'WriteResponseTime',
            'TotalCapacity', 'UsedCapacity', 'DiskWrites']},
    'DISKGROUP': {
        'category': 'DiskGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AvgReadSize', 'AvgWriteSize', 'IODensity', 'IOs',
            'MBs', 'MBReads', 'MBWritten', 'PercentBusy', 'PercentIdle',
            'PercentCapacityFree', 'PercentCapacityUsed', 'DiskReads',
            'ReadResponseTime', 'WriteResponseTime', 'TotalSCSICommands',
            'TotalCapacity', 'UnmapCommandCount', 'UsedCapacity',
            'DiskWrites'],
        'metrics_kpi': [
            'IODensity', 'IOs', 'MBs', 'MBReads', 'MBWritten', 'PercentBusy',
            'PercentCapacityFree', 'PercentCapacityUsed', 'DiskReads',
            'ReadResponseTime', 'WriteResponseTime', 'TotalCapacity',
            'UsedCapacity', 'DiskWrites']},
    'DISKTECHPOOL': {
        'category': 'DiskTechPool',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AvgReadSize', 'AvgWriteSize', 'IODensity', 'IOs', 'MBs',
            'MBReads',
            'MBWrittens', 'PercentBusy', 'PercentIdle', 'PercentCapacityFree',
            'PercentCapacityUsed', 'Reads', 'ReadResponseTime',
            'WriteResponseTime', 'TotalSCSICommands', 'TotalCapacity',
            'UnmapCommandCount', 'UsedCapacity', 'Writes'],
        'metrics_kpi': [
            'IODensity', 'IOs', 'MBs', 'MBReads', 'MBWrittens', 'PercentBusy',
            'PercentCapacityFree', 'PercentCapacityUsed', 'Reads',
            'ReadResponseTime', 'WriteResponseTime', 'TotalCapacity',
            'UsedCapacity', 'Writes']},
    'EDSDIRECTOR': {
        'category': 'EDSDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'PercentBusy', 'RandomReadMissMBs', 'RandomReadMisses',
            'RandomWriteMissMBs', 'RandomWriteMisses'],
        'metrics_kpi': ['PercentBusy']},
    'EDSEMULATION': {
        'category': 'EDSEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'EXTERNALDIRECTOR': {
        'category': 'ExternalDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgTimePerSyscall', 'CompressedMBs', 'CompressedReadMBs',
            'CompressedWriteMBs', 'CompressedReadReqs', 'CompressedReqs',
            'CompressedWriteReqs', 'IOs', 'MBs', 'MBRead', 'MBWritten',
            'PercentBusy', 'PercentBusyLogicalCore_0',
            'PercentBusyLogicalCore_1', 'PercentNonIOBusy',
            'PercentNonIOBusyLogicalCore_0', 'PercentNonIOBusyLogicalCore_1',
            'PercentReadReqs', 'PercentWriteReqs', 'PrefetchedTracks',
            'ReadReqs', 'Reqs', 'SyscallCount', 'Syscall_RDF_DirCount',
            'SyscallRemoteDirCount', 'WriteReqs'],
        'metrics_kpi': [
            'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'PercentNonIOBusy', 'ReadReqs', 'Reqs', 'SyscallCount',
            'WriteReqs']},
    'EXTERNALDISK': {
        'category': 'ExternalDisk',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AvgReadSize', 'AvgWriteSize', 'AvgQueueDepth', 'IOs', 'MBs',
            'MBReads', 'MBWrittens', 'Members', 'PercentBusy', 'PercentIdle',
            'PercentCapacityUsed', 'DiskReads', 'ResponseTime',
            'ReadResponseTime', 'WriteResponseTime', 'TotalCapacity',
            'UnmapCommandCount', 'DiskWrites'],
        'metrics_kpi': [
            'IOs', 'MBs', 'MBReads', 'MBWrittens', 'PercentBusy',
            'PercentCapacityUsed', 'DiskReads', 'ResponseTime',
            'ReadResponseTime', 'WriteResponseTime', 'TotalCapacity',
            'DiskWrites']},
    'EXTERNALDISKGROUP': {
        'category': 'ExternalDiskGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AvgReadSize', 'AvgWriteSize', 'AvgQueueDepth', 'IOs', 'MBs',
            'MBReads', 'MBWrittens', 'PercentBusy', 'PercentCapacityUsed',
            'DiskReads', 'ResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'TotalCapacity', 'UnmapCommandCount',
            'DiskWrites'],
        'metrics_kpi': [
            'IOs', 'MBs', 'MBReads', 'MBWrittens', 'PercentBusy',
            'PercentCapacityUsed', 'DiskReads', 'ReadResponseTime',
            'WriteResponseTime', 'TotalCapacity', 'DiskWrites']},
    'FEDIRECTOR': {
        'category': 'FEDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgQueueDepthRange0',
            'AvgQueueDepthRange1', 'AvgQueueDepthRange2',
            'AvgQueueDepthRange3', 'AvgQueueDepthRange4',
            'AvgQueueDepthRange5', 'AvgQueueDepthRange6',
            'AvgQueueDepthRange7', 'AvgQueueDepthRange8',
            'AvgQueueDepthRange9', 'AvgRDFSWriteResponseTime',
            'AvgReadMissResponseTime', 'AvgReadRT0To1', 'AvgReadRT16To32',
            'AvgReadRT1To2', 'AvgReadRT2To4', 'AvgReadRT32To64',
            'AvgReadRT4To8', 'AvgReadRT8To16', 'AvgReadRTOver64',
            'AvgWPDiscTime', 'AvgWriteRT0To1', 'AvgWriteRT16To32',
            'AvgWriteRT1To2', 'AvgWriteRT2To4', 'AvgWriteRT32To64',
            'AvgWriteRT4To8', 'AvgWriteRT8To16', 'AvgWriteRTOver64',
            'AvgTimePerSyscall', 'DeviceWPEvents', 'HostMBs', 'HitReqs',
            'HostIOs', 'MissReqs', 'AvgOptimizedReadMissSize',
            'OptimizedMBReadMisses', 'OptimizedReadMisses', 'PercentBusy',
            'PercentBusyLogicalCore_0', 'PercentBusyLogicalCore_1',
            'PercentHitReqs', 'PercentReadReqs', 'PercentReadReqHit',
            'PercentWriteReqs', 'PercentWriteReqHit', 'QueueDepthCountRange0',
            'QueueDepthCountRange1', 'QueueDepthCountRange2',
            'QueueDepthCountRange3', 'QueueDepthCountRange4',
            'QueueDepthCountRange5', 'QueueDepthCountRange6',
            'QueueDepthCountRange7', 'QueueDepthCountRange8',
            'QueueDepthCountRange9', 'QueueDepthUtilization', 'HostIOLimitIOs',
            'HostIOLimitMBs', 'ReadReqs', 'ReadHitReqs', 'ReadMissReqs',
            'ReadRTCountRange0To1', 'ReadRTCountRange16To32',
            'ReadRTCountRange1To2', 'ReadRTCountRange2To4',
            'ReadRTCountRange32To64', 'ReadRTCountRange4To8',
            'ReadRTCountRange8To16', 'ReadRTCountRangeover64', 'Reqs',
            'ReadResponseTime', 'WriteResponseTime', 'SlotCollisions',
            'SyscallCount', 'Syscall_RDF_DirCounts', 'SyscallRemoteDirCounts',
            'SystemWPEvents', 'TotalReadCount', 'TotalWriteCount', 'WriteReqs',
            'WriteHitReqs', 'WriteMissReqs', 'WriteRTCountRange0To1',
            'WriteRTCountRange16To32', 'WriteRTCountRange1To2',
            'WriteRTCountRange2To4', 'WriteRTCountRange32To64',
            'WriteRTCountRange4To8', 'WriteRTCountRange8To16',
            'WriteRTCountRangeover64'],
        'metrics_kpi': [
            'HostMBs', 'HostIOs', 'PercentBusy', 'PercentBusyLogicalCore_0',
            'PercentBusyLogicalCore_1', 'QueueDepthUtilization',
            'HostIOLimitIOs', 'HostIOLimitMBs', 'ReadResponseTime',
            'WriteResponseTime', 'SyscallCount']},
    'FEEMULATION': {
        'category': 'FeEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'FEPORT': {
        'category': 'FEPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MaxSpeedGBs', 'MBs', 'MBRead', 'MBWritten',
            'PercentBusy', 'Reads', 'ResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'SpeedGBs', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'Reads', 'ResponseTime', 'ReadResponseTime', 'WriteResponseTime',
            'SpeedGBs', 'Writes']},
    'FICONEMULATION': {
        'category': 'FiconEmulation',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': ['PercentBusy'],
        'metrics_kpi': ['PercentBusy']},
    'FICONEMULATIONTHREAD': {
        'category': 'FiconEmulationThread',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': ['PercentBusy', 'PercentIdle'],
        'metrics_kpi': ['PercentBusy', 'PercentIdle']},
    'FICONPORTTHREAD': {
        'category': 'FiconPortThread',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': ['PercentBusy', 'PercentIdle'],
        'metrics_kpi': ['PercentBusy', 'PercentIdle']},
    'HOST': {
        'category': 'Host',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'BandwidthLimit', 'BandwidthLimitExceededSecs', 'HostIOs', 'MBs',
            'HostMBReads', 'HostMBWrites', 'Reads', 'ResponseTime',
            'ReadResponseTime', 'WriteResponseTime', 'SyscallCount', 'Writes'],
        'metrics_kpi': [
            'HostIOs', 'MBs', 'HostMBReads', 'HostMBWrites', 'Reads',
            'ResponseTime', 'ReadResponseTime', 'WriteResponseTime',
            'SyscallCount', 'Writes']},
    'IMDIRECTOR': {
        'category': 'IMDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': ['PercentBusy'],
        'metrics_kpi': ['PercentBusy']},
    'IMEMULATION': {
        'category': 'IMEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'INITIATOR': {
        'category': 'Initiator',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'BandwidthLimitExceededSecs', 'HostIOs', 'MBs', 'HostMBReads',
            'HostMBWrites', 'Reads', 'ResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'SyscallCount', 'Writes'],
        'metrics_kpi': [
            'HostIOs', 'MBs', 'HostMBReads', 'HostMBWrites', 'Reads',
            'ResponseTime', 'ReadResponseTime', 'WriteResponseTime',
            'SyscallCount', 'Writes']},
    'INITIATORBYPORT': {
        'category': 'InitiatorByPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'BandwidthLimitExceededSecs', 'HostIOs', 'MBs', 'HostMBReads',
            'HostMBWrites', 'Reads', 'ResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'SyscallCount', 'Writes'],
        'metrics_kpi': [
            'HostIOs', 'MBs', 'HostMBReads', 'HostMBWrites', 'Reads',
            'ResponseTime', 'ReadResponseTime', 'WriteResponseTime',
            'SyscallCount', 'Writes']},
    'IPINTERFACE': {
        'category': 'IPInterface',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'IoRate', 'MBs', 'PacketCount', 'Reads', 'ResponseTime',
            'TotalReadTime', 'TotalWriteTime', 'Writes'],
        'metrics_kpi': ['IoRate', 'MBs', 'PacketCount', 'Reads', 'Writes']},
    'ISCSITARGET': {
        'category': 'ISCSITarget',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'IoRate', 'MBs', 'PacketCount', 'Reads', 'ResponseTime',
            'TotalReadTime', 'TotalWriteTime', 'Writes'],
        'metrics_kpi': ['IoRate', 'MBs', 'PacketCount', 'Reads', 'Writes']},
    'PORTGROUP': {
        'category': 'PortGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'Reads', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'Reads', 'Writes']},
    'RDFA': {
        'category': 'RDFA',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'ActiveCycleSize', 'AvgCycleSize', 'AvgCycleTime',
            'AvgIOServiceTime', 'CompressedMBSentAndReceived',
            'CompressedMBReceived', 'CompressedMBSent', 'CycleNumber',
            'DSEThreshold', 'DSEUsedTracks', 'LastCycleDuration',
            'InactiveCycleSize', 'LocalWPCount', 'MBReads', 'MBWritten',
            'NumberOfCompressedLinks', 'NumDevsInSession', 'NumberOfLinks',
            'PercentCompressedMBSentAndReceived',
            'PercentCompressedMBReceived', 'PercentCompressedMBSent',
            'R1_R2_Lag_Time', 'R2_LastRestoreTime', 'RDFA_ActiveIndicator',
            'RDFA_SessionIndicator', 'NumberOfRDFInvalidTracks', 'RdfMBRead',
            'RdfMBWritten', 'RDF_R1_R2_IOs', 'RDF_R1_R2_MBs', 'RDF_R2_R1_IOS',
            'RDF_R2_R1_MBs', 'RdfReads', 'RdfResponseTime', 'RDFRewrites',
            'RdfWrites', 'TotalReads', 'ReadHits', 'SessionNumber',
            'SpillOverPackedSlots', 'SystemWPCount', 'TimeSinceLastSwitch',
            'RDFA_WPCount', 'TotalHARepeatWrites', 'TotalHAWrites',
            'TotalTracksSpilledBack', 'TotalTracksSpilledOver',
            'TotalTracksSpilledOverUsed', 'UncommittedTracks', 'SystemWPLimit',
            'TotalWrites'],
        'metrics_kpi': [
            'AvgCycleSize', 'AvgCycleTime', 'AvgIOServiceTime', 'LocalWPCount',
            'RDF_R1_R2_IOs', 'RDF_R1_R2_MBs', 'RdfResponseTime',
            'RDFA_WPCount']},
    'RDFS': {
        'category': 'RDFS',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'BEDiskReadResponseTime', 'BEReadRequestTime',
            'BEReadTaskTime', 'AvgIOSize', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteSize', 'BEMBReads', 'BEMBTransferred', 'BEMBWritten',
            'BEPercentReads', 'BEPercentWrites', 'BEPrefetchedTrackss',
            'BEPrefetchedTrackUsed', 'BEReadReqs', 'BEWriteReqs', 'BlockSize',
            'TotalCapacityGB', 'HostMBs', 'IODensity', 'HostIOs',
            'MaxWPThreshold', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRandomIO', 'PercentRandomReads',
            'PercentRandomReadHit', 'PercentRandomReadMiss',
            'PercentRandomWrites', 'PercentRandomWriteHit',
            'PercentRandomWriteMiss', 'PercentRead', 'PercentReadHit',
            'PercentReadMiss', 'PercentSeqIO', 'PercentSeqRead',
            'PercentSeqReadHit', 'PercentSeqReadMiss', 'PercentSeqWrites',
            'PercentSeqWriteHit', 'PercentSeqWriteMiss', 'PercentWrite',
            'PercentWriteHit', 'PercentWriteMiss', 'BEPrefetchedMBs',
            'RandomIOs', 'RandomReadHits', 'RandomReadMisses', 'RandomReads',
            'RandomWriteHits', 'RandomWriteMisses', 'RandomWrites',
            'RdfMBsReadPerSec', 'RdfMBsWrittenPerSec', 'WritePacedDelay',
            'RdfReadsPerSec', 'RdfReadHitsPerSec', 'RdfRewritesPerSec',
            'RdfWritesPerSec', 'HostReads', 'HostReadHits', 'HostReadMisses',
            'ResponseTime', 'RDFS_WriteResponseTime', 'ReadMissResponseTime',
            'ReadResponseTime', 'WriteMissResponseTime', 'WriteResponseTime',
            'SeqReadHits', 'SeqReadMisses', 'SeqReads', 'SeqWriteHits',
            'SeqWriteMisses', 'SeqWrites', 'SpillOverPackedSlots', 'BEReqs',
            'HostHits', 'HostMisses', 'SeqIOs', 'WPCount', 'HostWrites',
            'HostWriteHits', 'HostWriteMisses'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEWriteReqs', 'HostMBs',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite', 'HostReads',
            'ResponseTime', 'RDFS_WriteResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'BEReqs', 'HostHits', 'HostMisses', 'WPCount',
            'HostWrites', 'WritePacedDelay']},
    'RDFDIRECTOR': {
        'category': 'RDFDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgIOServiceTime', 'AvgIOSizeReceived', 'AvgIOSizeSent',
            'AvgTimePerSyscall', 'CompresedMBSentAndReceived',
            'CompresedMBReceived', 'CompresedMBSent', 'CopyIOs', 'CopyMBs',
            'IOs', 'MBSentAndReceived', 'MBRead', 'MBWritten',
            'NumberOfCompresedLinks', 'NumberOfLinks', 'PercentBusy',
            'PercentCompresedMBSentAndReceived', 'PercentCompresedMBReceived',
            'PercentCompresedMBSent', 'Reqs', 'Rewrites', 'AsyncMBSent',
            'AsyncWriteReqs', 'SyncMBSent', 'SyncWrites', 'SyscallCount',
            'Syscall_RDF_DirCounts', 'SyscallRemoteDirCount', 'SyscallTime',
            'TracksReceivedPerSec', 'TracksSentPerSec', 'WriteReqs'],
        'metrics_kpi': [
            'AvgIOServiceTime', 'CopyIOs', 'CopyMBs', 'IOs',
            'MBSentAndReceived', 'MBRead', 'MBWritten', 'PercentBusy',
            'WriteReqs']},
    'RDFEMULATION': {
        'category': 'RDFEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'RDFPORT': {
        'category': 'RDFPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MaxSpeedGBs', 'MBs', 'MBRead', 'MBWritten',
            'PercentBusy', 'Reads', 'SpeedGBs', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBs', 'MBRead', 'MBWritten', 'PercentBusy',
            'Reads', 'SpeedGBs', 'Writes']},
    'STORAGECONTAINER': {
        'category': 'StorageContainer',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'CriticalAlertCount', 'InfoAlertCount', 'WarningAlertCount',
            'AllocatedCapacity', 'TotalTracks', 'BEReadRequestTime',
            'BEReadTaskTime', 'AvgIOSize', 'AvgReadResponseTime6',
            'AvgReadResponseTime7', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteResponseTime6', 'AvgWriteResponseTime7', 'AvgWriteSize',
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedTrackss', 'BEPrefetchedTrackUsed',
            'BEReadReqs', 'BEWriteReqs', 'CompressedTracks', 'BlockSize',
            'HostMBs', 'IODensity', 'HostIOs', 'MaxWPThreshold', 'HostMBReads',
            'HostMBWritten', 'PercentCompressedTracks', 'PercentHit',
            'PercentMisses', 'PercentRandomIO', 'PercentRandomReads',
            'PercentRandomReadHit', 'PercentRandomReadMiss',
            'PercentRandomWrites', 'PercentRandomWriteHit',
            'PercentRandomWriteMiss', 'PercentRead', 'PercentReadHit',
            'PercentReadMiss', 'PercentSeqIO', 'PercentSeqRead',
            'PercentSeqReadHit', 'PercentSeqReadMiss', 'PercentSeqWrites',
            'PercentSeqWriteHit', 'PercentSeqWriteMiss', 'PercentWrite',
            'PercentWriteHit', 'PercentWriteMiss', 'BEPrefetchedMBs',
            'HostIOLimitPercentTimeExceeded', 'RandomIOs', 'RandomReadHits',
            'RandomReadMisses', 'RandomReads', 'RandomWriteHits',
            'RandomWriteMisses', 'RandomWrites', 'RdfMBRead', 'RdfMBWritten',
            'RdfReads', 'RdfResponseTime', 'RDFRewrites', 'RdfWrites',
            'HostReads', 'HostReadHits', 'HostReadMisses',
            'ReadResponseTimeCount1', 'ReadResponseTimeCount2',
            'ReadResponseTimeCount3', 'ReadResponseTimeCount4',
            'ReadResponseTimeCount5', 'ReadResponseTimeCount6',
            'ReadResponseTimeCount7', 'ResponseTime', 'RDFS_WriteResponseTime',
            'ReadMissResponseTime', 'ReadResponseTime',
            'WriteMissResponseTime', 'WriteResponseTime', 'SeqReadHits',
            'SeqReadMisses', 'SeqReads', 'SeqWriteHits', 'SeqWriteMisses',
            'SeqWrites', 'Skew', 'SRDFA_MBSent', 'SRDFA_WriteReqs',
            'SRDFS_MBSent', 'SRDFS_WriteReqs', 'BEReqs', 'HostHits',
            'HostMisses', 'SeqIOs', 'WPCount', 'HostWrites', 'HostWriteHits',
            'HostWriteMisses', 'WritePacedDelay', 'WriteResponseTimeCount1',
            'WriteResponseTimeCount2', 'WriteResponseTimeCount3',
            'WriteResponseTimeCount4', 'WriteResponseTimeCount5',
            'WriteResponseTimeCount6', 'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEWriteReqs', 'HostMBs',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite',
            'HostIOLimitPercentTimeExceeded', 'RdfResponseTime', 'HostReads',
            'ResponseTime', 'RDFS_WriteResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'BEReqs', 'HostHits', 'HostMisses', 'WPCount',
            'HostWrites', 'WritePacedDelay']},
    'STORAGEGROUP': {
        'category': 'StorageGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'CriticalAlertCount', 'InfoAlertCount', 'WarningAlertCount',
            'AllocatedCapacity', 'TotalTracks', 'BEReadRequestTime',
            'BEReadTaskTime', 'AvgIOSize', 'AvgReadResponseTime6',
            'AvgReadResponseTime7', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteResponseTime6', 'AvgWriteResponseTime7', 'AvgWriteSize',
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedTrackss', 'BEPrefetchedTrackUsed',
            'BEReadReqs', 'BEWriteReqs', 'CompressedTracks',
            'CompressionRatio', 'BlockSize', 'HostMBs', 'IODensity', 'HostIOs',
            'MaxWPThreshold', 'HostMBReads', 'HostMBWritten',
            'PercentCompressedTracks', 'PercentHit', 'PercentMisses',
            'PercentRandomIO', 'PercentRandomReads', 'PercentRandomReadHit',
            'PercentRandomReadMiss', 'PercentRandomWrites',
            'PercentRandomWriteHit', 'PercentRandomWriteMiss', 'PercentRead',
            'PercentReadHit', 'PercentReadMiss', 'PercentSeqIO',
            'PercentSeqRead', 'PercentSeqReadHit', 'PercentSeqReadMiss',
            'PercentSeqWrites', 'PercentSeqWriteHit', 'PercentSeqWriteMiss',
            'PercentVPSpaceSaved', 'PercentWrite', 'PercentWriteHit',
            'PercentWriteMiss', 'PPAvgResponseTime', 'PPObservedDeltaRT',
            'PPReadRespTime', 'PPRelativeRT', 'PPWriteRespTime',
            'BEPrefetchedMBs', 'HostIOLimitPercentTimeExceeded', 'RandomIOs',
            'RandomReadHits', 'RandomReadMisses', 'RandomReads',
            'RandomWriteHits', 'RandomWriteMisses', 'RandomWrites',
            'RdfMBRead', 'RdfMBWritten', 'RdfReads', 'RdfResponseTime',
            'RDFRewrites', 'RdfWrites', 'HostReads', 'HostReadHits',
            'HostReadMisses', 'ReadResponseTimeCount1',
            'ReadResponseTimeCount2', 'ReadResponseTimeCount3',
            'ReadResponseTimeCount4', 'ReadResponseTimeCount5',
            'ReadResponseTimeCount6', 'ReadResponseTimeCount7', 'ResponseTime',
            'RDFS_WriteResponseTime', 'ReadMissResponseTime',
            'ReadResponseTime', 'WriteMissResponseTime', 'WriteResponseTime',
            'SeqReadHits', 'SeqReadMisses', 'SeqReads', 'SeqWriteHits',
            'SeqWriteMisses', 'SeqWrites', 'Skew', 'SRDFA_MBSent',
            'SRDFA_WriteReqs', 'SRDFS_MBSent', 'SRDFS_WriteReqs', 'BEReqs',
            'HostHits', 'HostMisses', 'TotalResponseTime', 'SeqIOs',
            'VAAITotalCommandCount', 'VAAITotalTime', 'VAAIUnmapCommandCount',
            'VAAIUnmapKB', 'VAAIUnmapMB', 'VAAIWriteSameCommandCount',
            'VAAIWriteSameKB', 'VAAIWriteSameMB', 'VAAIXCopyCommandCount',
            'VAAIXCopyKB', 'VAAIXCopyMB', 'WPCount', 'HostWrites',
            'HostWriteHits', 'HostWriteMisses', 'WritePacedDelay',
            'WriteResponseTimeCount1', 'WriteResponseTimeCount2',
            'WriteResponseTimeCount3', 'WriteResponseTimeCount4',
            'WriteResponseTimeCount5', 'WriteResponseTimeCount6',
            'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEWriteReqs', 'HostMBs',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite',
            'HostIOLimitPercentTimeExceeded', 'RdfResponseTime', 'HostReads',
            'ResponseTime', 'RDFS_WriteResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'BEReqs', 'HostHits', 'HostMisses',
            'VAAITotalCommandCount', 'WPCount', 'HostWrites',
            'WritePacedDelay']},
    'STORAGEGROUPBYPOOL': {
        'category': 'StorageGroupByPool',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': [
            'TotalTracks', 'BEMBReads', 'BEMBTransferred', 'DestageWriteMBs',
            'BEReadReqs', 'DestageWrites', 'AllocatedCapacity',
            'CompressedTracks', 'IODensity', 'LocalRepTracks',
            'PercentCompressedTracks', 'PrefetchedMBs', 'PrefetchedTracks',
            'BEReqs'],
        'metrics_kpi': [
            'BEMBReads', 'BEMBTransferred', 'DestageWriteMBs', 'BEReadReqs',
            'DestageWrites', 'AllocatedCapacity', 'IODensity',
            'PercentCompressedTracks', 'PrefetchedMBs', 'PrefetchedTracks',
            'BEReqs']},
    'STORAGERESOURCE': {
        'category': 'StorageResource',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': [
            'CriticalAlertCount', 'InfoAlertCount', 'WarningAlertCount',
            'AllocatedCapacity', 'TotalTracks', 'BEReadRequestTime',
            'BEReadTaskTime', 'AvgIOSize', 'AvgReadResponseTime6',
            'AvgReadResponseTime7', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteResponseTime6', 'AvgWriteResponseTime7', 'AvgWriteSize',
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedTrackss', 'BEPrefetchedTrackUsed',
            'BEReadReqs', 'BEWriteReqs', 'CompressedTracks', 'BlockSize',
            'HostMBs', 'IODensity', 'HostIOs', 'MaxWPThreshold', 'HostMBReads',
            'HostMBWritten', 'PercentCompressedTracks', 'PercentHit',
            'PercentMisses', 'PercentRandomIO', 'PercentRandomReads',
            'PercentRandomReadHit', 'PercentRandomReadMiss',
            'PercentRandomWrites', 'PercentRandomWriteHit',
            'PercentRandomWriteMiss', 'PercentRead', 'PercentReadHit',
            'PercentReadMiss', 'PercentSeqIO', 'PercentSeqRead',
            'PercentSeqReadHit', 'PercentSeqReadMiss', 'PercentSeqWrites',
            'PercentSeqWriteHit', 'PercentSeqWriteMiss', 'PercentWrite',
            'PercentWriteHit', 'PercentWriteMiss', 'BEPrefetchedMBs',
            'HostIOLimitPercentTimeExceeded', 'RandomIOs', 'RandomReadHits',
            'RandomReadMisses', 'RandomReads', 'RandomWriteHits',
            'RandomWriteMisses', 'RandomWrites', 'RdfMBRead', 'RdfMBWritten',
            'RdfReads', 'RdfResponseTime', 'RDFRewrites', 'RdfWrites',
            'HostReads', 'HostReadHits', 'HostReadMisses',
            'ReadResponseTimeCount1', 'ReadResponseTimeCount2',
            'ReadResponseTimeCount3', 'ReadResponseTimeCount4',
            'ReadResponseTimeCount5', 'ReadResponseTimeCount6',
            'ReadResponseTimeCount7', 'ResponseTime', 'RDFS_WriteResponseTime',
            'ReadMissResponseTime', 'ReadResponseTime',
            'WriteMissResponseTime', 'WriteResponseTime', 'SeqReadHits',
            'SeqReadMisses', 'SeqReads', 'SeqWriteHits', 'SeqWriteMisses',
            'SeqWrites', 'Skew', 'SRDFA_MBSent', 'SRDFA_WriteReqs',
            'SRDFS_MBSent', 'SRDFS_WriteReqs', 'BEReqs', 'HostHits',
            'HostMisses', 'SeqIOs', 'WPCount', 'HostWrites', 'HostWriteHits',
            'HostWriteMisses', 'WritePacedDelay', 'WriteResponseTimeCount1',
            'WriteResponseTimeCount2', 'WriteResponseTimeCount3',
            'WriteResponseTimeCount4', 'WriteResponseTimeCount5',
            'WriteResponseTimeCount6', 'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEWriteReqs', 'HostMBs',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite',
            'HostIOLimitPercentTimeExceeded', 'RdfResponseTime', 'HostReads',
            'ResponseTime', 'RDFS_WriteResponseTime', 'ReadResponseTime',
            'WriteResponseTime', 'BEReqs', 'HostHits', 'HostMisses', 'WPCount',
            'HostWrites', 'WritePacedDelay']},
    'SRP': {
        'category': 'SRP',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEReadReqs',
            'BEWriteReqs', 'OverallCompressionRatio', 'OverallEfficiencyRatio',
            'HostMBs', 'HostIOs', 'HostMBReads', 'HostMBWritten',
            'PercentSnapshotSaved', 'PercentVPSaved', 'HostWrites',
            'HostReads', 'ResponseTime', 'ReadResponseTime', 'VPSharedRatio',
            'WriteResponseTime', 'SnapshotCompressionRatio',
            'SnapshotEfficiencyRatio', 'SnapshotSharedRatio', 'BEReqs',
            'TotalSRPCapacity', 'TotalSRPCapacity', 'UsedSRPCapacity',
            'UsedSRPCapacity', 'VPCompressionRatio', 'VPEfficiencyRatio'],
        'metrics_kpi': [
            'BEMBTransferred', 'HostMBs', 'HostIOs', 'ResponseTime',
            'BEReqs']},
    'STORAGERESOURCEBYPOOL': {
        'category': 'StorageResourceByPool',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all': [
            'TotalTracks', 'BEMBReads', 'BEMBTransferred', 'DestageWriteMBs',
            'BEReadReqs', 'DestageWrites', 'AllocatedCapacity',
            'CompressedTracks', 'IODensity', 'LocalRepTracks',
            'PercentCompressedTracks', 'PrefetchedMBs', 'PrefetchedTracks',
            'BEReqs'],
        'metrics_kpi': [
            'BEMBReads', 'BEMBTransferred', 'DestageWriteMBs', 'BEReadReqs',
            'DestageWrites', 'AllocatedCapacity', 'IODensity',
            'PercentCompressedTracks', 'PrefetchedMBs', 'PrefetchedTracks',
            'BEReqs']},
    'THINPOOL': {
        'category': 'ThinPool',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all': [
            'AllocatedPoolCapacity', 'TotalTracks', 'AvgIOSize', 'AvgReadSize',
            'AvgWriteSize', 'BEMBRead', 'BEMBTransferred', 'BEMBWritten',
            'BEPercentReads', 'BEPercentWrites', 'BEPrefetchedTracks',
            'BEPrefetchedTrackUsed', 'BEReadReqs', 'BEAvgResponseTime',
            'BEReadResponseTime', 'BEWriteResponseTime', 'BEWriteReqs',
            'CompressedTracks', 'CompressionScanReads', 'CopyOnWrite',
            'BlockSize', 'EgressTracks', 'EnabledPoolCapacity',
            'IngressTracks', 'IODensity', 'PercentCompressedTracks',
            'PercentUsedCapacity', 'BEPrefetchedMBs', 'ReDirectOnWrite',
            'BEReqs', 'TotalPoolCapacity', 'UsedPoolCapacity', 'WPCount'],
        'metrics_kpi': [
            'AllocatedPoolCapacity', 'BEMBRead', 'BEMBTransferred',
            'BEMBWritten', 'BEReadReqs', 'BEAvgResponseTime',
            'BEReadResponseTime', 'BEWriteResponseTime', 'BEWriteReqs',
            'EgressTracks', 'EnabledPoolCapacity', 'IngressTracks',
            'IODensity', 'PercentUsedCapacity', 'BEReqs', 'TotalPoolCapacity',
            'UsedPoolCapacity', 'WPCount']}}
