import os
import re

RESOURCES_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), "resources"))


class pytest_regex:  # noqa: N801
    """Assert that a given string meets some expectations."""

    def __init__(self, pattern, flags=0):
        self._regex = re.compile(pattern, flags)

    def __eq__(self, actual):
        return bool(self._regex.match(actual))

    def __repr__(self):
        return self._regex.pattern
