"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const yaml = require("yaml");
const component_synchronizer_1 = require("./component_synchronizer");
const index_1 = require("./index");
const utils = require("./utils");
/**
 * @stability stable
 */
class PipelineBuilder {
    /**
     * @stability stable
     */
    constructor(config) {
        /**
         * @stability stable
         */
        this.cacheDir = 'component_cache';
        this.config = config;
    }
    /**
     * @stability stable
     */
    async create(stack, pipelineConfigDir) {
        // Get all YAMLs from the pipelineConfigDir
        const pipelineConfigs = fs.readdirSync(pipelineConfigDir)
            .filter(c => c.endsWith('.yaml'))
            .map(f => ({
            name: utils.pascalize(f.substring(0, f.lastIndexOf('.'))),
            fileContent: fs.readFileSync(path.join(pipelineConfigDir, f), 'utf-8'),
        }));
        let pipelineYamls = pipelineConfigs.map(c => ({
            name: c.name,
            ...yaml.parse(c.fileContent),
        }));
        // Get all git component dependencies
        const allComponentDeps = pipelineYamls
            .filter(y => y.component_dependencies && y.component_dependencies.length > 0)
            .map(y => y.component_dependencies.map((d) => ({ pipelineName: y.name, ...d })))
            .reduce((acc, val) => acc.concat(val), [])
            .filter((c) => c.type == 'git');
        const synchronizer = new component_synchronizer_1.ComponentSynchronizer();
        await synchronizer.synchronize(allComponentDeps);
        let pipelines = pipelineYamls
            .filter(c => c.pipeline && c.component_dependencies)
            .map(c => new index_1.AmiPipelineLib(stack, c.name, c.pipeline, c.component_dependencies, {
            channel: this.config.SLACK_CHANNEL,
            slackWebhookUrl: this.config.SLACK_WEBHOOK_URL,
            username: this.config.SLACK_USERNAME,
        }));
        return pipelines;
    }
}
exports.PipelineBuilder = PipelineBuilder;
_a = JSII_RTTI_SYMBOL_1;
PipelineBuilder[_a] = { fqn: "halloumi-ami-pipelines.PipelineBuilder", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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