"use strict";
const core_1 = require("@aws-cdk/core");
const ec2 = require("../lib");
const lib_1 = require("../lib");
module.exports = {
    'can make and use a Windows image'(test) {
        // GIVEN
        const stack = new core_1.Stack(undefined, undefined, {
            env: { region: 'testregion' }
        });
        // WHEN
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234'
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.imageId, 'ami-1234');
        test.equals(details.osType, ec2.OperatingSystemType.WINDOWS);
        test.done();
    },
    'WindowsImage retains userdata'(test) {
        // GIVEN
        const stack = new core_1.Stack(undefined, undefined, {
            env: { region: 'testregion' }
        });
        // WHEN
        const ud = ec2.UserData.forWindows();
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234',
        }, {
            userData: ud
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.userData, ud);
        test.done();
    },
    'LookupMachineImage default search'(test) {
        // GIVEN
        const app = new core_1.App();
        const stack = new core_1.Stack(app, 'Stack', {
            env: { account: '1234', region: 'testregion' }
        });
        // WHEN
        new lib_1.LookupMachineImage({ name: 'bla*', owners: ['amazon'] }).getImage(stack);
        // THEN
        const missing = app.synth().manifest.missing || [];
        test.deepEqual(missing, [
            {
                key: 'ami:account=1234:filters.image-type.0=machine:filters.name.0=bla*:filters.state.0=available:owners.0=amazon:region=testregion',
                props: {
                    account: '1234',
                    region: 'testregion',
                    owners: ['amazon'],
                    filters: {
                        'name': ['bla*'],
                        'state': ['available'],
                        'image-type': ['machine']
                    }
                },
                provider: 'ami'
            }
        ]);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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