"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const lib_1 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ec2-vpc');
const vpc = new ec2.Vpc(stack, 'MyVpc');
// Test NetworkAcl and rules
const nacl1 = new ec2.NetworkAcl(stack, 'myNACL1', {
    vpc,
    subnetSelection: { subnetType: ec2.SubnetType.PRIVATE },
});
nacl1.addEntry('AllowDNSEgress', {
    ruleNumber: 100,
    traffic: lib_1.AclTraffic.udpPort(53),
    cidr: lib_1.AclCidr.ipv4('172.16.0.0/24'),
    direction: lib_1.TrafficDirection.EGRESS,
});
nacl1.addEntry('AllowDNSIngress', {
    ruleNumber: 100,
    traffic: lib_1.AclTraffic.udpPort(53),
    direction: lib_1.TrafficDirection.INGRESS,
    cidr: lib_1.AclCidr.anyIpv4()
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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