"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../lib");
const lib_1 = require("../lib");
/// !show
// Pick the right Amazon Linux edition. All arguments shown are optional
// and will default to these values when omitted.
const amznLinux = new ec2.AmazonLinuxImage({
    generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
    edition: ec2.AmazonLinuxEdition.STANDARD,
    virtualization: ec2.AmazonLinuxVirt.HVM,
    storage: ec2.AmazonLinuxStorage.GENERAL_PURPOSE,
});
// Pick a Windows edition to use
const windows = new ec2.WindowsImage(ec2.WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
// Look up the most recent image matching a set of AMI filters.
// In this case, look up the NAT instance AMI, by using a wildcard
// in the 'name' field:
const natAmi = new lib_1.LookupMachineImage({
    name: 'amzn-ami-vpc-nat-*',
    owners: ['amazon'],
});
// For other custom (Linux) images, instantiate a `GenericLinuxImage` with
// a map giving the AMI to in for each region:
const linux = new ec2.GenericLinuxImage({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
// For other custom (Windows) images, instantiate a `GenericWindowsImage` with
// a map giving the AMI to in for each region:
const genericWindows = new ec2.GenericWindowsImage({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
/// !hide
Array.isArray(windows);
Array.isArray(amznLinux);
Array.isArray(linux);
Array.isArray(genericWindows);
Array.isArray(natAmi);
//# sourceMappingURL=data:application/json;base64,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