import { IConnectable } from "./connections";
/**
 * Interface for classes that provide the peer-specification parts of a security group rule
 */
export interface IPeer extends IConnectable {
    /**
     * Whether the rule can be inlined into a SecurityGroup or not
     */
    readonly canInlineRule: boolean;
    /**
     * A unique identifier for this connection peer
     */
    readonly uniqueId: string;
    /**
     * Produce the ingress rule JSON for the given connection
     */
    toIngressRuleConfig(): any;
    /**
     * Produce the egress rule JSON for the given connection
     */
    toEgressRuleConfig(): any;
}
/**
 * Factories for static connection peer
 */
export declare class Peer {
    /**
     * Create an IPv4 peer from a CIDR
     */
    static ipv4(cidrIp: string): IPeer;
    /**
     * Any IPv4 address
     */
    static anyIpv4(): IPeer;
    /**
     * Create an IPv6 peer from a CIDR
     */
    static ipv6(cidrIp: string): IPeer;
    /**
     * Any IPv6 address
     */
    static anyIpv6(): IPeer;
    /**
     * A prefix list
     */
    static prefixList(prefixListId: string): IPeer;
    protected constructor();
}
