# SphericalData

Модуль для работы с данными, распределенными на поверхности гиперсферы.

## Руководство по использованию
Данный модуль позволяет выполнять следующие действия:
#### 1. Преобразование массива данных из декартовой системы координат в сферическую

Функция **toSpheric()** принимает на вход массив данных $X$ в декартовой системе координат размерностью $(N, M)$, где $N \geq 1$, $M \geq 3$. Тип входных данных — список (*list*) или массив Numpy (*numpy.ndarray*).

На выходе пользователь получает массив типа Numpy $X'$ размерностью $(N, M)$, где значение $X'[n, m]$ при
- $m = 0$ — радиальное расстояние $r \geq 0$;
- $m = \overline{1, M-2}$ — зенитные углы $\phi_{m} \in [0; \pi]$;
- $m = M-1$ — азимутальный угол $\theta \in [-\pi; \pi)$.

Вычисление компонент в сферической системе координат проводится по следующим формулам:
$$r_n = \sqrt{\sum_{i=0}^{M-1}{x_i^2}}$$
$$\phi_{n, m} = atan2(\sqrt{\sum_{i=m+1}^{M-1}{x_i^2}}, x_m)$$
$$\theta_n = atan2(x_{M-1}, x_{M-2})$$
$$atan2(y, x) = arctg(\frac{y}{x})$$

Пример программы:
```python3
import numpy as np
from sphericaldata.spheric import toSpheric

x_cart = [[1, 2, 3], [4, 5, 6]]
# x_cart = np.array([[1, 2, 3], [4, 5, 6]])
x_sph = toSpheric(x)

print(x_sph)
```

```
[[3.74165739 1.30024656 0.98279372]
 [8.77496439 1.097478   0.87605805]]
```

#### 2. Преобразование массива данных из сферической системы координат в декартову

В противовес функции выше **toCartesian()** принимает на вход массив данных $X$ в сферической системе координат размерностью $(N, M)$, описание входных данных аналогично выходу функции **toSpheric()**. Тип входных данных — список (*list*) или массив Numpy (*numpy.ndarray*).

На выходе пользователь получает массив типа Numpy $X'$ размерностью $(N, M)$ в декартовой системе координат.

Вычисление компонент в декартовой системе координат проводится по следующим формулам:

$$x'_{n, 0} = r\cos{\phi_{n,0}}$$
$$x'_{n, m} = r\cos{\phi_{n,m}}\prod_{i=0}^{m-1}{\sin{\phi_{n,i}}}, m=\overline{1, M-2}$$
$$x'_{n, M-1} = r\prod_{i=0}^{M-1}{\sin{\phi_{n,i}}}$$

Проведём обратное преобразование для результата, полученного в примере ранее.

```python3
from sphericaldata.spheric import toCartesian

x_cart = toCartesian(x_sph)
print(x_cart)
```

```
[[1. 2. 3.]
 [4. 5. 6.]]
```

#### 3. Проведение метода главных компонент (PCA) в сферической системе координат

Если множество $M$-мерных векторов $X$ определено в положительной четверти гиперсферы ($\phi_m \in [0; \pi], \theta \in [0; \pi]$, )