#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.response.AlipayResponse import AlipayResponse


class AlipayFundBizorderCreateResponse(AlipayResponse):

    def __init__(self):
        super(AlipayFundBizorderCreateResponse, self).__init__()
        self._biz_order_no = None
        self._out_biz_no = None
        self._status = None

    @property
    def biz_order_no(self):
        return self._biz_order_no

    @biz_order_no.setter
    def biz_order_no(self, value):
        self._biz_order_no = value
    @property
    def out_biz_no(self):
        return self._out_biz_no

    @out_biz_no.setter
    def out_biz_no(self, value):
        self._out_biz_no = value
    @property
    def status(self):
        return self._status

    @status.setter
    def status(self, value):
        self._status = value

    def parse_response_content(self, response_content):
        response = super(AlipayFundBizorderCreateResponse, self).parse_response_content(response_content)
        if 'biz_order_no' in response:
            self.biz_order_no = response['biz_order_no']
        if 'out_biz_no' in response:
            self.out_biz_no = response['out_biz_no']
        if 'status' in response:
            self.status = response['status']
