# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class WaterLevelClient(SensorClient):
    """
    A sensor that measures liquid/water level.
    Implements a client for the `Water level <https://microsoft.github.io/jacdac-docs/services/waterlevel>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_level_value: Optional[float] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_WATER_LEVEL, JD_WATER_LEVEL_PACK_FORMATS, role)
        self.missing_level_value = missing_level_value

    @property
    def level(self) -> Optional[float]:
        """
        The reported water level., _: /
        """
        self.refresh_reading()
        return self.register(JD_WATER_LEVEL_REG_LEVEL).float_value(self.missing_level_value, 100)

    @property
    def level_error(self) -> Optional[float]:
        """
        (Optional) The error rage on the current reading, _: /
        """
        return self.register(JD_WATER_LEVEL_REG_LEVEL_ERROR).float_value(100)

    @property
    def variant(self) -> Optional[WaterLevelVariant]:
        """
        (Optional) The type of physical sensor., 
        """
        return self.register(JD_WATER_LEVEL_REG_VARIANT).value()

    
