# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional, Tuple


class DualMotorsClient(Client):
    """
    A synchronized pair of motors.
    Implements a client for the `Dual Motors <https://microsoft.github.io/jacdac-docs/services/dualmotors>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_DUAL_MOTORS, JD_DUAL_MOTORS_PACK_FORMATS, role)


    @property
    def speed(self) -> Optional[Tuple[float, float]]:
        """
        Relative speed of the motors. Use positive/negative values to run the motor forwards and backwards.
        A speed of ``0`` while ``enabled`` acts as brake., left: /,right: /
        """
        return self.register(JD_DUAL_MOTORS_REG_SPEED).value()

    @speed.setter
    def speed(self, value: Tuple[float, float]) -> None:
        self.enabled = True
        self.register(JD_DUAL_MOTORS_REG_SPEED).set_values(*value)


    @property
    def enabled(self) -> Optional[bool]:
        """
        Turn the power to the motors on/off., 
        """
        return self.register(JD_DUAL_MOTORS_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_DUAL_MOTORS_REG_ENABLED).set_values(value)


    @property
    def load_torque(self) -> Optional[float]:
        """
        (Optional) Torque required to produce the rated power of an each electrical motor at load speed., _: kg/cm
        """
        return self.register(JD_DUAL_MOTORS_REG_LOAD_TORQUE).value()

    @property
    def load_rotation_speed(self) -> Optional[float]:
        """
        (Optional) Revolutions per minute of the motor under full load., _: rpm
        """
        return self.register(JD_DUAL_MOTORS_REG_LOAD_ROTATION_SPEED).value()

    @property
    def reversible(self) -> Optional[bool]:
        """
        (Optional) Indicates if the motors can run backwards., 
        """
        return self.register(JD_DUAL_MOTORS_REG_REVERSIBLE).bool_value()

    
