# Generated by Django 3.0.3 on 2020-02-07 21:28

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SlackWorkspace',
            fields=[
                ('id', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('scope', models.CharField(max_length=1024)),
                ('bot_access_token', models.CharField(max_length=255)),
                ('bot_user_id', models.CharField(max_length=255)),
                ('last_changed', models.DateTimeField(auto_now_add=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('response', django.contrib.postgres.fields.jsonb.JSONField()),
                ('domain', models.CharField(max_length=255, null=True)),
                ('image_34', models.URLField(null=True)),
                ('image_44', models.URLField(null=True)),
                ('image_68', models.URLField(null=True)),
                ('image_88', models.URLField(null=True)),
                ('image_102', models.URLField(null=True)),
                ('image_132', models.URLField(null=True)),
                ('image_230', models.URLField(null=True)),
                ('image_original', models.URLField(null=True)),
                ('image_default', models.BooleanField(null=True)),
                ('enterprise_id', models.CharField(max_length=128, null=True)),
                ('enterprise_name', models.CharField(max_length=128, null=True)),
                ('owners', models.ManyToManyField(related_name='owned_slack_workspaces', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SlackWebHook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('channel_name', models.CharField(max_length=255)),
                ('channel_id', models.CharField(max_length=255)),
                ('configuration_url', models.URLField(max_length=255)),
                ('url', models.URLField(max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('workspace', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='webhooks', to='slack_app.SlackWorkspace')),
            ],
        ),
        migrations.CreateModel(
            name='SlackUserMapping',
            fields=[
                ('slack_user_id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False)),
                ('slack_team_id', models.CharField(max_length=255)),
                ('access_token', models.CharField(max_length=255)),
                ('nonce', models.UUIDField(default=uuid.uuid4)),
                ('slack_email', models.EmailField(max_length=254, null=True)),
                ('image_24', models.URLField(null=True)),
                ('image_32', models.URLField(null=True)),
                ('image_48', models.URLField(null=True)),
                ('image_72', models.URLField(null=True)),
                ('image_192', models.URLField(null=True)),
                ('image_512', models.URLField(null=True)),
                ('image_1024', models.URLField(null=True)),
                ('workspace_name', models.CharField(max_length=255)),
                ('workspace_domain', models.CharField(max_length=255)),
                ('workspace_image_34', models.URLField(null=True)),
                ('workspace_image_44', models.URLField(null=True)),
                ('workspace_image_68', models.URLField(null=True)),
                ('workspace_image_88', models.URLField(null=True)),
                ('workspace_image_102', models.URLField(null=True)),
                ('workspace_image_132', models.URLField(null=True)),
                ('workspace_image_230', models.URLField(null=True)),
                ('workspace_image_original', models.URLField(null=True)),
                ('slack_workspace', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slack_users', to='slack_app.SlackWorkspace')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slack_accounts', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
