import pandas as pd
import s3fs

from cc_py_commons.config.env import app_config
from cc_py_commons.utils.logger import logger

# Initializes s3fs to use AWS KEY/SECRET and returns URL for file
s3 = s3fs.S3FileSystem(key=app_config.AWS_ACCESS_KEY_ID, secret=app_config.AWS_SECRET_ACCESS_KEY)


def does_exist(bucket, filename):
  s3_url = get_s3_url(bucket, filename)
  return s3.exists(s3_url)


def load_data(file_name, bucket_name):
  data = pd.DataFrame()

  if not does_exist(bucket_name, file_name): 
    logger.warning(f"s3_file.load_data: Trying to load {bucket_name} and file: {file_name} but could not locate it.")
    return data

  s3_url = get_s3_url(bucket_name, file_name)
  logger.debug(f"s3_file.load_data: loading from {s3_url}")

  if (".csv" in file_name.lower()):
    data = pd.read_csv(s3_url, skipinitialspace=True)
    data.rename(columns=lambda x: x.strip().lower(), inplace=True)
  else:
    data = pd.read_excel(s3_url)

  return data


def get_s3_url(bucket_name, filename):
  """Returns URL for file"""
  return f"s3://{bucket_name}/{filename}"
