import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { LambdaInvoke } from 'aws-cdk-lib/aws-stepfunctions-tasks';
import { Construct } from 'constructs';
export declare function validatePatternSupported(integrationPattern: sfn.IntegrationPattern, supportedPatterns: sfn.IntegrationPattern[]): void;
export declare function integrationResourceArn(service: string, api: string, integrationPattern?: sfn.IntegrationPattern): string;
export interface TextractGenericSyncSfnTaskProps extends sfn.TaskStateBaseProps {
    readonly s3OutputBucket: string;
    /** The prefix to use for the output files */
    readonly s3OutputPrefix: string;
    /** location of input S3 objects - if left empty will generate rule for s3 access to all [*] */
    readonly s3InputBucket?: string;
    /** prefix for input S3 objects - if left empty will generate rule for s3 access to all [*] */
    readonly s3InputPrefix?: string;
    /** Log level, can be DEBUG, INFO, WARNING, ERROR, FATAL */
    readonly lambdaLogLevel?: 'DEBUG' | 'INFO' | 'WARNING' | 'ERROR' | 'FATAL';
    /** Lambda Function Timeout in seconds, default 300 */
    readonly lambdaTimeout?: number;
    /** Memory allocated to Lambda function, default 512 */
    readonly lambdaMemory?: number;
    /**not implemented yet */
    readonly enableMonitoring?: boolean;
    /** not implemented yet */
    readonly enableDashboard?: boolean;
    /** not implemented yet */
    readonly customFunction?: LambdaInvoke;
    readonly textractAsyncCallMaxRetries?: number;
    /**default is 1.1 */
    readonly textractAsyncCallBackoffRate?: number;
    /**default is 1 */
    readonly textractAsyncCallInterval?: number;
    readonly workflowTracingEnabled?: boolean;
    /** how long can we wait for the process (default is 48 hours (60*48=2880)) */
    readonly textractStateMachineTimeoutMinutes?: number;
    readonly textractAPI?: 'GENERIC' | 'ANALYZEID' | 'EXPENSE';
    /**
         * The JSON input for the execution, same as that of StartExecution.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         *
         * @default - The state input (JSON path '$')
         */
    readonly input?: sfn.TaskInput;
    /**
            * The name of the execution, same as that of StartExecution.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
            *
            * @default - None
            */
    readonly name?: string;
    /**
            * Pass the execution ID from the context object to the execution input.
            * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
            *
            * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
            *
            * @default - false
            */
    readonly associateWithParent?: boolean;
}
export declare class TextractGenericSyncSfnTask extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    stateMachine: sfn.IStateMachine;
    textractSyncLambdaLogGroup: ILogGroup;
    version: string;
    textractSyncCallFunction: lambda.IFunction;
    constructor(scope: Construct, id: string, props: TextractGenericSyncSfnTaskProps);
    /**
         * @internal
         */
    protected _renderTask(): any;
    /**
         * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
         *
         * the scoped access policy should be generated accordingly.
         *
         * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
         */
    private createScopedAccessPolicy;
}
