"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractAsyncToJSON = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class TextractAsyncToJSON extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = 1024;
        if (typeof (props.lambdaMemoryMB != 0) && props.lambdaMemoryMB) {
            lambdaMemoryMB = props.lambdaMemoryMB;
        }
        var lambdaTimeout = 900;
        if (typeof (props.lambdaTimeout != 0) && props.lambdaTimeout) {
            lambdaTimeout = props.lambdaTimeout;
        }
        var lambdaLogLevel = 'DEBUG';
        if (typeof (props.lambdaLogLevel) !== 'undefined' && !props.lambdaLogLevel) {
            lambdaLogLevel = props.lambdaLogLevel;
        }
        const asyncToJSONFunction = new lambda.DockerImageFunction(this, 'TextractAsyncToJSON', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/async_to_json/')),
            memorySize: lambdaMemoryMB,
            environment: {
                S3_OUTPUT_BUCKET: props.s3OutputBucket,
                S3_OUTPUT_PREFIX: props.s3OutputPrefix,
                LOG_LEVEL: lambdaLogLevel,
            },
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        asyncToJSONFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:Get*', 's3:List*', 's3:Put*'],
            resources: ['*'],
        }));
        const asyncToJSON = new tasks.LambdaInvoke(this, id + 'AsyncToJSON', {
            lambdaFunction: asyncToJSONFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(900),
            outputPath: '$.Payload',
        });
        this.startState = asyncToJSON;
        this.endStates = [asyncToJSON];
    }
}
exports.TextractAsyncToJSON = TextractAsyncToJSON;
_a = JSII_RTTI_SYMBOL_1;
TextractAsyncToJSON[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractAsyncToJSON", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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