"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsServerlessInit = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class RdsServerlessInit extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.rdsServerlessInit = new lambda.DockerImageFunction(this, id + 'ServerlessInit', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/rds_serverless_init/')),
            memorySize: 128,
            timeout: cdk.Duration.seconds(600),
            // securityGroups: props.securityGroups,
            environment: {
                LOG_LEVEL: 'DEBUG',
                SECRET_ARN: props.dbClusterSecretARN,
                CLUSTER_ARN: props.dbClusterARN,
            },
        });
        this.rdsServerlessInit.role?.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonRDSDataFullAccess'));
        this.rdsServerlessInit.addToRolePolicy(new iam.PolicyStatement({
            actions: [
                'secretsmanager:GetSecretValue',
            ],
            resources: [props.dbClusterSecretARN],
        }));
        const provider = new customResources.Provider(this, 'Provider', {
            onEventHandler: this.rdsServerlessInit,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
exports.RdsServerlessInit = RdsServerlessInit;
//# sourceMappingURL=data:application/json;base64,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