# -*- coding: utf-8 -*-


class LDLfFixtures:

    ldlf_formulas = [
        "a",
        "!a",
        "a & b",
        "a | b",
        "!(a | !b)",
        "true",
        "false",
        "tt",
        "ff",
        "!tt",
        "!ff",
        "tt & tt",
        "tt & ff",
        "ff & ff",
        "tt | ff",
        "<true>tt",
        "<true>ff",
        "[true]tt",
        "[true]ff",
        "<a>tt",
        "<a>ff",
        "[a]tt",
        "[a]ff",
        "<a & b>tt",
        "<a & b>ff",
        "<a | c>tt",
        "<a | c>ff",
        "<a + b>tt",
        "<a + b>ff",
        "<a ; b>tt",
        "<a ; b>ff",
        "<a*>tt",
        "<a*>ff",
        "<?<a>tt>tt",
        "<?<a>tt>ff",
        "[a & b]tt",
        "[a & b]ff",
        "[a | c]tt",
        "[a | c]ff",
        "[a + b]tt",
        "[a + b]ff",
        "[a ; b]tt",
        "[a ; b]ff",
        "[a*]tt",
        "[a*]ff",
        "[?<a>tt]tt",
        "[?<a>tt]ff",
    ]

    ldlf_theorems = [
        "a <-> <a>tt",
        "!a <-> [a]ff",  # TODO '!a' should be <!a>tt
        "(a & b) <-> <a & b>tt",
        "(a | b) <-> <a | b>tt",
        "!(a | b) <-> [a | b]ff",
        "!<a>tt <-> [a]ff",
        "(<a>tt & <b>tt) <-> (<a & b>tt)",
        "(<a>tt | <b>tt) <-> (<a | b>tt)",
        "([a]tt & [b]tt) <-> ([a & b]tt)",
        "([a]tt | [b]tt) <-> ([a | b]tt)",
    ]


class LTLfFixtures:

    ltlf_formulas = [
        "a",
        "!a",
        "a | b",
        "a & b",
        "X a",
        "WX a",
        "(X a) <-> !(WX(!a))",
        "(WX a) <-> !(X(!a))",
        "a U b",
        "a R b",
        "F a",
        "F(a & b)",
        "F(a | b)",
        "F(a & last)",
        "G a",
        "F(G(a))",
        "G(F(a))",
        "G(true)",
        "F(true)",
        "G(false)",
        "F(false)",
        "last",
        # "end",
        "true",
        "false",
        "a -> b",
        "a <-> b",
        "G(a -> b)",
        "G(a -> F(b))",
        "G(a -> b -> c)",
    ]
