import unittest

from telegrambotapiwrapper.annotation import AnnotationWrapper


class TestAnnotationWrapper(unittest.TestCase):

    def test_is_list_of_list(self):
        data_to_test = {
            'StickerSet': False,
            'Union[InputFile, str]': False,
            'Optional[PassportData]': False,
            'Optional[ShippingQuery]': False,
            'Optional[int]': False,
            'ChatMember': False,
            'List[EncryptedPassportElement]': False,
            'Optional[CallbackGame]': False,
            'Optional[Sticker]': False,
            'Union[int, str]': False,
            'Optional[Location]': False,
            'Optional[InputFile]': False,
            'Optional[bool]': False,
            'Optional[Union[int, str]]': False,
            'Optional[PhotoSize]': False,
            'Optional[Document]': False,
            'Optional[PassportFile]': False,
            'Optional[VideoNote]': False,
            'Optional[Venue]': False,
            'Optional[User]': False,
            'Optional[Game]': False,
            'Optional[ChosenInlineResult]': False,
            'Optional[str]': False,
            'Optional[Union[InputFile, str]]': False,
            'InputMessageContent': False,
            'UserProfilePhotos': False,
            'Optional[PreCheckoutQuery]': False,
            'Optional[Voice]': False,
            'Optional[List[PassportFile]]': False,
            'Optional[InlineQuery]': False,
            'List[PhotoSize]': False,
            'Optional[Message]': False,
            'List[List[InlineKeyboardButton]]': True,
            'Optional[InlineKeyboardMarkup]': False,
            'List[List[PhotoSize]]': True,
            'bool': False,
            'Union[Message, bool]': False,
            'List[ChatMember]': False,
            'List[str]': False,
            'Optional[CallbackQuery]': False,
            'ShippingAddress': False,
            'File': False,
            'Location': False,
            'Optional[MaskPosition]': False,
            'str': False,
            'float': False,
            'Optional[List[LabeledPrice]]': False,
            'Optional[List[User]]': False,
            'InputMedia': False,
            'List[Sticker]': False,
            'Optional[Chat]': False,
            'List[Update]': False,
            'Optional[Audio]': False,
            'Optional[Poll]': False,
            'Optional[SuccessfulPayment]': False,
            'Pool': False,
            'Optional[ChatPhoto]': False,
            'List[Union[InputMediaPhoto, InputMediaVideo]]': False,
            'List[List[KeyboardButton]]': True,
            'List[PassportElementError]': False,
            'Optional[Animation]': False,
            'Optional[OrderInfo]': False,
            'List[PollOption]': False,
            'List[InlineQueryResult]': False,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': False,
            'InputFile': False,
            'Optional[List[PhotoSize]]': False,
            'Optional[Contact]': False,
            'Optional[Video]': False,
            'User': False,
            'Optional[InputMessageContent]': False,
            'Optional[List[MessageEntity]]': False,
            'Optional[ShippingAddress]': False,
            'EncryptedCredentials': False,
            'List[GameHighScore]': False,
            'Optional[List[str]]': False,
            'Optional[Invoice]': False,
            'WebhookInfo': False,
            'List[LabeledPrice]': False,
            'Message': False,
            'int': False,
            'Chat': False,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_list_of_list, v)

    def test_inner_part_of_list_of_list(self):
        data_to_test = {
            'List[List[KeyboardButton]]': 'KeyboardButton',
            'List[List[PhotoSize]]': 'PhotoSize',
            'List[List[InlineKeyboardButton]]': 'InlineKeyboardButton',
        }

        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).inner_part_of_list_of_list, v)

    def test_is_simple(self):
        data_to_test = {
            'Optional[Venue]': False,
            'Optional[OrderInfo]': False,
            'File': False,
            'ShippingAddress': False,
            'List[PassportElementError]': False,
            'Union[InputFile, str]': False,
            'Optional[Union[int, str]]': False,
            'Optional[ShippingAddress]': False,
            'str': True,
            'Optional[InlineQuery]': False,
            'List[PollOption]': False,
            'Optional[List[MessageEntity]]': False,
            'List[Sticker]': False,
            'float': True,
            'List[GameHighScore]': False,
            'Optional[List[str]]': False,
            'Optional[Chat]': False,
            'Optional[User]': False,
            'Optional[Animation]': False,
            'ChatMember': False,
            'Optional[InlineKeyboardMarkup]': False,
            'Chat': False,
            'Message': False,
            'Optional[List[PassportFile]]': False,
            'Location': False,
            'bool': True,
            'Optional[PassportData]': False,
            'User': False,
            'List[str]': False,
            'Optional[Contact]': False,
            'List[List[KeyboardButton]]': False,
            'Optional[InputMessageContent]': False,
            'Optional[Video]': False,
            'int': True,
            'Optional[List[LabeledPrice]]': False,
            'Optional[str]': False,
            'Optional[Location]': False,
            'EncryptedCredentials': False,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': False,
            'Optional[Poll]': False,
            'Optional[Audio]': False,
            'Optional[Message]': False,
            'Optional[PreCheckoutQuery]': False,
            'Optional[VideoNote]': False,
            'Optional[CallbackQuery]': False,
            'Optional[Union[InputFile, str]]': False,
            'Pool': False,
            'StickerSet': False,
            'Optional[Document]': False,
            'Optional[ChosenInlineResult]': False,
            'List[PhotoSize]': False,
            'InputFile': False,
            'InputMedia': False,
            'Optional[Game]': False,
            'Optional[ChatPhoto]': False,
            'Optional[Invoice]': False,
            'Optional[MaskPosition]': False,
            'List[List[InlineKeyboardButton]]': False,
            'Optional[CallbackGame]': False,
            'Optional[bool]': False,
            'Optional[Voice]': False,
            'List[InlineQueryResult]': False,
            'Optional[ShippingQuery]': False,
            'Union[int, str]': False,
            'Optional[SuccessfulPayment]': False,
            'InputMessageContent': False,
            'List[ChatMember]': False,
            'Optional[PassportFile]': False,
            'Optional[InputFile]': False,
            'Union[Message, bool]': False,
            'Optional[int]': False,
            'Optional[Sticker]': False,
            'List[List[PhotoSize]]': False,
            'Optional[List[PhotoSize]]': False,
            'Optional[List[User]]': False,
            'List[EncryptedPassportElement]': False,
            'Optional[PhotoSize]': False,
            'List[Update]': False,
            'List[LabeledPrice]': False,
            'UserProfilePhotos': False,
            'List[Union[InputMediaPhoto, InputMediaVideo]]': False,
            'WebhookInfo': False,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_simple, v)

    def test_is_simple_in_opt(self):
        data_to_test = {
            'Optional[Venue]': False,
            'Optional[OrderInfo]': False,
            'Optional[Union[int, str]]': False,
            'Optional[ShippingAddress]': False,
            'Optional[InlineQuery]': False,
            'Optional[List[MessageEntity]]': False,
            'Optional[List[str]]': False,
            'Optional[Chat]': False,
            'Optional[User]': False,
            'Optional[Animation]': False,
            'Optional[InlineKeyboardMarkup]': False,
            'Optional[List[PassportFile]]': False,
            'Optional[PassportData]': False,
            'Optional[Contact]': False,
            'Optional[InputMessageContent]': False,
            'Optional[Video]': False,
            'Optional[List[LabeledPrice]]': False,
            'Optional[str]': True,
            'Optional[Location]': False,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': False,
            'Optional[Poll]': False,
            'Optional[Audio]': False,
            'Optional[Message]': False,
            'Optional[PreCheckoutQuery]': False,
            'Optional[VideoNote]': False,
            'Optional[CallbackQuery]': False,
            'Optional[Union[InputFile, str]]': False,
            'Optional[Document]': False,
            'Optional[ChosenInlineResult]': False,
            'Optional[Game]': False,
            'Optional[ChatPhoto]': False,
            'Optional[Invoice]': False,
            'Optional[MaskPosition]': False,
            'Optional[CallbackGame]': False,
            'Optional[Voice]': False,
            'Optional[ShippingQuery]': False,
            'Optional[SuccessfulPayment]': False,
            'Optional[PassportFile]': False,
            'Optional[InputFile]': False,
            'Optional[Sticker]': False,
            'Optional[List[PhotoSize]]': False,
            'Optional[bool]': True,
            'Optional[int]': True,
            'Optional[float]': True,
            'Optional[List[User]]': False,
            'Optional[PhotoSize]': False,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_simple_in_opt, v)


    def test_sanitized(self):
        data_to_test = {
            "typing.Union[telegrambotapiwrapper.typelib.Message, bool]": 'Union[Message, bool]',
            "<class 'telegrambotapiwrapper.typelib.Message'>": 'Message',
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).sanitized, v)


    def test_is_simple_in_opt_and_not_opt(self):
        data_to_test = {
            'Optional[Venue]': False,
            'Optional[OrderInfo]': False,
            'File': False,
            'ShippingAddress': False,
            'List[PassportElementError]': False,
            'Union[InputFile, str]': False,
            'Optional[Union[int, str]]': False,
            'Optional[ShippingAddress]': False,
            'str': True,
            'Optional[InlineQuery]': False,
            'List[PollOption]': False,
            'Optional[List[MessageEntity]]': False,
            'List[Sticker]': False,
            'float': True,
            'List[GameHighScore]': False,
            'Optional[List[str]]': False,
            'Optional[Chat]': False,
            'Optional[User]': False,
            'Optional[Animation]': False,
            'ChatMember': False,
            'Optional[InlineKeyboardMarkup]': False,
            'Chat': False,
            'Message': False,
            'Optional[List[PassportFile]]': False,
            'Location': False,
            'bool': True,
            'Optional[PassportData]': False,
            'User': False,
            'List[str]': False,
            'Optional[Contact]': False,
            'List[List[KeyboardButton]]': False,
            'Optional[InputMessageContent]': False,
            'Optional[Video]': False,
            'int': True,
            'Optional[List[LabeledPrice]]': False,
            'Optional[str]': True,
            'Optional[float]': True,
            'Optional[int]': True,
            'Optional[bool]': True,
            'Optional[Location]': False,
            'EncryptedCredentials': False,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': False,
            'Optional[Poll]': False,
            'Optional[Audio]': False,
            'Optional[Message]': False,
            'Optional[PreCheckoutQuery]': False,
            'Optional[VideoNote]': False,
            'Optional[CallbackQuery]': False,
            'Optional[Union[InputFile, str]]': False,
            'Pool': False,
            'StickerSet': False,
            'Optional[Document]': False,
            'Optional[ChosenInlineResult]': False,
            'List[PhotoSize]': False,
            'InputFile': False,
            'InputMedia': False,
            'Optional[Game]': False,
            'Optional[ChatPhoto]': False,
            'Optional[Invoice]': False,
            'Optional[MaskPosition]': False,
            'List[List[InlineKeyboardButton]]': False,
            'Optional[CallbackGame]': False,
            'Optional[Voice]': False,
            'List[InlineQueryResult]': False,
            'Optional[ShippingQuery]': False,
            'Union[int, str]': False,
            'Optional[SuccessfulPayment]': False,
            'InputMessageContent': False,
            'List[ChatMember]': False,
            'Optional[PassportFile]': False,
            'Optional[InputFile]': False,
            'Union[Message, bool]': False,
            'Optional[Sticker]': False,
            'List[List[PhotoSize]]': False,
            'Optional[List[PhotoSize]]': False,
            'Optional[List[User]]': False,
            'List[EncryptedPassportElement]': False,
            'Optional[PhotoSize]': False,
            'List[Update]': False,
            'List[LabeledPrice]': False,
            'UserProfilePhotos': False,
            'List[Union[InputMediaPhoto, InputMediaVideo]]': False,
            'WebhookInfo': False,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_simple_in_opt_and_not_opt, v)



    def test_is_optional(self):
        data_to_test = {
            'ShippingAddress': False,
            'bool': False,
            'Optional[ShippingAddress]': True,
            'List[List[InlineKeyboardButton]]': False,
            'Optional[OrderInfo]': True,
            'Optional[Contact]': True,
            'InputMessageContent': False,
            'Chat': False,
            'Optional[List[User]]': True,
            'Optional[Venue]': True,
            'Optional[Voice]': True,
            'Optional[Game]': True,
            'Optional[User]': True,
            'Optional[Animation]': True,
            'List[List[KeyboardButton]]': False,
            'List[InlineQueryResult]': False,
            'InputMedia': False,
            'Optional[VideoNote]': True,
            'StickerSet': False,
            'Optional[List[PhotoSize]]': True,
            'Optional[Union[InputFile, str]]': True,
            'Optional[CallbackGame]': True,
            'Optional[Message]': True,
            'List[GameHighScore]': False,
            'Optional[InputMessageContent]': True,
            'User': False,
            'Optional[int]': True,
            'List[LabeledPrice]': False,
            'List[List[PhotoSize]]': False,
            'Optional[List[MessageEntity]]': True,
            'Optional[ChatPhoto]': True,
            'Optional[List[str]]': True,
            'Optional[Video]': True,
            'List[Union[InputMediaPhoto, InputMediaVideo]]': False,
            'Union[int, str]': False,
            'Pool': False,
            'File': False,
            'Optional[Audio]': True,
            'WebhookInfo': False,
            'List[PollOption]': False,
            'Optional[ShippingQuery]': True,
            'Optional[InputFile]': True,
            'Optional[Document]': True,
            'Optional[Poll]': True,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': True,
            'Optional[PassportData]': True,
            'List[ChatMember]': False,
            'int': False,
            'List[PassportElementError]': False,
            'EncryptedCredentials': False,
            'List[Sticker]': False,
            'Optional[InlineQuery]': True,
            'Optional[str]': True,
            'Optional[ChosenInlineResult]': True,
            'Optional[Chat]': True,
            'Location': False,
            'Optional[PreCheckoutQuery]': True,
            'Union[Message, bool]': False,
            'Optional[CallbackQuery]': True,
            'Optional[bool]': True,
            'InputFile': False,
            'Optional[List[PassportFile]]': True,
            'List[str]': False,
            'Optional[Sticker]': True,
            'Optional[PhotoSize]': True,
            'List[Update]': False,
            'UserProfilePhotos': False,
            'Optional[Invoice]': True,
            'List[PhotoSize]': False,
            'Optional[Location]': True,
            'Union[InputFile, str]': False,
            'Optional[MaskPosition]': True,
            'str': False,
            'float': False,
            'ChatMember': False,
            'List[EncryptedPassportElement]': False,
            'Optional[Union[int, str]]': True,
            'Optional[List[LabeledPrice]]': True,
            'Optional[PassportFile]': True,
            'Message': False,
            'Optional[InlineKeyboardMarkup]': True,
            'Optional[SuccessfulPayment]': True,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_optional, v)

    def test_inner_part_of_optional(self):
        data_to_test = {
            'Optional[PassportData]': 'PassportData',
            'Optional[str]': 'str',
            'Optional[User]': 'User',
            'Optional[int]': 'int',
            'Optional[List[PhotoSize]]': 'List[PhotoSize]',
            'Optional[Union[int, str]]': 'Union[int, str]',
            'Optional[Message]': 'Message',
            'Optional[ChatPhoto]': 'ChatPhoto',
            'Optional[Contact]': 'Contact',
            'Optional[Venue]': 'Venue',
            'Optional[ShippingAddress]': 'ShippingAddress',
            'Optional[Voice]': 'Voice',
            'Optional[List[LabeledPrice]]': 'List[LabeledPrice]',
            'Optional[VideoNote]': 'VideoNote',
            'Optional[Sticker]': 'Sticker',
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]':
                'Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]',
            'Optional[Document]': 'Document',
            'Optional[List[PassportFile]]': 'List[PassportFile]',
            'Optional[Location]': 'Location',
            'Optional[List[User]]': 'List[User]',
            'Optional[PhotoSize]': 'PhotoSize',
            'Optional[PreCheckoutQuery]': 'PreCheckoutQuery',
            'Optional[Chat]': 'Chat',
            'Optional[Animation]': 'Animation',
            'Optional[Poll]': 'Poll',
            'Optional[ChosenInlineResult]': 'ChosenInlineResult',
            'Optional[CallbackGame]': 'CallbackGame',
            'Optional[Audio]': 'Audio',
            'Optional[bool]': 'bool',
            'Optional[MaskPosition]': 'MaskPosition',
            'Optional[CallbackQuery]': 'CallbackQuery',
            'Optional[Union[InputFile, str]]': 'Union[InputFile, str]',
            'Optional[OrderInfo]': 'OrderInfo',
            'Optional[Video]': 'Video',
            'Optional[ShippingQuery]': 'ShippingQuery',
            'Optional[Game]': 'Game',
            'Optional[InlineKeyboardMarkup]': 'InlineKeyboardMarkup',
            'Optional[InlineQuery]': 'InlineQuery',
            'Optional[InputMessageContent]': 'InputMessageContent',
            'Optional[List[str]]': 'List[str]',
            'Optional[Invoice]': 'Invoice',
            'Optional[PassportFile]': 'PassportFile',
            'Optional[InputFile]': 'InputFile',
            'Optional[SuccessfulPayment]': 'SuccessfulPayment',
            'Optional[List[MessageEntity]]': 'List[MessageEntity]',
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).inner_part_of_optional, v)

    def test_inner_part_of_union(self):
        data_to_test = {
            'Union[Message, bool]': 'Message, bool',
            'Union[int, str]': 'int, str',
            'Union[InputFile, str]': 'InputFile, str',
            'Union[InputMediaPhoto, InputMediaVideo]': 'InputMediaPhoto, InputMediaVideo',
            'Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]':
                'InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply',
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).inner_part_of_union, v)

    def test_inner_part_of_list(self):
        data_to_test = {
            'List[EncryptedPassportElement]': 'EncryptedPassportElement',
            'List[GameHighScore]': 'GameHighScore',
            'List[Update]': 'Update',
            'List[PassportElementError]': 'PassportElementError',
            'List[PhotoSize]': 'PhotoSize',
            'List[List[PhotoSize]]': 'List[PhotoSize]',
            'List[InlineQueryResult]': 'InlineQueryResult',
            'List[Union[InputMediaPhoto, InputMediaVideo]]': 'Union[InputMediaPhoto, InputMediaVideo]',
            'List[PollOption]': 'PollOption',
            'List[ChatMember]': 'ChatMember',
            'List[LabeledPrice]': 'LabeledPrice',
            'List[List[InlineKeyboardButton]]': 'List[InlineKeyboardButton]',
            'List[str]': 'str',
            'List[List[KeyboardButton]]': 'List[KeyboardButton]',
            'List[Sticker]': 'Sticker',
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).inner_part_of_list, v)

    def test_types_in_union(self):
        data_to_test = {
            'Union[InputFile, str]': ['InputFile', 'str'],
            'Union[Message, bool]': ['Message', 'bool'],
            'Union[int, str]': ['int', 'str'],
            'Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]': [
                'InlineKeyboardMarkup', 'ReplyKeyboardMarkup', 'ReplyKeyboardRemove', 'ForceReply'
            ]
        }
        for k, v in data_to_test.items():
            self.assertListEqual(AnnotationWrapper(k).types_in_union, v)

    def test_is_list(self):
        data_to_test = {
            'Optional[ShippingAddress]': False,
            'Optional[List[PhotoSize]]': False,
            'List[EncryptedPassportElement]': True,
            'Optional[ShippingQuery]': False,
            'List[Sticker]': True,
            'int': False,
            'Optional[Message]': False,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': False,
            'Optional[VideoNote]': False,
            'Optional[MaskPosition]': False,
            'Chat': False,
            'Message': False,
            'Optional[Location]': False,
            'ChatMember': False,
            'Optional[Video]': False,
            'List[List[PhotoSize]]': False,
            'EncryptedCredentials': False,
            'List[str]': True,
            'User': False,
            'File': False,
            'List[GameHighScore]': True,
            'Optional[Chat]': False,
            'ShippingAddress': False,
            'Union[Message, bool]': False,
            'Optional[Union[int, str]]': False,
            'List[Update]': True,
            'bool': False,
            'InputMessageContent': False,
            'List[Union[InputMediaPhoto, InputMediaVideo]]': True,
            'List[PollOption]': True,
            'Optional[List[str]]': False,
            'Optional[bool]': False,
            'Location': False,
            'Optional[ChosenInlineResult]': False,
            'Optional[Poll]': False,
            'Optional[str]': False,
            'Optional[User]': False,
            'Optional[Invoice]': False,
            'Optional[List[LabeledPrice]]': False,
            'Optional[PreCheckoutQuery]': False,
            'Optional[Venue]': False,
            'List[List[KeyboardButton]]': False,
            'Optional[InputMessageContent]': False,
            'List[PhotoSize]': True,
            'List[ChatMember]': True,
            'Optional[CallbackQuery]': False,
            'Optional[Audio]': False,
            'Optional[InputFile]': False,
            'Optional[int]': False,
            'Optional[SuccessfulPayment]': False,
            'StickerSet': False,
            'str': False,
            'WebhookInfo': False,
            'Optional[Union[InputFile, str]]': False,
            'Optional[List[MessageEntity]]': False,
            'Optional[Contact]': False,
            'Union[int, str]': False,
            'List[PassportElementError]': True,
            'Optional[InlineKeyboardMarkup]': False,
            'Optional[Game]': False,
            'InputMedia': False,
            'List[LabeledPrice]': True,
            'Optional[PassportFile]': False,
            'Union[InputFile, str]': False,
            'InputFile': False,
            'List[InlineQueryResult]': True,
            'Optional[CallbackGame]': False,
            'Optional[Voice]': False,
            'List[List[InlineKeyboardButton]]': False,
            'Optional[OrderInfo]': False,
            'Optional[List[PassportFile]]': False,
            'Optional[ChatPhoto]': False,
            'UserProfilePhotos': False,
            'Pool': False,
            'Optional[InlineQuery]': False,
            'Optional[PassportData]': False,
            'Optional[Document]': False,
            'Optional[List[User]]': False,
            'float': False,
            'Optional[Sticker]': False,
            'Optional[Animation]': False,
            'Optional[PhotoSize]': False,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_list, v)

    def test_is_union(self):
        data_to_test = {
            'Optional[ShippingAddress]': False,
            'Optional[List[PhotoSize]]': False,
            'List[EncryptedPassportElement]': False,
            'Optional[ShippingQuery]': False,
            'List[Sticker]': False,
            'int': False,
            'Optional[Message]': False,
            'Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]]': False,
            'Optional[VideoNote]': False,
            'Optional[MaskPosition]': False,
            'Chat': False,
            'Message': False,
            'Optional[Location]': False,
            'ChatMember': False,
            'Optional[Video]': False,
            'List[List[PhotoSize]]': False,
            'EncryptedCredentials': False,
            'List[str]': False,
            'User': False,
            'File': False,
            'List[GameHighScore]': False,
            'Optional[Chat]': False,
            'ShippingAddress': False,
            'Union[Message, bool]': True,
            'Optional[Union[int, str]]': False,
            'List[Update]': False,
            'bool': False,
            'InputMessageContent': False,
            'List[Union[InputMediaPhoto, InputMediaVideo]]': False,
            'List[PollOption]': False,
            'Optional[List[str]]': False,
            'Optional[bool]': False,
            'Location': False,
            'Optional[ChosenInlineResult]': False,
            'Optional[Poll]': False,
            'Optional[str]': False,
            'Optional[User]': False,
            'Optional[Invoice]': False,
            'Optional[List[LabeledPrice]]': False,
            'Optional[PreCheckoutQuery]': False,
            'Optional[Venue]': False,
            'List[List[KeyboardButton]]': False,
            'Optional[InputMessageContent]': False,
            'List[PhotoSize]': False,
            'List[ChatMember]': False,
            'Optional[CallbackQuery]': False,
            'Optional[Audio]': False,
            'Optional[InputFile]': False,
            'Optional[int]': False,
            'Optional[SuccessfulPayment]': False,
            'StickerSet': False,
            'str': False,
            'WebhookInfo': False,
            'Optional[Union[InputFile, str]]': False,
            'Optional[List[MessageEntity]]': False,
            'Optional[Contact]': False,
            'Union[int, str]': True,
            'List[PassportElementError]': False,
            'Optional[InlineKeyboardMarkup]': False,
            'Optional[Game]': False,
            'InputMedia': False,
            'List[LabeledPrice]': False,
            'Optional[PassportFile]': False,
            'Union[InputFile, str]': True,
            'InputFile': False,
            'List[InlineQueryResult]': False,
            'Optional[CallbackGame]': False,
            'Optional[Voice]': False,
            'List[List[InlineKeyboardButton]]': False,
            'Optional[OrderInfo]': False,
            'Optional[List[PassportFile]]': False,
            'Optional[ChatPhoto]': False,
            'UserProfilePhotos': False,
            'Pool': False,
            'Optional[InlineQuery]': False,
            'Optional[PassportData]': False,
            'Optional[Document]': False,
            'Optional[List[User]]': False,
            'float': False,
            'Optional[Sticker]': False,
            'Optional[Animation]': False,
            'Optional[PhotoSize]': False,
        }
        for k, v in data_to_test.items():
            self.assertEqual(AnnotationWrapper(k).is_union, v)
