<div align="center">
  <img src="./docs/logo.png" width="600"/>
</div>
<br />

[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pytools)](https://pypi.org/project/pytools/)
[![PyPI](https://img.shields.io/pypi/v/pytools)](https://pypi.org/project/pytools)
[![license](https://img.shields.io/github/license/CharlesPikachu/pytools.svg)](https://github.com/CharlesPikachu/pytools/blob/master/LICENSE)
[![issue resolution](https://isitmaintained.com/badge/resolution/CharlesPikachu/pytools.svg)](https://github.com/CharlesPikachu/pytools/issues)
[![open issues](https://isitmaintained.com/badge/open/CharlesPikachu/pytools.svg)](https://github.com/CharlesPikachu/pytools/issues)

Documents: still on the way


# Pytools
```
Some useful tools written by pure python.
You can star this repository to keep track of the project if it's helpful for you, thank you for your support.
```


# Support List
|   Name                               |     Introduction                                                  |      Code                                                 |     In Chinese                    |
|   :----:                             |     :----:                                                        |      :----:                                               |     :----:                        |
|   portscanner                        |     [click](https://mp.weixin.qq.com/s/98VnIO9JEdAqcIPdxq1cOg)    |      [click](./pytools/modules/portscanner)               |     简易端口扫描器                |
|   timer                              |     [click](https://mp.weixin.qq.com/s/8HcXQjcsyegYzp_yt1cE5w)    |      [click](./pytools/modules/timer)                     |     简易计时器                    |
|   emailsecurity                      |     [click](https://mp.weixin.qq.com/s/9u1CIa8MdoiXGGdPqae8fA)    |      [click](./pytools/modules/emailsecurity)             |     邮箱安全性验证工具            |
|   calculator                         |     [click](https://mp.weixin.qq.com/s/x6ygDEWHiYX10AP4y8e3MA)    |      [click](./pytools/modules/calculator)                |     简易计算器                    |
|   iplocationquery                    |     [click](https://mp.weixin.qq.com/s/lYWxt00erojeSoyRWA1R5g)    |      [click](./pytools/modules/iplocationquery)           |     根据IP地址查询地理信息小工具  |
|   clock                              |     [click](https://mp.weixin.qq.com/s/8JPxEHGZ2u7dsEUJS-9WbQ)    |      [click](./pytools/modules/clock)                     |     简易时钟                      |
|   inquiryexpress                     |     [click](https://mp.weixin.qq.com/s/haNR8Yr9RsSXaTd0jl5PFA)    |      [click](./pytools/modules/inquiryexpress)            |     快递查询系统                  |
|   qrcodegenerator                    |     [click](https://mp.weixin.qq.com/s/XFmumQbQP4d9qf6HQBLVnA)    |      [click](./pytools/modules/qrcodegenerator)           |     二维码生成器                  |
|   musicplayer                        |     [click](https://mp.weixin.qq.com/s/SUyRNz_M7B6bcdV7-YxlZQ)    |      [click](./pytools/modules/musicplayer)               |     音乐播放器                    |
|   luxunsentencesquery                |     [click](https://mp.weixin.qq.com/s/dQ8NfwFDoZw-6c1SPEl0aw)    |      [click](./pytools/modules/luxunsentencesquery)       |     鲁迅名言查询系统              |
|   runcat                             |     [click](https://mp.weixin.qq.com/s/8Fgzb8JiAoNSJqUanSi85Q)    |      [click](./pytools/modules/runcat)                    |     奔跑的猫                      |
|   newyearcardgenerator               |     [click](https://mp.weixin.qq.com/s/XCPkiXrKGZrVpNvyRlzgvA)    |      [click](./pytools/modules/newyearcardgenerator)      |     新年贺卡生成器                |
|   naughtyconfession                  |     [click](https://mp.weixin.qq.com/s/wMxMrx07ZeOfYEXpuGYVsg)    |      [click](./pytools/modules/naughtyconfession)         |     仿抖音表白神器                |
|   succulentquery                     |     [click](https://mp.weixin.qq.com/s/1_PzYVkMXwXrCiHBP5nZtQ)    |      [click](./pytools/modules/succulentquery)            |     多肉数据查询系统              | 
|   artsigngenerator                   |     [click](https://mp.weixin.qq.com/s/CYxAgJZdEc87XIRcqWgRqw)    |      [click](./pytools/modules/artsigngenerator)          |     艺术签名生成器                | 
|   genderpredictor                    |     [click](https://mp.weixin.qq.com/s/NS3DfRpIfw5wFsV3EaqEzQ)    |      [click](./pytools/modules/genderpredictor)           |     给定中文名的性别猜测器        |
|   idiomsolitaire                     |     [click](https://mp.weixin.qq.com/s/ncgl2OBUZsE77gOy1gclYg)    |      [click](./pytools/modules/idiomsolitaire)            |     成语接龙小软件                |
|   trumptweetsgenerator               |     [click](https://mp.weixin.qq.com/s/KO_nWpejIqQNKZgbCBfWEQ)    |      [click](./pytools/modules/trumptweetsgenerator)      |     特朗普推特生成器              |
|   idcardquery                        |     [click](https://mp.weixin.qq.com/s/2zljIGm-5WlRCq68ADXSiw)    |      [click](./pytools/modules/idcardquery)               |     身份证信息查询工具            |
|   videoplayer                        |     [click](https://mp.weixin.qq.com/s/pG6SwhfNSWZuHxuMcEQZog)    |      [click](./pytools/modules/videoplayer)               |     视频播放器                    |
|   coupletgenerator                   |     [click](https://mp.weixin.qq.com/s/L1gmiMJ-M8T-QgSeJckYEw)    |      [click](./pytools/modules/coupletgenerator)          |     春联生成器                    |


# Coming Soon
|   Name                               |     Introduction                                                  |      Code                                                                              |     In Chinese              |
|   :----:                             |     :----:                                                        |      :----:                                                                            |     :----:                  |
|   Control your computer by emails    |     [click](https://mp.weixin.qq.com/s/KnG-mncegaB35v5THAUJXQ)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/ControlPCbyEmail)     |     邮件控制电脑            |
|   Movie helper                       |     [click](https://mp.weixin.qq.com/s/VlwCyD99YBYhIbwG4rYN3A)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/MovieHelper)          |     电影小助手              |
|   Translator                         |     [click](https://mp.weixin.qq.com/s/SWR-bUdqfpn3NxR5OgCYlg)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/Translator)           |     翻译软件                |
|   ComputerSinger                     |     [click](https://mp.weixin.qq.com/s/-yT1NxAUTN8hzZs76qzqjQ)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/ComputerSinger)       |     电脑蜂鸣器哼歌          |
|   HubbleSee                          |     [click](https://mp.weixin.qq.com/s/hJDcRHNHT1Zc0akctvWqsA)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/HubbleSee)            |     你生日那天的宇宙        |
|   DesktopPet                         |     [click](https://mp.weixin.qq.com/s/4kOzdRXmrxzR88QcYYSFvQ)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/DesktopPet)           |     桌面宠物                |
|   earthWallpaper                     |     [click](https://mp.weixin.qq.com/s/pDZpzzpd1g5bodtFdEROEg)    |      [click](https://github.com/CharlesPikachu/Tools/tree/master/earthWallpaper)       |     地球卫星壁纸            |


# Install
#### Pip install
```
run "pip install pytools"
```
#### Source code install
```sh
(1) Offline
Step1: git clone https://github.com/CharlesPikachu/pytools.git
Step2: cd pytools -> run "python setup.py install"
(2) Online
run "pip install git+https://github.com/CharlesPikachu/pytools.git@master"
```


# Quick Start
```python
import random
from pikachupytools import pytools

tool_client = pytools.pytools()
all_supports = tool_client.getallsupported()
tool_client.execute(random.choice(list(all_supports.values())))
```


# More
#### WeChat Official Accounts
*Charles_pikachu*  
![img](./docs/pikachu.jpg)