"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceDirectory = exports.ResourceDirectoryProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "ResourceDirectoryProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosResourceDirectory; } });
/**
 * A ROS resource type:  `ALIYUN::ResourceManager::ResourceDirectory`
 */
class ResourceDirectory extends ros.Resource {
    /**
     * Create a new `ALIYUN::ResourceManager::ResourceDirectory`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosResourceDirectory = new resourcemanager_generated_1.RosResourceDirectory(this, id, {}, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        props;
        this.resource = rosResourceDirectory;
        this.attrMasterAccountId = rosResourceDirectory.attrMasterAccountId;
        this.attrMasterAccountName = rosResourceDirectory.attrMasterAccountName;
        this.attrResourceDirectoryId = rosResourceDirectory.attrResourceDirectoryId;
        this.attrRootFolderId = rosResourceDirectory.attrRootFolderId;
    }
}
exports.ResourceDirectory = ResourceDirectory;
//# sourceMappingURL=data:application/json;base64,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