"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Handshake = exports.HandshakeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "HandshakeProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosHandshake; } });
/**
 * A ROS resource type:  `ALIYUN::ResourceManager::Handshake`
 */
class Handshake extends ros.Resource {
    /**
     * Create a new `ALIYUN::ResourceManager::Handshake`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosHandshake = new resourcemanager_generated_1.RosHandshake(this, id, {
            note: props.note,
            targetType: props.targetType,
            targetEntity: props.targetEntity,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosHandshake;
        this.attrHandshakeId = rosHandshake.attrHandshakeId;
        this.attrMasterAccountId = rosHandshake.attrMasterAccountId;
        this.attrMasterAccountName = rosHandshake.attrMasterAccountName;
        this.attrNote = rosHandshake.attrNote;
        this.attrResourceDirectoryId = rosHandshake.attrResourceDirectoryId;
        this.attrTargetEntity = rosHandshake.attrTargetEntity;
        this.attrTargetType = rosHandshake.attrTargetType;
    }
}
exports.Handshake = Handshake;
//# sourceMappingURL=data:application/json;base64,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