/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.GenericArrayCreator;
import com.jmatio.types.MLArray;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLChar
extends MLArray
implements GenericArrayCreator<Character> {
    Character[] chars = this.createArray(this.getM(), this.getN());

    public MLChar(String name, String value) {
        this(name, new int[]{1, value.length()}, 4, 0);
        this.set(value);
    }

    public MLChar(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public Character[] createArray(int m, int n) {
        return new Character[m * n];
    }

    public void setChar(char ch, int index) {
        this.chars[index] = new Character(ch);
    }

    public void set(String value) {
        char[] cha = value.toCharArray();
        int i = 0;
        while (i < this.getN() && i < value.length()) {
            this.setChar(cha[i], i);
            ++i;
        }
    }

    public Character getChar(int m, int n) {
        return this.chars[this.getIndex(m, n)];
    }

    public Character[] exportChar() {
        return this.chars;
    }

    public boolean equals(Object o) {
        if (o instanceof MLChar) {
            return Arrays.equals((Object[])this.chars, (Object[])((MLChar)o).chars);
        }
        return super.equals(o);
    }

    public String getString(int m) {
        StringBuffer charbuff = new StringBuffer();
        int n = 0;
        while (n < this.getN()) {
            charbuff.append(this.getChar(m, n));
            ++n;
        }
        return charbuff.toString();
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        int m = 0;
        while (m < this.getM()) {
            sb.append("\t");
            StringBuffer charbuff = new StringBuffer();
            charbuff.append("'");
            int n = 0;
            while (n < this.getN()) {
                charbuff.append(this.getChar(m, n));
                ++n;
            }
            charbuff.append("'");
            sb.append(charbuff);
            sb.append("\n");
            ++m;
        }
        return sb.toString();
    }
}

