/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlPrint;
import ch.javasoft.xml.config.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfig {
    public static final String NO_APP_NAME = "main";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
    protected final Document mDocument;
    protected final String[] mArgs;
    protected final Date mTimestamp = new Date();
    private String mAppName;

    private static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected XmlConfig(String appName, Document xmlDoc) {
        this(appName, xmlDoc, null);
    }

    protected XmlConfig(String appName, Document xmlDoc, String[] args) {
        this.mAppName = appName;
        this.mDocument = xmlDoc;
        this.mArgs = args == null ? new String[]{} : args;
    }

    public static XmlConfig getXmlConfig(File xmlFile) throws DocumentException {
        return XmlConfig.getXmlConfig(NO_APP_NAME, xmlFile);
    }

    public static XmlConfig getXmlConfig(Reader xmlFile) throws DocumentException {
        return XmlConfig.getXmlConfig(NO_APP_NAME, xmlFile);
    }

    public static XmlConfig getXmlConfig(InputStream xmlFile) throws DocumentException {
        return XmlConfig.getXmlConfig(NO_APP_NAME, xmlFile);
    }

    public static XmlConfig getXmlConfig(Document xmlDocument) throws DocumentException {
        return XmlConfig.getXmlConfig(NO_APP_NAME, xmlDocument);
    }

    public static XmlConfig getXmlConfig(String appName, File xmlFile) throws DocumentException {
        return XmlConfig.getXmlConfig(appName, new SAXReader().read(xmlFile));
    }

    public static XmlConfig getXmlConfig(String appName, Reader xmlFile) throws DocumentException {
        return XmlConfig.getXmlConfig(appName, new SAXReader().read(xmlFile));
    }

    public static XmlConfig getXmlConfig(String appName, InputStream xmlFile) throws DocumentException {
        return XmlConfig.getXmlConfig(appName, new SAXReader().read(xmlFile));
    }

    public static XmlConfig getXmlConfig(String appName, Document xmlDocument) throws DocumentException {
        return new XmlConfig(appName, xmlDocument);
    }

    public static XmlConfig getXmlConfig(File xmlFile, String[] args) throws DocumentException {
        return XmlConfig.getXmlConfig(NO_APP_NAME, xmlFile, args);
    }

    public static XmlConfig getXmlConfig(InputStream xmlFile, String[] args) throws DocumentException {
        return XmlConfig.getXmlConfig(NO_APP_NAME, xmlFile, args);
    }

    public static XmlConfig getXmlConfig(String appName, File xmlFile, String[] args) throws DocumentException {
        return new XmlConfig(appName, new SAXReader().read(xmlFile), args);
    }

    public static XmlConfig getXmlConfig(String appName, InputStream xmlFile, String[] args) throws DocumentException {
        return new XmlConfig(appName, new SAXReader().read(xmlFile), args);
    }

    public void writeTo(OutputStream out) {
        Document doc = this.toXmlDocument();
        new XmlPrint().print(doc, out);
    }

    public void writeTo(Writer writer) {
        Document doc = this.toXmlDocument();
        new XmlPrint().print(doc, writer);
    }

    public Document toXmlDocument() {
        Document doc = (Document)this.mDocument.clone();
        doc.getRootElement().elements(XmlElement.application.getXmlName()).clear();
        Element app = doc.getRootElement().addElement(XmlElement.application.getXmlName());
        app.addAttribute(XmlAttribute.name.getXmlName(), this.mAppName);
        String[] stringArray = this.mArgs;
        int n = this.mArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Element elArg = app.addElement(XmlElement.arg.getXmlName());
            elArg.addAttribute(XmlAttribute.value.getXmlName(), arg);
            ++n2;
        }
        return doc;
    }

    public static XmlConfig fromXmlDocument(File file) throws DocumentException {
        return XmlConfig.fromXmlDocument(new SAXReader().read(file));
    }

    public static XmlConfig fromXmlDocument(Reader reader) throws DocumentException {
        return XmlConfig.fromXmlDocument(new SAXReader().read(reader));
    }

    public static XmlConfig fromXmlDocument(Document doc) {
        Element app = doc.getRootElement().element(XmlElement.application.getXmlName());
        String appName = app.attributeValue(XmlAttribute.name.getXmlName());
        ArrayList<String> args = new ArrayList<String>();
        Iterator it = app.elementIterator(XmlElement.arg.getXmlName());
        while (it.hasNext()) {
            args.add(((Element)it.next()).attributeValue(XmlAttribute.value.getXmlName()));
        }
        doc.remove(app);
        return new XmlConfig(appName, doc, args.toArray(new String[args.size()]));
    }

    protected int getArgCount() {
        return this.mArgs.length;
    }

    protected String getArg(int index) {
        return this.mArgs[index];
    }

    public String[] getArgs() {
        String[] copy = new String[this.mArgs.length];
        System.arraycopy(this.mArgs, 0, copy, 0, copy.length);
        return copy;
    }

    protected Element getRootElement() {
        return this.mDocument.getRootElement();
    }

    public String getAppName() {
        return this.mAppName;
    }

    public void setAppName(String appName) {
        this.mAppName = appName;
    }

    public void setDefaultConfigName(String name) {
        this.getRootElement().addAttribute(XmlAttribute.def.getXmlName(), name);
    }

    public String getDefaultConfigName() {
        return this.getRootElement().attributeValue(XmlAttribute.def.getXmlName());
    }

    public Document getDefaultConfigDocument() throws XmlConfigException {
        return this.getConfigDocument(this.getDefaultConfigName());
    }

    public Element getDefaultConfigElement() throws XmlConfigException {
        return this.getConfigElement(this.getDefaultConfigName());
    }

    public Element getConfigElement(String name) throws XmlConfigException {
        Document doc = this.getConfigDocument(name);
        Element root = doc.getRootElement();
        return XmlUtil.getRequiredSingleChildElement(root, XmlElement.config);
    }

    public Document getConfigDocument(String name) throws XmlConfigException {
        if (name == null) {
            throw new NullPointerException("name argument is required");
        }
        Iterator it = this.getRootElement().elementIterator(XmlElement.config.getXmlName());
        while (it.hasNext()) {
            Element cfg = (Element)it.next();
            String cfgName = cfg.attributeValue(XmlAttribute.name.getXmlName());
            if (!name.equals(cfgName)) continue;
            Element copy = cfg.createCopy();
            List<Element> resolved = this.resolve(copy, XmlUtil.getElementPath(copy, false));
            if (resolved.size() != 1) {
                throw new XmlConfigException("resolved config not unique", (Node)cfg);
            }
            return XmlConfig.createDocument(resolved.get(0), name);
        }
        throw new IllegalArgumentException("no such config: " + name);
    }

    private static Document createDocument(Element configElement, String configName) {
        Document doc = DocumentHelper.createDocument();
        Element configList = DocumentHelper.createElement((String)XmlElement.config_list.getXmlName());
        configElement.addAttribute(XmlAttribute.name.getXmlName(), configName);
        configList.addAttribute(XmlAttribute.def.getXmlName(), configName);
        configList.add(configElement);
        doc.setRootElement(configList);
        return doc;
    }

    protected List<Element> resolve(Iterator<Element> elementIterator, String path) throws XmlConfigException {
        ArrayList<Element> resolved = new ArrayList<Element>();
        while (elementIterator.hasNext()) {
            Element child = elementIterator.next();
            String childPath = path == null ? XmlUtil.getElementPath(child, true) : String.valueOf(path) + "/" + XmlUtil.getElementPath(child, false);
            resolved.addAll(this.resolve(child, childPath));
        }
        return resolved;
    }

    protected List<Element> resolve(Element element, String path) throws XmlConfigException {
        ArrayList<Element> resolved = new ArrayList<Element>();
        Attribute refAtt = element.attribute(XmlAttribute.ref.getXmlName());
        if (refAtt == null) {
            resolved.add(element);
        } else {
            this.resolveAttributeValue(refAtt, path);
            List<Element> refElCont = this.getReferredElementContent(refAtt.getValue(), path);
            for (Element el : refElCont) {
                Element newEl = el.createCopy();
                element.getParent().add(newEl);
                resolved.addAll(this.resolve(newEl, XmlUtil.getElementPath(el, true)));
            }
            if (!element.getParent().remove(element)) {
                throw new RuntimeException("internal error: should have been removed");
            }
        }
        for (Element elem : resolved) {
            Iterator itA = elem.attributeIterator();
            while (itA.hasNext()) {
                Attribute att = (Attribute)itA.next();
                this.resolveAttributeValue(att, path);
            }
            Iterator itE = elem.elementIterator();
            while (itE.hasNext()) {
                Element child = (Element)itE.next();
                this.resolve(child, String.valueOf(path) + "/" + XmlUtil.getElementPath(child, false));
            }
            if (elem.attribute(XmlAttribute.ref.getXmlName()) == null) continue;
            throw new RuntimeException("internal error: should have been resolved");
        }
        return resolved;
    }

    protected void resolveAttributeValue(Attribute att, String path) throws XmlConfigException {
        int start;
        int end = -1;
        String value = att.getValue();
        String resValue = "";
        while ((start = value.indexOf("${", end + 1)) != -1) {
            resValue = String.valueOf(resValue) + value.substring(end + 1, start);
            end = value.indexOf(125, start + 2);
            if (end == -1) {
                throw new XmlConfigException("closing } missing for attribute \"" + att.getName() + "=" + value + "\"", path);
            }
            resValue = String.valueOf(resValue) + this.getResolvedAttributeValue(att, path, value.substring(start + 2, end));
        }
        resValue = String.valueOf(resValue) + value.substring(end + 1, value.length());
        att.setValue(resValue);
    }

    protected String getResolvedAttributeValue(Attribute att, String path, String resolveKey) throws XmlConfigException {
        ResolveKey[] resolveKeyArray = ResolveKey.values();
        int n = resolveKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResolveKey key = resolveKeyArray[n2];
            if (key.matches(resolveKey)) {
                return key.resolve(att, path, resolveKey, this);
            }
            ++n2;
        }
        throw new XmlConfigException("cannot resolve '" + resolveKey + "' for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
    }

    protected List<Element> getReferredElementContent(String name, String path) throws XmlConfigException, MissingReferableException {
        Iterator it = this.getRootElement().elementIterator(XmlElement.referable.getXmlName());
        while (it.hasNext()) {
            Element ref = (Element)it.next();
            String refName = ref.attributeValue(XmlAttribute.name.getXmlName());
            if (!name.equals(refName)) continue;
            return ref.elements();
        }
        throw new MissingReferableException(name, "cannot find referred element '" + name + "'", path);
    }

    public void initLogManagerConfiguration() throws XmlConfigException {
        this.initLogManagerConfiguration(this.getDefaultConfigElement());
    }

    public void initLogManagerConfiguration(String configName) throws XmlConfigException {
        this.initLogManagerConfiguration(this.getConfigElement(configName));
    }

    public Properties getLoggingProperties() throws XmlConfigException {
        return this.getLoggingProperties(this.getDefaultConfigElement());
    }

    public Properties getLoggingProperties(String configName) throws XmlConfigException {
        return this.getLoggingProperties(this.getConfigElement(configName));
    }

    private Properties getLoggingProperties(Element config) throws XmlConfigException {
        Element logging = XmlUtil.getOptionalSingleChildElement(config, XmlElement.logging);
        List props = logging.elements(XmlElement.property.getXmlName());
        if (props != null) {
            Properties loggingProps = new Properties();
            for (Element property : props) {
                String path = XmlUtil.getElementPath(property, true);
                Attribute attRef = property.attribute(XmlAttribute.ref.getXmlName());
                Collection<Element> resolved = attRef != null ? this.resolve(property, path) : Collections.singleton(property);
                for (Element prop : resolved) {
                    Attribute attName = prop.attribute(XmlAttribute.name.getXmlName());
                    Attribute attValue = prop.attribute(XmlAttribute.value.getXmlName());
                    if (attName == null) {
                        throw new XmlConfigException("name attribute missing", path);
                    }
                    this.resolveAttributeValue(attName, path);
                    String name = XmlUtil.getRequiredAttributeValue(prop, XmlAttribute.name);
                    path = String.valueOf(path) + "[name=" + name + "]";
                    this.resolveAttributeValue(attValue, path);
                    String value = XmlUtil.getRequiredAttributeValue(prop, XmlAttribute.value);
                    loggingProps.put(name, value);
                }
            }
            return loggingProps;
        }
        return null;
    }

    private void initLogManagerConfiguration(Element config) throws XmlConfigException {
        Properties loggingProps = this.getLoggingProperties(config);
        if (loggingProps != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                String msg = "logging properties from xml-config: " + XmlUtil.getElementPath(config, true);
                loggingProps.store(buf, msg);
                ByteArrayInputStream in = new ByteArrayInputStream(buf.toByteArray());
                LogManager.getLogManager().readConfiguration(in);
                Logger.getLogger(this.getClass().getSimpleName()).info("initialized logging properties from xml-config");
            }
            catch (Exception ex) {
                throw new XmlConfigException("cannot set logging config, e=" + ex, (Node)config);
            }
        }
    }

    public void printUsage(PrintStream stream, String usageName) throws XmlConfigException {
        Element element = XmlUtil.getChildElementByAttributeValue(this.getRootElement(), XmlElement.usage, XmlAttribute.name, usageName, true);
        this.printUsageLines(stream, element.elementIterator());
    }

    private void printUsageLines(PrintStream stream, Iterator<Element> usageChildIt) throws XmlConfigException {
        while (usageChildIt.hasNext()) {
            Element el = usageChildIt.next();
            if (XmlUtil.isExpectedElementName(el, XmlElement.line)) {
                Element copy = el.createCopy();
                List<Element> res = this.resolve(copy, XmlUtil.getElementPath(copy, true));
                for (Element r : res) {
                    stream.println(r.attributeValue(XmlAttribute.value.getXmlName()));
                }
                continue;
            }
            if (!XmlUtil.isExpectedElementName(el, XmlElement.usage)) continue;
            Element parentCopy = el.getParent().createCopy();
            Element copy = el.createCopy();
            parentCopy.add(copy);
            List<Element> res = this.resolve(copy, XmlUtil.getElementPath(copy, true));
            for (Element r : res) {
                this.printUsageLines(stream, r.elementIterator());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResolveKey {
        work_dir,
        app_name,
        sys_prop,
        date,
        time,
        now,
        arg,
        opt,
        list;


        public String xmlName() {
            return this.name().replaceAll("_", "-");
        }

        public String resolve(Attribute att, String path, String value, XmlConfig config) throws XmlConfigException {
            switch (this) {
                case work_dir: {
                    return new File(".").getAbsolutePath();
                }
                case app_name: {
                    return config.mAppName;
                }
                case date: {
                    return DATE_FORMAT.format(config.mTimestamp);
                }
                case time: {
                    return TIME_FORMAT.format(config.mTimestamp);
                }
                case now: {
                    return TIMESTAMP_FORMAT.format(config.mTimestamp);
                }
                case sys_prop: {
                    String[] parts = value.split(":");
                    if (parts.length < 2) {
                        throw new XmlConfigException("property name missing for '" + this.xmlName() + "' for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    String propName = parts[1];
                    String propDef = parts.length < 3 ? "" : parts[2];
                    return System.getProperty(propName, propDef);
                }
                case arg: {
                    String defValue = null;
                    int defIndex = value.indexOf(58);
                    if (defIndex != -1) {
                        defValue = value.substring(defIndex + 1);
                        value = value.substring(0, defIndex);
                    }
                    int argLen = 0;
                    while (argLen < config.mArgs.length) {
                        if (config.mArgs[argLen].startsWith("-")) break;
                        ++argLen;
                    }
                    int index = Integer.parseInt(value) - 1;
                    if (index >= 0 && index < argLen) {
                        return config.mArgs[index];
                    }
                    if (defIndex != -1) {
                        return defValue;
                    }
                    throw new XmlArgException(index, "cannot resolve arg[" + (index + 1) + "] for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                }
                case opt: {
                    int sbStart;
                    String defValue = null;
                    int defIndex = value.indexOf(58);
                    if (defIndex != -1) {
                        defValue = value.substring(defIndex + 1);
                        value = value.substring(0, defIndex);
                    }
                    if ((sbStart = value.indexOf(91, 1)) == -1) {
                        throw new XmlConfigException("opening [ missing for option argument for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    int sbEnd = value.indexOf(93, sbStart + 1);
                    if (sbEnd == -1) {
                        throw new XmlConfigException("closing ] missing for option argument for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    String optName = value.substring(1, sbStart);
                    int optIndex = -1;
                    int i = 0;
                    while (i < config.mArgs.length) {
                        if (config.mArgs[i].equals("-" + optName)) {
                            optIndex = i;
                        }
                        ++i;
                    }
                    if (optIndex == -1) {
                        if (defIndex != -1) {
                            return defValue;
                        }
                        throw new XmlArgException(optName, "no option '" + optName + "' found in argument list for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    int optArgIndex = -1;
                    try {
                        optArgIndex = Integer.parseInt(value.substring(sbStart + 1, sbEnd));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (optArgIndex == -1) {
                        throw new XmlConfigException("cannot parse option argument index for option '" + optName + "' for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    int index = optIndex + optArgIndex;
                    int optLen = optIndex + 1;
                    while (optLen < config.mArgs.length) {
                        if (config.mArgs[optLen].startsWith("-")) break;
                        ++optLen;
                    }
                    if (index >= 0 && index < optLen) {
                        return config.mArgs[index];
                    }
                    if (defIndex != -1) {
                        return defValue;
                    }
                    throw new XmlArgException(optName, optArgIndex, "cannot resolve arg[" + (index + 1) + "] for option argument '" + optName + "[" + optArgIndex + "]'" + " for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                }
                case list: {
                    int sbStart;
                    String defValue = null;
                    int defIndex = value.indexOf(58);
                    if (defIndex != -1) {
                        defValue = value.substring(defIndex + 1);
                        value = value.substring(0, defIndex);
                    }
                    if ((sbStart = value.indexOf(91, 1)) == -1) {
                        throw new XmlConfigException("opening [ missing for list argument for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    int sbEnd = value.indexOf(93, sbStart + 1);
                    if (sbEnd == -1) {
                        throw new XmlConfigException("closing ] missing for list argument for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
                    }
                    String lstName = value.substring(1, sbStart);
                    String lstFill = value.substring(sbStart + 2, sbEnd - 1);
                    int lstStart = -1;
                    int i = 0;
                    while (i < config.mArgs.length) {
                        if (config.mArgs[i].equals("-" + lstName)) {
                            lstStart = i;
                        }
                        ++i;
                    }
                    int lstEnd = lstStart + 1;
                    if (lstStart != -1) {
                        int i2 = lstStart + 1;
                        while (i2 < config.mArgs.length) {
                            if (config.mArgs[i2].startsWith("-")) break;
                            ++lstEnd;
                            ++i2;
                        }
                    }
                    if (lstStart + 1 >= lstEnd) {
                        if (defIndex != -1) {
                            return defValue;
                        }
                        return "";
                    }
                    StringBuilder sb = new StringBuilder();
                    int i3 = lstStart + 1;
                    while (i3 < lstEnd) {
                        if (sb.length() > 0) {
                            sb.append(lstFill);
                        }
                        sb.append(config.mArgs[i3]);
                        ++i3;
                    }
                    return sb.toString();
                }
            }
            throw new XmlConfigException("cannot resolve '" + this.xmlName() + "' for attribute \"" + att.getName() + "=" + att.getValue() + "\"", path);
        }

        public boolean matches(String value) {
            if (this == arg || this == opt || this == list) {
                int ind = value.indexOf(58);
                if (ind != -1) {
                    value = value.substring(0, ind);
                }
                if (this == arg) {
                    return XmlConfig.isInt(value);
                }
                if (!value.startsWith("-")) {
                    return false;
                }
                int start = value.indexOf(91);
                int end = value.indexOf(93, start + 1);
                if (start < 0 || end < 0) {
                    return false;
                }
                value = value.substring(start + 1, end);
                if (this == opt) {
                    return XmlConfig.isInt(value);
                }
                if (this == list) {
                    return value.startsWith("*") && value.endsWith("*") && value.length() >= 2;
                }
                throw new InternalError();
            }
            String xmlName = this.xmlName();
            return this == sys_prop ? value.startsWith(xmlName) : value.equals(xmlName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttribute implements XmlNode
    {
        def,
        name,
        ref,
        value;


        @Override
        public String getXmlName() {
            return this == def ? "default" : this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElement implements XmlNode
    {
        application,
        referable,
        config_list,
        config,
        arg,
        logging,
        property,
        usage,
        line;


        @Override
        public String getXmlName() {
            return this.name().replace('_', '-');
        }
    }
}

