/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Element;
import org.dom4j.Node;

public class URLConfigParser {
    public static URL parseURL(Element urlElement) throws XmlConfigException {
        XmlUtil.checkExpectedElementName(urlElement, XmlElement.url);
        String urlName = urlElement.attributeValue(XmlAttribute.name.getXmlName());
        if (urlName == null) {
            throw new XmlConfigException(String.valueOf(XmlAttribute.name.getXmlName()) + " attribute missing for " + XmlElement.url.getXmlName() + " element", (Node)urlElement);
        }
        try {
            return new URL(urlName);
        }
        catch (MalformedURLException ex) {
            throw new XmlConfigException("cannot parse url '" + urlName + "', e=" + ex, (Node)urlElement, (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttribute implements XmlNode
    {
        name;


        @Override
        public String getXmlName() {
            return this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElement implements XmlNode
    {
        url;


        @Override
        public String getXmlName() {
            return this.name();
        }
    }
}

