/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstConfigParser {
    private static final Class[] METHOD_SIGNATURE = new Class[]{String.class};

    public static int parseIntConstant(Element constElement) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, Integer.class, false);
    }

    public static long parseLongConstant(Element constElement) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, Long.class, false);
    }

    public static float parseFloatConstant(Element constElement) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, Float.class, false).floatValue();
    }

    public static double parseDoubleConstant(Element constElement) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, Double.class, false);
    }

    public static boolean parseBooleanConstant(Element constElement) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, Boolean.class, false);
    }

    public static String parseStringConstant(Element constElement, boolean allowNull) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, String.class, allowNull);
    }

    public static <T> T parseConstant(Class<T> type, Element constElement, boolean allowNull) throws XmlConfigException {
        return ConstConfigParser.parseConstant(constElement, type, allowNull);
    }

    private static <T> T parseConstant(Element constElement, Class<T> expectedType, boolean allowNull) throws XmlConfigException {
        String sValue = constElement.attributeCount() == 1 ? XmlUtil.getRequiredAttributeValue(constElement, new Attribute(constElement.attribute(0))) : XmlUtil.getRequiredAttributeValue(constElement, XmlAttribute.value);
        if (allowNull && sValue.equals("null")) {
            return null;
        }
        try {
            return expectedType.getConstructor(METHOD_SIGNATURE).newInstance(sValue);
        }
        catch (Exception ex) {
            throw new XmlConfigException("cannot create " + expectedType.getSimpleName() + " const value '" + sValue + "', e=" + ex, (Node)constElement, (Throwable)ex);
        }
    }

    private static class Attribute
    implements XmlNode {
        private final org.dom4j.Attribute attribute;

        public Attribute(org.dom4j.Attribute attribute) {
            this.attribute = attribute;
        }

        public String getXmlName() {
            return this.attribute.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttribute implements XmlNode
    {
        type,
        value;


        @Override
        public String getXmlName() {
            return this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElement implements XmlNode
    {
        const_;


        @Override
        public String getXmlName() {
            return this == const_ ? "const" : this.name();
        }
    }
}

