/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.map;

import ch.javasoft.util.map.AbstractMutableMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiValueMap<K, V>
extends AbstractMutableMultiValueMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8019175851546861383L;
    private final Map<K, Collection<V>> map;

    public DefaultMultiValueMap() {
        this.map = this.createMap();
    }

    public DefaultMultiValueMap(MultiValueMap<? extends K, ? extends V> copy) {
        this.map = this.createMap();
        for (K key : copy.keySet()) {
            Collection<V> coll = this.createCollection(key);
            coll.addAll(copy.get(key));
            this.map.put(key, coll);
        }
    }

    public DefaultMultiValueMap(Map<K, Collection<V>> collectionMap) {
        this.map = collectionMap;
    }

    public static <K, V> DefaultMultiValueMap<K, V> createFromSingleValueMap(Map<? extends K, ? extends V> singleMap) {
        DefaultMultiValueMap<K, V> map = new DefaultMultiValueMap<K, V>();
        for (K key : singleMap.keySet()) {
            map.add(key, singleMap.get(key));
        }
        return map;
    }

    public static <K, V> DefaultMultiValueMap<K, V> createFromCollectionMap(Map<? extends K, ? extends Collection<? extends V>> collectionMap) {
        DefaultMultiValueMap<? extends K, V> map = new DefaultMultiValueMap<K, V>();
        map.addAllNested(collectionMap);
        return map;
    }

    @Override
    public boolean add(K key, V value) {
        Collection<V> coll = this.getOrCreateCollection(key);
        return coll.add(value);
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> values) {
        if (values.isEmpty()) {
            return false;
        }
        Collection<V> coll = this.getOrCreateCollection(key);
        return coll.addAll(values);
    }

    @Override
    public Collection<V> get(Object key) {
        Collection<V> coll = this.map.get(key);
        if (coll == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(coll);
    }

    @Override
    public V getFirst(Object key) {
        Collection<V> coll = this.map.get(key);
        return coll == null ? null : (V)coll.iterator().next();
    }

    @Override
    public int count(Object key) {
        Collection<V> coll = this.map.get(key);
        return coll == null ? 0 : coll.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean contains(Object key, V value) {
        Collection<V> coll = this.map.get(key);
        return coll == null ? false : coll.contains(value);
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public boolean remove(Object key, V value) {
        Collection<V> coll = this.map.get(key);
        if (coll == null) {
            return false;
        }
        if (coll.remove(value)) {
            if (coll.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean clear() {
        if (!this.map.isEmpty()) {
            this.map.clear();
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<? extends Iterable<V>> mItIt;
                    private Iterator<V> mIt;
                    {
                        this.mItIt = DefaultMultiValueMap.this.map.values().iterator();
                        this.mIt = this.nextIterator();
                    }

                    private Iterator<V> nextIterator() {
                        Iterable itbl;
                        Iterable iterable = itbl = this.mItIt.hasNext() ? this.mItIt.next() : null;
                        if (itbl != null) {
                            Iterator it = itbl.iterator();
                            return it.hasNext() ? it : this.nextIterator();
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.mIt == null) {
                            return false;
                        }
                        if (this.mIt.hasNext()) {
                            return true;
                        }
                        this.mIt = this.nextIterator();
                        return this.hasNext();
                    }

                    @Override
                    public V next() {
                        if (this.hasNext()) {
                            return this.mIt.next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        if (this.mIt == null) {
                            throw new NoSuchElementException();
                        }
                        this.mIt.remove();
                    }
                };
            }
        };
    }

    public DefaultMultiValueMap<K, V> clone() {
        try {
            Method meth = this.map.getClass().getMethod("clone", new Class[0]);
            Map clonedMap = (Map)meth.invoke(this.map, new Object[0]);
            return new DefaultMultiValueMap<K, V>(clonedMap);
        }
        catch (Exception e) {
            return new DefaultMultiValueMap<K, V>(this);
        }
    }

    protected Collection<V> getOrCreateCollection(K key) {
        Collection<V> coll = this.map.get(key);
        if (coll == null) {
            coll = this.createCollection(key);
            this.map.put(key, coll);
        }
        return coll;
    }

    protected Collection<V> createCollection(K key) {
        return new ArrayList(1);
    }

    protected Map<K, Collection<V>> createMap() {
        return new LinkedHashMap();
    }
}

