/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.genarr;

import ch.javasoft.util.genarr.AbstractGenericArray;
import ch.javasoft.util.genarr.CloneableTyped;
import ch.javasoft.util.genarr.GenericArray;
import ch.javasoft.util.genarr.GenericFixSizeArray;
import java.lang.reflect.Array;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDynamicArray<T>
extends AbstractGenericArray<T>
implements CloneableTyped<GenericDynamicArray<T>> {
    private static final int DEFAULT_CAPACITY = 7;
    private int mLength = 0;
    private T[] mArray;

    public static <T> GenericDynamicArray empty() {
        return new GenericDynamicArray<Object>(EMPTY);
    }

    public GenericDynamicArray() {
        this(7);
    }

    public GenericDynamicArray(int initialCapacity) {
        this.mArray = initialCapacity == 0 ? EMPTY : this.newArray(initialCapacity);
    }

    public GenericDynamicArray(T ... array) {
        this.mArray = array;
        this.mLength = array.length;
    }

    public GenericDynamicArray(GenericDynamicArray<? extends T> dynamicArray) {
        this.mArray = (Object[])dynamicArray.mArray.clone();
        this.mLength = dynamicArray.mLength;
    }

    public GenericDynamicArray(GenericArray<? extends T> genericArray) {
        this.mArray = this.newArray(genericArray.length());
        genericArray.toArray((TT[])this.mArray);
        this.mLength = genericArray.length();
    }

    public GenericDynamicArray(Iterable<? extends T> iterable) {
        this();
        this.addAll(iterable);
    }

    @Override
    public int length() {
        return this.mLength;
    }

    public int capacity() {
        return this.mArray.length;
    }

    public void trimToLength() {
        this.trim(false);
    }

    public void trimToNonNull() {
        this.trim(true);
    }

    private void trim(boolean nonNull) {
        int len = this.length();
        if (nonNull) {
            while (len - 1 >= 0 && this.mArray[len - 1] == null) {
                --len;
            }
        }
        if (len != this.mArray.length) {
            T[] newArr = this.newArray(len);
            System.arraycopy(this.mArray, 0, newArr, 0, len);
            this.mArray = newArr;
        }
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        int size = this.length();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(this.mArray, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public <TT> TT[] toArray(Class<TT> componentType) {
        int size = this.length();
        Object[] arr = (Object[])Array.newInstance(componentType, size);
        System.arraycopy(this.mArray, 0, arr, 0, size);
        return arr;
    }

    @Override
    public void copyFrom(GenericArray<? extends T> src, int srcPos, int dstPos, int length) {
        if (src instanceof GenericDynamicArray) {
            this.copyFrom((GenericDynamicArray)src, srcPos, dstPos, length);
        } else {
            src.copyTo(this, srcPos, dstPos, length);
        }
    }

    @Override
    public void copyTo(GenericArray<? super T> dst, int srcPos, int dstPos, int length) {
        if (dst instanceof GenericDynamicArray) {
            this.copyTo((GenericDynamicArray)dst, srcPos, dstPos, length);
        } else {
            dst.set(dstPos, this.mArray, srcPos, length);
        }
    }

    @Override
    public void copyFrom(GenericDynamicArray<? extends T> src, int srcPos, int dstPos, int length) {
        this.set(dstPos, src.mArray, srcPos, length);
    }

    @Override
    public void copyTo(GenericDynamicArray<? super T> dst, int srcPos, int dstPos, int length) {
        dst.set(dstPos, this.mArray, srcPos, length);
    }

    @Override
    public void set(int offset, T[] arr, int srcOffset, int length) throws IndexOutOfBoundsException {
        if (offset < 0) {
            throw new IllegalArgumentException("illegal negative offset: " + offset);
        }
        if (srcOffset < 0) {
            throw new IllegalArgumentException("illegal negative src offset: " + srcOffset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("illegal negative length: " + length);
        }
        if (srcOffset + length > arr.length) {
            throw new IndexOutOfBoundsException("not enough source entries: " + srcOffset + " + " + length + " > " + arr.length);
        }
        this.ensureCapacity(offset + length);
        System.arraycopy(arr, srcOffset, this.mArray, offset, length);
        this.mLength = Math.max(offset + length, this.mLength);
    }

    @Override
    public void removeLast() {
        this.removeLast(1);
    }

    public void removeLast(int len) {
        if (this.mLength - len < 0) {
            throw new IndexOutOfBoundsException("cannot remove last " + len + " entries, there are only " + this.mLength);
        }
        this.mLength -= len;
        int ii = 0;
        while (ii < len) {
            this.mArray[this.mLength + ii] = null;
            ++ii;
        }
    }

    @Override
    public T remove(int index) {
        if (index == this.length() - 1) {
            T last = this.last();
            this.removeLast();
            return last;
        }
        return super.remove(index);
    }

    @Override
    public void clear() {
        this.mArray = this.newArray(Math.max(this.mArray.length / 2, 7));
        this.mLength = 0;
    }

    @Override
    public T get(int index) throws IndexOutOfBoundsException {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + index + " not in[0, " + (this.mLength - 1) + "]");
        }
        return this.mArray[index];
    }

    @Override
    public T first() throws IndexOutOfBoundsException {
        if (this.mLength > 0) {
            return this.mArray[0];
        }
        throw new IndexOutOfBoundsException("empty array");
    }

    @Override
    public T last() throws IndexOutOfBoundsException {
        if (this.mLength > 0) {
            return this.mArray[this.mLength - 1];
        }
        throw new IndexOutOfBoundsException("empty array");
    }

    @Override
    public T set(int index, T element) {
        T old;
        if (index < this.mArray.length) {
            old = this.mArray[index];
        } else {
            if (element == null) {
                return null;
            }
            old = null;
            this.ensureCapacity(index + 1);
        }
        this.mArray[index] = element;
        if (index >= this.mLength) {
            this.mLength = index + 1;
        }
        return old;
    }

    @Override
    public void set(int offset, Iterable<? extends T> it) {
        if (it instanceof GenericArray) {
            this.copyFrom((GenericArray)it, 0, offset, ((GenericArray)it).length());
        } else {
            for (T el : it) {
                this.set(offset++, el);
            }
            this.mLength = Math.max(offset, this.mLength);
        }
    }

    protected void ensureCapacity(int capacity) {
        if (capacity >= this.mArray.length) {
            int newSize = Math.max(this.mArray.length * 2, capacity);
            T[] newArr = this.newArray(newSize);
            System.arraycopy(this.mArray, 0, newArr, 0, this.mLength);
            this.mArray = newArr;
        }
    }

    @Override
    public void swap(int indexA, int indexB) {
        if (Math.min(indexA, indexB) < 0 || Math.max(indexA, indexB) >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexA + " or " + indexB + " out of bounds [0, " + (this.mLength - 1) + "]");
        }
        T tmp = this.mArray[indexA];
        this.mArray[indexA] = this.mArray[indexB];
        this.mArray[indexB] = tmp;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("[" + fromIndex + ", " + toIndex + "] out of bounds [0, " + this.length() + "] or fromIndex > toIndex");
        }
        T[] arr = this.newArray(toIndex - fromIndex);
        System.arraycopy(this.mArray, fromIndex, arr, 0, toIndex - fromIndex);
        return new GenericFixSizeArray(arr);
    }

    @Override
    public GenericDynamicArray<T> clone() {
        GenericDynamicArray<T> clone = new GenericDynamicArray<T>(0);
        clone.mArray = (Object[])this.mArray.clone();
        clone.mLength = this.mLength;
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int ii = 0;
        while (ii < this.mLength) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mArray[ii]);
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }
}

