/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.IntegerOperations;
import ch.javasoft.smx.iface.BigIntegerMatrix;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.LongMatrix;
import ch.javasoft.smx.iface.LongRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultLongMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.matrix.IntMatrixOperations;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntMatrix
implements IntMatrix {
    private static final String NL = System.getProperty("line.separator");
    private int mColumnCount;
    private int[] mValues;

    public DefaultIntMatrix(int rowCount, int colCount) {
        this(new int[rowCount * colCount], rowCount, colCount);
    }

    public DefaultIntMatrix(int[] values, int rowCount, int columnCount) {
        if (rowCount == -1) {
            rowCount = values.length / columnCount;
        }
        if (columnCount == -1) {
            columnCount = values.length / rowCount;
        }
        if (rowCount < 0 || columnCount < 0 || rowCount * columnCount != values.length) {
            throw new IllegalArgumentException("rowCount (" + rowCount + ") * columnCount (" + columnCount + ") != number of values (" + values.length + ")");
        }
        this.mValues = values;
        this.mColumnCount = columnCount;
    }

    public DefaultIntMatrix(int[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        int[] vals = new int[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2] : 0;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultIntMatrix(Integer[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        int[] vals = new int[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2] : 0;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultIntMatrix(ReadableIntMatrix mx) {
        this.mValues = mx.toIntArray();
        this.mColumnCount = mx.getColumnCount();
    }

    public static DefaultIntMatrix diag(int[] values) {
        int len = values.length;
        DefaultIntMatrix mx = new DefaultIntMatrix(new int[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, values[ii]);
            ++ii;
        }
        return mx;
    }

    public static DefaultIntMatrix diag(int value, int len) {
        DefaultIntMatrix mx = new DefaultIntMatrix(new int[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, value);
            ++ii;
        }
        return mx;
    }

    public static DefaultIntMatrix identity(int len) {
        return DefaultIntMatrix.diag(1, len);
    }

    public IntegerOperations getNumberOperations() {
        return IntegerOperations.instance();
    }

    @Override
    public MatrixOperations<Integer> getMatrixOperations() {
        return IntMatrixOperations.instance();
    }

    @Override
    public int getIntValueAt(int row, int col) {
        return this.mValues[row * this.mColumnCount + col];
    }

    @Override
    public long getLongValueAt(int row, int col) {
        return this.getIntValueAt(row, col);
    }

    @Override
    public int getSignumAt(int row, int col) {
        int val = this.getIntValueAt(row, col);
        return val == 0 ? 0 : ((double)val < 0.0 ? -1 : 1);
    }

    @Override
    public int getIntNumeratorAt(int row, int col) {
        return this.getIntValueAt(row, col);
    }

    @Override
    public int getIntDenominatorAt(int row, int col) {
        return 1;
    }

    @Override
    public long getLongNumeratorAt(int row, int col) {
        return this.getIntNumeratorAt(row, col);
    }

    @Override
    public long getLongDenominatorAt(int row, int col) {
        return 1L;
    }

    @Override
    public BigInteger getBigIntegerNumeratorAt(int row, int col) {
        return BigInteger.valueOf(this.getIntNumeratorAt(row, col));
    }

    @Override
    public BigInteger getBigIntegerDenominatorAt(int row, int col) {
        return BigInteger.ONE;
    }

    @Override
    public double getDoubleValueAt(int row, int col) {
        return this.getIntValueAt(row, col);
    }

    @Override
    public BigFraction getBigFractionValueAt(int row, int col) {
        return new BigFraction(this.getBigIntegerNumeratorAt(row, col), this.getBigIntegerDenominatorAt(row, col));
    }

    @Override
    public int getRowCount() {
        return this.mColumnCount > 0 ? this.mValues.length / this.mColumnCount : 0;
    }

    @Override
    public int getColumnCount() {
        return this.mColumnCount;
    }

    @Override
    public void setValueAt(int row, int col, int value) {
        this.mValues[row * this.mColumnCount + col] = value;
    }

    @Override
    public void setValueAt(int row, int col, Integer value) {
        this.setValueAt(row, col, (int)value);
    }

    @Override
    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        int[] tmpRow = new int[this.mColumnCount];
        System.arraycopy(this.mValues, rowA * this.mColumnCount, tmpRow, 0, this.mColumnCount);
        System.arraycopy(this.mValues, rowB * this.mColumnCount, this.mValues, rowA * this.mColumnCount, this.mColumnCount);
        System.arraycopy(tmpRow, 0, this.mValues, rowB * this.mColumnCount, this.mColumnCount);
    }

    @Override
    public void swapColumns(int colA, int colB) {
        if (colA != colB) {
            int rows = this.getRowCount();
            int row = 0;
            while (row < rows) {
                int tmp = this.getIntValueAt(row, colA);
                this.setValueAt(row, colA, this.getIntValueAt(row, colB));
                this.setValueAt(row, colB, tmp);
                ++row;
            }
        }
    }

    @Override
    public Integer getNumberValueAt(int row, int col) {
        return this.getIntValueAt(row, col);
    }

    @Override
    public int[] toIntArray() {
        return (int[])this.mValues.clone();
    }

    @Override
    public void toArray(int[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        System.arraycopy(this.mValues, 0, array, 0, array.length);
    }

    @Override
    public double[] toDoubleArray() {
        double[] array = new double[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public long[] toLongArray() {
        long[] array = new long[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public void toArray(double[] array) {
        AbstractDoubleMatrix.toArray(this, array);
    }

    @Override
    public void toArray(long[] array) {
        DefaultLongMatrix.toArray(this, array);
    }

    @Override
    public double[] getDoubleColumn(int col) {
        return AbstractDoubleMatrix.getDoubleColumn(this, col);
    }

    @Override
    public double[][] getDoubleColumns() {
        return AbstractDoubleMatrix.getDoubleColumns(this);
    }

    @Override
    public double[] getDoubleRow(int row) {
        return AbstractDoubleMatrix.getDoubleRow(this, row);
    }

    @Override
    public double[][] getDoubleRows() {
        return AbstractDoubleMatrix.getDoubleRows(this);
    }

    @Override
    public int[] getIntColumn(int col) {
        return DefaultIntMatrix.getIntColumn(this, col);
    }

    public static int[] getIntColumn(ReadableIntMatrix mx, int col) {
        int rows = mx.getRowCount();
        int[] res = new int[rows];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getIntValueAt(row, col);
            ++row;
        }
        return res;
    }

    @Override
    public long[] getLongColumn(int col) {
        return DefaultLongMatrix.getLongColumn(this, col);
    }

    @Override
    public int[] getIntRow(int row) {
        return DefaultIntMatrix.getIntRow(this, row);
    }

    public static int[] getIntRow(ReadableIntMatrix mx, int row) {
        int cols = mx.getColumnCount();
        int[] res = new int[cols];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getIntValueAt(row, col);
            ++col;
        }
        return res;
    }

    @Override
    public long[] getLongRow(int row) {
        return DefaultLongMatrix.getLongRow(this, row);
    }

    @Override
    public int[][] getIntColumns() {
        return DefaultIntMatrix.getIntColumns(this);
    }

    public static int[][] getIntColumns(ReadableIntMatrix mx) {
        int cols = mx.getColumnCount();
        int[][] res = new int[cols][];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getIntColumn(col);
            ++col;
        }
        return res;
    }

    @Override
    public long[][] getLongColumns() {
        return DefaultLongMatrix.getLongColumns(this);
    }

    public Integer[][] getNumberRows() {
        return DefaultIntMatrix.getNumberRows(this);
    }

    public static Integer[][] getNumberRows(ReadableIntMatrix<Integer> mx) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        Integer[][] data = new Integer[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                data[row][col] = mx.getIntValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return data;
    }

    @Override
    public int[][] getIntRows() {
        return DefaultIntMatrix.getIntRows(this);
    }

    public static int[][] getIntRows(ReadableIntMatrix mx) {
        int rows = mx.getRowCount();
        int[][] res = new int[rows][];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getIntRow(row);
            ++row;
        }
        return res;
    }

    @Override
    public long[][] getLongRows() {
        return DefaultLongMatrix.getLongRows(this);
    }

    @Override
    public String toString() {
        return DefaultIntMatrix.toString(this);
    }

    @Override
    public void writeTo(Writer writer) {
        DefaultIntMatrix.writeTo(writer, (ReadableIntMatrix)this);
    }

    @Override
    public void writeTo(OutputStream out) {
        DefaultIntMatrix.writeTo(out, (ReadableIntMatrix)this);
    }

    public static String toString(ReadableIntMatrix mx) {
        return DefaultIntMatrix.toString(mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(Writer writer, ReadableIntMatrix mx) {
        DefaultIntMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(OutputStream out, ReadableIntMatrix mx) {
        DefaultIntMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    @Override
    public String toMultilineString() {
        return DefaultIntMatrix.toMultilineString(this);
    }

    @Override
    public void writeToMultiline(Writer writer) {
        DefaultIntMatrix.writeToMultiline(writer, (ReadableIntMatrix)this);
    }

    @Override
    public void writeToMultiline(OutputStream out) {
        DefaultIntMatrix.writeToMultiline(out, (ReadableIntMatrix)this);
    }

    public static String toMultilineString(ReadableIntMatrix mx) {
        return DefaultIntMatrix.toString(mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(Writer writer, ReadableIntMatrix mx) {
        DefaultIntMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(OutputStream out, ReadableIntMatrix mx) {
        DefaultIntMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    protected static String toString(ReadableIntMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        StringWriter sw = new StringWriter();
        DefaultIntMatrix.writeTo(new PrintWriter(sw), mx, prefix, postfix, rowPrefix, rowPostfix, rowSeparator, colPrefix, colPostfix, colSeparator);
        return sw.toString();
    }

    protected static void writeTo(PrintWriter writer, ReadableIntMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        writer.print(prefix);
        int row = 0;
        while (row < rows) {
            if (row > 0) {
                writer.print(rowSeparator);
            }
            writer.print(rowPrefix);
            int col = 0;
            while (col < cols) {
                if (col > 0) {
                    writer.print(colSeparator);
                }
                writer.print(colPrefix);
                writer.print(mx.getIntValueAt(row, col));
                writer.print(colPostfix);
                ++col;
            }
            writer.print(rowPostfix);
            ++row;
        }
        writer.print(postfix);
        writer.flush();
    }

    @Override
    public DefaultIntMatrix clone() {
        return new DefaultIntMatrix((int[])this.mValues.clone(), -1, this.mColumnCount);
    }

    @Override
    public DefaultIntMatrix newInstance(int rows, int cols) {
        return new DefaultIntMatrix(rows, cols);
    }

    @Override
    public DefaultIntMatrix newInstance(Integer[][] data, boolean rowsInDim1) {
        int cols;
        int rows;
        if (rowsInDim1) {
            rows = data.length;
            cols = rows == 0 ? 0 : data[0].length;
        } else {
            cols = data.length;
            rows = cols == 0 ? 0 : data[0].length;
        }
        int[] values = new int[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Integer val = rowsInDim1 ? data[row][col] : data[col][row];
                values[row * cols + col] = val;
                ++col;
            }
            ++row;
        }
        return new DefaultIntMatrix(values, rows, cols);
    }

    @Override
    public IntMatrix toIntMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public IntMatrix toWritableMatrix(boolean enforceNewInstance) {
        return this.toIntMatrix(enforceNewInstance);
    }

    public IntMatrix toReadableMatrix(boolean enforceNewInstance) {
        return this.toIntMatrix(enforceNewInstance);
    }

    @Override
    public LongMatrix toLongMatrix(boolean enforceNewInstance) {
        return new DefaultLongMatrix(this);
    }

    @Override
    public IntRationalMatrix toIntRationalMatrix(boolean enforceNewInstance) {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int[] ones = new int[rows * cols];
        Arrays.fill(ones, 1);
        return new DefaultIntRationalMatrix((int[])this.mValues.clone(), ones, rows, cols);
    }

    @Override
    public LongRationalMatrix toLongRationalMatrix(boolean enforceNewInstance) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public BigIntegerRationalMatrix toBigIntegerRationalMatrix(boolean enforceNewInstance) {
        return new DefaultBigIntegerRationalMatrix(this.toLongArray(), this.getRowCount(), this.getColumnCount());
    }

    @Override
    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return new DefaultDoubleMatrix(this.toDoubleArray(), this.getRowCount(), this.getColumnCount());
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcFactor, int dstRow, int dstFactor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.setValueAt(dstRow, col, dstFactor * this.getIntValueAt(dstRow, col) + srcFactor * this.getIntValueAt(srcRow, col));
            ++col;
        }
    }

    @Override
    public void add(int row, int col, int value) {
        this.setValueAt(row, col, this.getIntValueAt(row, col) + value);
    }

    @Override
    public void multiply(int row, int col, int factor) {
        this.setValueAt(row, col, factor * this.getIntValueAt(row, col));
    }

    @Override
    public void multiplyRow(int row, int factor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.multiply(row, col, factor);
            ++col;
        }
    }

    public int hashCode() {
        int value = this.mColumnCount;
        int ii = 0;
        while (ii < this.mValues.length) {
            value ^= this.mValues[ii];
            ++ii;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IntMatrix) {
            IntMatrix other = (IntMatrix)obj;
            int rows = this.getRowCount();
            if (rows != other.getRowCount()) {
                return false;
            }
            int cols = this.getColumnCount();
            if (cols != other.getColumnCount()) {
                return false;
            }
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    if (this.getIntValueAt(row, col) != other.getIntValueAt(row, col)) {
                        return false;
                    }
                    ++col;
                }
                ++row;
            }
            return true;
        }
        return false;
    }

    @Override
    public IntMatrix subIntMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        DefaultIntMatrix res = new DefaultIntMatrix(rowEnd - rowStart, colEnd - colStart);
        int row = 0;
        while (row < res.getRowCount()) {
            int col = 0;
            while (col < res.getColumnCount()) {
                res.setValueAt(row, col, this.getIntValueAt(rowStart + row, colStart + col));
                ++col;
            }
            ++row;
        }
        return res;
    }

    @Override
    public ReadableLongMatrix subLongMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntMatrix(rowStart, rowEnd, colStart, colEnd).toLongMatrix(false);
    }

    @Override
    public IntRationalMatrix subIntRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntMatrix(rowStart, rowEnd, colStart, colEnd).toIntRationalMatrix(false);
    }

    @Override
    public LongRationalMatrix subLongRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntMatrix(rowStart, rowEnd, colStart, colEnd).toLongRationalMatrix(false);
    }

    @Override
    public ReadableBigIntegerMatrix subBigIntegerMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntMatrix(rowStart, rowEnd, colStart, colEnd).toBigIntegerMatrix(false);
    }

    @Override
    public BigIntegerRationalMatrix subBigIntegerRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntMatrix(rowStart, rowEnd, colStart, colEnd).toBigIntegerRationalMatrix(false);
    }

    @Override
    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntMatrix(rowStart, rowEnd, colStart, colEnd).toDoubleMatrix(false);
    }

    @Override
    public DefaultIntMatrix transpose() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        DefaultIntMatrix tr = new DefaultIntMatrix(cols, rows);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                tr.setValueAt(col, row, this.getIntValueAt(row, col));
                ++col;
            }
            ++row;
        }
        return tr;
    }

    @Override
    public BigInteger getBigIntegerValueAt(int row, int col) {
        return BigInteger.valueOf(this.getIntValueAt(row, col));
    }

    @Override
    public void toArray(BigInteger[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        int i = 0;
        while (i < array.length) {
            array[i] = BigInteger.valueOf(this.mValues[i]);
            ++i;
        }
    }

    @Override
    public BigInteger[] toBigIntegerArray() {
        BigInteger[] array = new BigInteger[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public BigIntegerMatrix toBigIntegerMatrix(boolean enforceNewInstance) {
        return new DefaultBigIntegerMatrix(this);
    }

    @Override
    public BigInteger[] getBigIntegerColumn(int col) {
        BigInteger[] theCol = new BigInteger[this.getRowCount()];
        int row = 0;
        while (row < theCol.length) {
            theCol[row] = this.getBigIntegerValueAt(row, col);
            ++row;
        }
        return theCol;
    }

    @Override
    public BigInteger[][] getBigIntegerColumns() {
        BigInteger[][] cols = new BigInteger[this.getColumnCount()][];
        int col = 0;
        while (col < cols.length) {
            cols[col] = this.getBigIntegerColumn(col);
            ++col;
        }
        return cols;
    }

    @Override
    public BigInteger[] getBigIntegerRow(int row) {
        BigInteger[] theRow = new BigInteger[this.getColumnCount()];
        int col = 0;
        while (col < theRow.length) {
            theRow[col] = this.getBigIntegerValueAt(row, col);
            ++col;
        }
        return theRow;
    }

    @Override
    public BigInteger[][] getBigIntegerRows() {
        BigInteger[][] rows = new BigInteger[this.getRowCount()][];
        int row = 0;
        while (row < rows.length) {
            rows[row] = this.getBigIntegerRow(row);
            ++row;
        }
        return rows;
    }

    @Override
    public void negate(int row, int col) {
        this.setValueAt(row, col, -this.getIntValueAt(row, col));
    }
}

