/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.DoubleVector;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;

public class DefaultDoubleVector
extends AbstractDoubleMatrix
implements DoubleVector {
    private final boolean mIsColumnVector;
    private final double[] mValues;

    public DefaultDoubleVector(int size, boolean columnVector) {
        this(new double[size], columnVector);
    }

    public DefaultDoubleVector(double[] values, boolean columnVector) {
        this.mValues = values;
        this.mIsColumnVector = columnVector;
    }

    public DefaultDoubleVector(Double[] values, boolean columnVector) {
        this(values.length, columnVector);
        int i = 0;
        while (i < values.length) {
            this.mValues[i] = values[i];
            ++i;
        }
    }

    public boolean isColumnVector() {
        return this.mIsColumnVector;
    }

    public boolean isRowVector() {
        return !this.mIsColumnVector;
    }

    public DefaultDoubleVector clone() {
        return new DefaultDoubleVector((double[])this.mValues.clone(), this.mIsColumnVector);
    }

    public DefaultDoubleVector toReadableVector(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public DefaultDoubleVector toWritableVector(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public DefaultDoubleVector toReadableMatrix(boolean enforceNewInstance) {
        return this.toReadableVector(enforceNewInstance);
    }

    public DefaultDoubleVector toWritableMatrix(boolean enforceNewInstance) {
        return this.toWritableVector(enforceNewInstance);
    }

    public DoubleMatrix newInstance(int rows, int cols) {
        if (rows == 0 || cols == 0) {
            return new DefaultDoubleVector(0, this.mIsColumnVector);
        }
        if (cols == 1) {
            return new DefaultDoubleVector(rows, true);
        }
        if (rows == 1) {
            return new DefaultDoubleVector(cols, false);
        }
        return new DefaultDoubleMatrix(rows, cols);
    }

    public DoubleMatrix newInstance(Double[][] data, boolean rowsInDim1) {
        int cols;
        int rows;
        if (rowsInDim1) {
            rows = data.length;
            cols = rows == 0 ? 0 : data[0].length;
        } else {
            cols = data.length;
            rows = cols == 0 ? 0 : data[0].length;
        }
        double[] values = new double[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Double val = rowsInDim1 ? data[row][col] : data[col][row];
                values[row * cols + col] = val;
                ++col;
            }
            ++row;
        }
        if (rows == 0 || cols == 0) {
            return new DefaultDoubleVector(0, this.mIsColumnVector);
        }
        if (cols == 1) {
            return new DefaultDoubleVector(values, true);
        }
        if (rows == 1) {
            return new DefaultDoubleVector(values, false);
        }
        return new DefaultDoubleMatrix(values, rows, cols);
    }

    public DefaultDoubleVector transpose() {
        return new DefaultDoubleVector((double[])this.mValues.clone(), !this.mIsColumnVector);
    }

    public double getDoubleValueAt(int index) {
        return this.mValues[index];
    }

    public int getSize() {
        return this.mValues.length;
    }

    protected int getIndexForMatrixAccess(int row, int col) {
        if (this.isRowVector()) {
            if (row != 0) {
                throw new IndexOutOfBoundsException("row vector, row index must be 0, but was " + row);
            }
            return col;
        }
        if (col != 0) {
            throw new IndexOutOfBoundsException("column vector, column index must be 0, but was " + col);
        }
        return row;
    }

    public double getDoubleValueAt(int row, int col) {
        return this.getDoubleValueAt(this.getIndexForMatrixAccess(row, col));
    }

    public Double getNumberValueAt(int index) {
        return this.getDoubleValueAt(index);
    }

    public void setValueAt(int index, Double value) {
        this.setValueAt(index, (double)value);
    }

    public int getColumnCount() {
        return this.isRowVector() ? this.mValues.length : 1;
    }

    public int getRowCount() {
        return this.isColumnVector() ? this.mValues.length : 1;
    }

    public void setValueAt(int index, double value) {
        this.mValues[index] = value;
    }

    public void setValueAt(int row, int col, double value) {
        this.setValueAt(this.getIndexForMatrixAccess(row, col), value);
    }

    public void swapValues(int indexA, int indexB) {
        double tmp = this.mValues[indexA];
        this.mValues[indexA] = this.mValues[indexB];
        this.mValues[indexB] = tmp;
    }

    public void swapRows(int rowA, int rowB) {
        if (this.isRowVector()) {
            if (rowA != 0) {
                throw new IndexOutOfBoundsException("row vector, row index must be 0, but was " + rowA);
            }
            if (rowB != 0) {
                throw new IndexOutOfBoundsException("row vector, row index must be 0, but was " + rowB);
            }
            return;
        }
        this.swapValues(rowA, rowB);
    }

    public void swapColumns(int colA, int colB) {
        if (this.isColumnVector()) {
            if (colA != 0) {
                throw new IndexOutOfBoundsException("column vector, column index must be 0, but was " + colA);
            }
            if (colB != 0) {
                throw new IndexOutOfBoundsException("column vector, column index must be 0, but was " + colB);
            }
            return;
        }
        this.swapValues(colA, colB);
    }
}

