/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.callback;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.polco.EqualityPolyhedralCone;
import ch.javasoft.polco.InequalityPolyhedralCone;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipCallback<Num extends Number, Arr>
implements ExtremeRayCallback<Num, Arr> {
    private final ZipOutputStream zipStream;
    private PrintStream rayPrinter;

    public ZipCallback(OutputStream out) {
        this.zipStream = new ZipOutputStream(out);
    }

    @Override
    public boolean initialize(ExtremeRayEvent<Num, Arr> event) throws IOException {
        PolyhedralCone<Num, Arr> cone = event.getPolyhedralCone();
        NumberArrayOperations naops = cone.getLinAlgOperations().getNumberArrayOperations();
        this.openEntry("description");
        PrintStream print = new PrintStream(this.zipStream);
        print.println(cone.toString());
        print.println("P = { x = R' c , R:" + event.getRayCount() + "x" + cone.getDimensions() + "   for some c >= 0 }");
        print.flush();
        this.closeEntry();
        if (!(cone instanceof InequalityPolyhedralCone)) {
            this.openEntry("A");
            this.writeMatrix(naops, cone.getA());
            this.closeEntry();
        }
        if (!(cone instanceof EqualityPolyhedralCone)) {
            this.openEntry("B");
            this.writeMatrix(naops, cone.getB());
            this.closeEntry();
        }
        this.openEntry("R");
        this.rayPrinter = new PrintStream(this.zipStream);
        return true;
    }

    @Override
    public void outputExtremeRay(ExtremeRayEvent<Num, Arr> event, long index, Arr extremeRay) throws IOException {
        NumberArrayOperations naops = event.getPolyhedralCone().getLinAlgOperations().getNumberArrayOperations();
        int len = naops.getArrayOperations().getLength(extremeRay);
        this.writeVector(this.rayPrinter, naops, extremeRay, len);
    }

    @Override
    public void terminate(ExtremeRayEvent<Num, Arr> event) throws IOException {
        this.rayPrinter.flush();
        this.closeEntry();
        this.zipStream.close();
        this.rayPrinter = null;
    }

    private void writeMatrix(NumberArrayOperations<Num, Arr> naops, Arr[] matrix) throws IOException {
        int rows = naops.getArrayOperations().getRowCount(matrix);
        int cols = naops.getArrayOperations().getColumnCount(matrix);
        PrintStream print = new PrintStream(this.zipStream);
        int r = 0;
        while (r < rows) {
            this.writeVector(print, naops, matrix[r], cols);
            ++r;
        }
        print.flush();
    }

    private void writeVector(PrintStream print, NumberArrayOperations<Num, Arr> naops, Arr vector, int length) throws IOException {
        int i = 0;
        while (i < length) {
            if (i > 0) {
                print.print('\t');
            }
            print.print(naops.get(vector, i));
            ++i;
        }
        print.println();
    }

    private void openEntry(String name) throws IOException {
        this.zipStream.putNextEntry(new ZipEntry(name));
    }

    private void closeEntry() throws IOException {
        this.zipStream.closeEntry();
    }
}

