/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco;

import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.TestHelper;
import ch.javasoft.polco.callback.NullCallback;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.metabolic.EfmExtremeRayEnumerator;
import ch.javasoft.polco.parse.MpsParser;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import junit.framework.TestCase;

public class MpsTest
extends TestCase {
    private static final File FOLDER_INE = new File("../mps-data");
    private static final ch.javasoft.metabolic.efm.config.Arithmetic arithmetic;

    static {
        CompressionMethod[] compression = CompressionMethod.NONE;
        arithmetic = ch.javasoft.metabolic.efm.config.Arithmetic.rawint;
        if (Config.initForJUnitTest("pattern-tree-minzero", "FewestNegPos", compression, false, arithmetic, Norm.min)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testStein9() throws Exception {
        this.internalTestPolymake("stein9.mps");
    }

    protected void internalTestPolymake(String fileName) throws Exception {
        final File file = new File(FOLDER_INE, fileName);
        TestHelper.getPolcoArithmetic(arithmetic).callback(new ArithmeticCallback<Void>(){

            @Override
            public <N extends Number, A> Void callback(Arithmetic<N, A> arithmetic) throws Exception {
                Zero zero = Config.getConfig().zero();
                PolyhedralCone<N, A> cone = new MpsParser().parse(null, arithmetic, zero, new FileInputStream(file));
                EfmExtremeRayEnumerator xray = new EfmExtremeRayEnumerator(zero, true);
                ExtremeRayCallback callback = NullCallback.instance();
                xray.enumerateExtremeRays(cone, callback, arithmetic.getLinAlgOperations(zero));
                return null;
            }
        });
    }
}

