/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.util;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.BigMath;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.numeric.Zero;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxNormalizer {
    public static void normalize(MetabolicNetwork net, double[] values, Zero zero, boolean normalizeMax) {
        FluxNormalizer.normalize(net, values, normalizeMax, zero, true);
    }

    public static void normalizeMax(MetabolicNetwork net, double[] values, Zero zero) {
        FluxNormalizer.normalize(net, values, true, zero, true);
    }

    public static void normalizeMin(MetabolicNetwork net, double[] values, Zero zero) {
        FluxNormalizer.normalize(net, values, false, zero, true);
    }

    public static void normalizeNorm2(MetabolicNetwork net, double[] values, Zero zero) {
        double sumSquared = 0.0;
        int i = 0;
        while (i < values.length) {
            sumSquared += values[i] * values[i];
            ++i;
        }
        double div = Math.sqrt(sumSquared);
        int i2 = 0;
        while (i2 < values.length) {
            int n = i2++;
            values[n] = values[n] / div;
        }
    }

    public static void normalizeSquared(MetabolicNetwork net, double[] values, Zero zero) {
        double sumSquared = 0.0;
        int i = 0;
        while (i < values.length) {
            double sgn = Math.signum(values[i]);
            int n = i;
            values[n] = values[n] * values[i];
            sumSquared += values[i];
            int n2 = i++;
            values[n2] = values[n2] * sgn;
        }
        i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] / sumSquared;
        }
    }

    private static void normalize(MetabolicNetwork net, double[] values, boolean max, Zero zero, boolean normalizeOnlyIntegerRatios) {
        ArrayIterable<? extends Reaction> reacts;
        ArrayIterable<? extends Reaction> arrayIterable = reacts = net == null ? null : net.getReactions();
        if (reacts != null && values.length != reacts.length()) {
            throw new IllegalArgumentException("reaction count != value count: " + reacts.length() + " != " + values.length);
        }
        double refValue = max ? 0.0 : Double.MAX_VALUE;
        double iRefValue = max ? 0.0 : Double.MAX_VALUE;
        int ii = 0;
        while (ii < values.length) {
            double absValue = Math.abs(values[ii]);
            if (zero.isNonZero(absValue)) {
                double d = refValue = max ? Math.max(refValue, absValue) : Math.min(refValue, absValue);
                if (!normalizeOnlyIntegerRatios || reacts == null || reacts.get(ii).hasIntegerRatios()) {
                    iRefValue = max ? Math.max(iRefValue, absValue) : Math.min(iRefValue, absValue);
                }
            }
            ++ii;
        }
        if (iRefValue != 0.0 && iRefValue != Double.MAX_VALUE) {
            refValue = iRefValue;
        }
        if (refValue == 0.0 || refValue == Double.MAX_VALUE) {
            return;
        }
        ii = 0;
        while (ii < values.length) {
            int n = ii++;
            values[n] = values[n] / refValue;
        }
    }

    public static <N extends Number> void normalizeMax(MetabolicNetwork net, N[] values, NumberOperations<N> numberOps, Zero zero) {
        FluxNormalizer.normalize((MetabolicNetwork)net, values, numberOps, (boolean)true, (Zero)zero, (boolean)true);
    }

    public static <N extends Number> void normalizeMin(MetabolicNetwork net, N[] values, NumberOperations<N> numberOps, Zero zero) {
        FluxNormalizer.normalize((MetabolicNetwork)net, values, numberOps, (boolean)false, (Zero)zero, (boolean)true);
    }

    public static <N extends Number> void normalizeNorm2(MetabolicNetwork net, N[] values, NumberOperations<N> numberOps, Zero zero) {
        if (values instanceof BigDecimal[]) {
            FluxNormalizer.normalizeSquared((MetabolicNetwork)net, values, numberOps, (Zero)zero);
            BigDecimal[] vals = (BigDecimal[])values;
            int i = 0;
            while (i < vals.length) {
                int sgn = vals[i].signum();
                if (sgn < 0) {
                    vals[i] = BigMath.sqrt(vals[i].abs(), vals[i].scale()).negate();
                } else if (sgn > 0) {
                    vals[i] = BigMath.sqrt(vals[i], vals[i].scale());
                }
                ++i;
            }
        } else if (values instanceof BigFraction[]) {
            FluxNormalizer.normalizeSquared((MetabolicNetwork)net, values, numberOps, (Zero)zero);
            int i = 0;
            while (i < values.length) {
                int sgn = numberOps.signum(values[i]);
                if (sgn != 0) {
                    double sqrt;
                    if (sgn < 0) {
                        BigFraction abs = (BigFraction)numberOps.abs(values[i]);
                        sqrt = -BigMath.sqrt(abs);
                    } else {
                        sqrt = BigMath.sqrt((BigFraction)values[i]);
                    }
                    values[i] = numberOps.valueOf(sqrt);
                }
                ++i;
            }
        } else {
            throw new RuntimeException("not implemented for type " + values.getClass().getComponentType().getName());
        }
    }

    public static <N extends Number> void normalizeSquared(MetabolicNetwork net, N[] values, NumberOperations<N> numberOps, Zero zero) {
        N sumSquared = numberOps.zero();
        int i = 0;
        while (i < values.length) {
            int sgn = numberOps.signum(values[i]);
            if (sgn != 0) {
                values[i] = numberOps.multiply(values[i], values[i]);
                sumSquared = numberOps.add(sumSquared, values[i]);
                sumSquared = numberOps.reduce(sumSquared);
                if (sgn < 0) {
                    values[i] = numberOps.negate(values[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < values.length) {
            if (numberOps.isNonZero(values[i])) {
                values[i] = numberOps.divide(values[i], sumSquared);
                values[i] = numberOps.reduce(values[i]);
            }
            ++i;
        }
    }

    private static <N extends Number> void normalize(MetabolicNetwork net, N[] values, NumberOperations<N> numberOps, boolean max, Zero zero, boolean normalizeOnlyIntegerRatios) {
        ArrayIterable<? extends Reaction> reacts;
        ArrayIterable<? extends Reaction> arrayIterable = reacts = net == null ? null : net.getReactions();
        if (reacts != null && values.length != reacts.length()) {
            throw new IllegalArgumentException("reaction count != value count: " + reacts.length() + " != " + values.length);
        }
        Object refValue = null;
        Object iRefValue = null;
        int ii = 0;
        while (ii < values.length) {
            N absValue = numberOps.abs(values[ii]);
            if (FluxNormalizer.sgn(absValue, numberOps, zero) != 0) {
                refValue = refValue == null ? absValue : (max ? numberOps.max(refValue, (Object)absValue) : numberOps.min(refValue, (Object)absValue));
                if (!normalizeOnlyIntegerRatios || reacts == null || reacts.get(ii).hasIntegerRatios()) {
                    iRefValue = iRefValue == null ? absValue : (max ? numberOps.max(iRefValue, (Object)absValue) : numberOps.min(iRefValue, (Object)absValue));
                }
            }
            ++ii;
        }
        if (iRefValue != null && FluxNormalizer.sgn(iRefValue, numberOps, zero) != 0) {
            refValue = iRefValue;
        }
        if (refValue == null || FluxNormalizer.sgn(refValue, numberOps, zero) == 0) {
            return;
        }
        ii = 0;
        while (ii < values.length) {
            values[ii] = numberOps.divide(values[ii], refValue);
            values[ii] = numberOps.reduce(values[ii]);
            ++ii;
        }
    }

    private static <N extends Number> int sgn(N value, NumberOperations<N> numberOps, Zero zero) {
        return zero == null ? numberOps.signum(value) : zero.sgn(value.doubleValue());
    }
}

