/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.generate.MatlabGenerator;
import ch.javasoft.metabolic.generate.SbmlGenerator;
import ch.javasoft.xml.config.StreamConfigParser;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.dom4j.Element;
import org.dom4j.Node;

public class ConfiguredGenerator {
    public static void generateConfig(Element parentElement, MetabolicNetwork net) throws XmlConfigException, IOException {
        Element parseElement = XmlUtil.getRequiredSingleChildElement(parentElement, XmlElements.metabolic_generate);
        ConfiguredGenerator.generate(parseElement, net);
    }

    public static void generate(Element metabolicParseElement, MetabolicNetwork net) throws XmlConfigException, IOException {
        XmlUtil.checkExpectedElementName(metabolicParseElement, XmlElements.metabolic_generate);
        Element parseElement = XmlUtil.getRequiredSingleChildElement(metabolicParseElement, XmlElements.generate);
        String type = parseElement.attributeValue(XmlAttributes.type.getXmlName());
        GenerateType gType = GenerateType.find(type);
        if (gType == null) {
            throw new XmlConfigException("unknown generate type '" + type + "'", (Node)parseElement);
        }
        switch (gType) {
            case sbml: {
                ConfiguredGenerator.generateSbml(parseElement, net);
                return;
            }
            case matlab: {
                ConfiguredGenerator.generateMatlab(parseElement, net);
                return;
            }
        }
        throw new XmlConfigException("internal error: unknown parse type " + (Object)((Object)gType), (Node)parseElement);
    }

    private static void generateSbml(Element parseElement, MetabolicNetwork net) throws XmlConfigException, IOException {
        Element elOutput = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.output);
        Element elModel = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.model);
        OutputStream out = StreamConfigParser.parseOutputStream(elOutput);
        String modelName = XmlUtil.getRequiredAttributeValue(elModel, XmlAttributes.name);
        new SbmlGenerator(net, modelName).write(out);
    }

    private static void generateMatlab(Element parseElement, MetabolicNetwork net) throws XmlConfigException, IOException {
        Element elOutput = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.output);
        Element elStruct = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.struct);
        OutputStream out = StreamConfigParser.parseOutputStream(elOutput);
        String structName = XmlUtil.getRequiredAttributeValue(elStruct, XmlAttributes.name);
        PrintWriter pw = Print.createWriter(out);
        new MatlabGenerator(structName).writeAll(net, pw);
        pw.flush();
        pw.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenerateType {
        sbml,
        matlab;


        String getXmlName() {
            return this.name().replaceAll("_", "-");
        }

        static GenerateType find(String type) {
            GenerateType[] generateTypeArray = GenerateType.values();
            int n = generateTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenerateType gType = generateTypeArray[n2];
                if (gType.getXmlName().equals(type)) {
                    return gType;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttributes implements XmlNode
    {
        type,
        name;


        @Override
        public String getXmlName() {
            return this.name().replaceAll("_", "-");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElements implements XmlNode
    {
        metabolic_generate,
        generate,
        output,
        model,
        struct;


        @Override
        public String getXmlName() {
            return this.name().replaceAll("_", "-");
        }
    }
}

