/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.ColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.model.nullspace.CannotReconstructFluxException;
import ch.javasoft.metabolic.efm.sort.SortUtil;
import ch.javasoft.metabolic.efm.util.LogPkg;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import ch.javasoft.util.logging.LogWriter;
import ch.javasoft.util.logging.Loggers;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EfmHelper {
    private static final Logger LOG = LogPkg.LOGGER;

    public static <N extends Number, Col extends Column> int appendExternalExternalFluxModes(GenericDynamicArray<FluxDistribution> fluxes, MetabolicNetwork metaNet, ColumnHome<N, Col> columnHome) {
        int count = 0;
        NumberOperations<N> numberOps = columnHome.getNumberOperations();
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        int ii = 0;
        while (ii < reacts.length()) {
            Reaction reac = reacts.get(ii);
            if (reac.isUptake() && reac.isExtract()) {
                ++count;
                Object[] rates = numberOps.newArray(reacts.length());
                java.util.Arrays.fill(rates, numberOps.zero());
                rates[ii] = numberOps.one();
                fluxes.add(columnHome.createFluxDistribution(metaNet, (Number[])rates));
                if (reac.getConstraints().isReversible()) {
                    ++count;
                    Number[] ratesRev = (Number[])rates.clone();
                    ratesRev[ii] = numberOps.negate(numberOps.one());
                    fluxes.add(columnHome.createFluxDistribution(metaNet, ratesRev));
                }
            }
            ++ii;
        }
        return count;
    }

    public static <N extends Number, Col extends Column> void efmSelfTest(ColumnToFluxDistributionConverter<N, Col> converter, Config config, NetworkEfmModel model, Col newCol, Col oldA, Col oldB) {
        try {
            converter.createFluxDistributionFromColumn(config, model, newCol);
        }
        catch (CannotReconstructFluxException ex) {
            FluxDistribution fluxB;
            FluxDistribution fluxA;
            try {
                fluxA = converter.createFluxDistributionFromColumn(config, model, oldA);
            }
            catch (CannotReconstructFluxException e) {
                fluxA = null;
            }
            try {
                fluxB = converter.createFluxDistributionFromColumn(config, model, oldB);
            }
            catch (CannotReconstructFluxException e) {
                fluxB = null;
            }
            LOG.severe("new column is not a valid flux mode (old.A is " + (fluxA != null ? "ok" : "nok") + ", old.B is " + (fluxB != null ? "ok" : "nok") + ")");
            LOG.severe("new   = " + newCol);
            LOG.severe("old.A = " + oldA);
            LOG.severe("old.B = " + oldB);
            LOG.severe("nullspace for new is:");
            ex.getNullspace().writeToMultiline(new LogWriter(LOG, Level.SEVERE));
            int[] rowUnmappings = EfmHelper.rowUnmappings(model.getReactionSorting());
            if (fluxA != null) {
                LOG.severe("flux.A = " + java.util.Arrays.toString(EfmHelper.mapRows(fluxA.getDoubleRates(), rowUnmappings)));
            }
            if (fluxB != null) {
                LOG.severe("flux.B = " + java.util.Arrays.toString(EfmHelper.mapRows(fluxB.getDoubleRates(), rowUnmappings)));
            }
            throw ex;
        }
    }

    private static DoubleMatrix createKernelDbl(MetabolicNetwork metaNet, DoubleMatrix mx, int[] rowMapping, Config config, boolean log) {
        DefaultBigIntegerRationalMatrix biMx = new DefaultBigIntegerRationalMatrix(mx.toDoubleArray(), mx.getRowCount(), mx.getColumnCount(), true);
        return ((BigIntegerRationalMatrix)EfmHelper.createKernel(metaNet, biMx, rowMapping, config, log)).toDoubleMatrix(false);
    }

    public static <M extends ReadableMatrix<?>> M createKernel(MetabolicNetwork metaNet, M mx, int[] rowMapping, Config config, boolean log) {
        if (mx instanceof BigIntegerRationalMatrix) {
            return (M)EfmHelper.createKernelBI(metaNet, (BigIntegerRationalMatrix)mx, rowMapping, config, log);
        }
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return (M)EfmHelper.createKernelBI(metaNet, (ReadableBigIntegerRationalMatrix)mx, rowMapping, config, log);
        }
        if (mx instanceof DoubleMatrix) {
            return (M)EfmHelper.createKernelDbl(metaNet, (DoubleMatrix)mx, rowMapping, config, log);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    private static DoubleMatrix createKernelDblOld(MetabolicNetwork metaNet, DoubleMatrix mx, int[] rowMapping, Config config, boolean log) {
        DoubleMatrix biKn = new Gauss(config.zero().mZeroPos).nullspace(mx);
        DoubleMatrix kn = EfmHelper.formatKernel(metaNet, biKn, rowMapping, config);
        EfmHelper.sortKernel(metaNet, mx, kn, rowMapping, config, log);
        return kn;
    }

    private static BigIntegerRationalMatrix createKernelBI(MetabolicNetwork metaNet, ReadableBigIntegerRationalMatrix<BigFraction> mx, int[] rowMapping, Config config, boolean log) {
        BigIntegerRationalMatrix biKn = Gauss.getRationalInstance().nullspace(mx);
        BigIntegerRationalMatrix kn = EfmHelper.formatKernel(metaNet, biKn, rowMapping, config);
        EfmHelper.sortKernel(metaNet, mx, kn, rowMapping, config, log);
        return kn;
    }

    private static <N extends Number, M extends ReadableDoubleMatrix<N> & WritableMatrix<N>> void sortKernel(MetabolicNetwork metaNet, ReadableDoubleMatrix<N> stoich, M kernel, int[] rowMapping, Config config, boolean log) {
        LogWriter finerWriter;
        if (log && LOG.isLoggable(Level.FINE)) {
            LogWriter fineWriter = new LogWriter(LOG, Level.FINE);
            LOG.finer("stoichiometrix matrix");
            new DefaultDoubleMatrix(StoichiometricMatrices.createStoichiometricMatrix(metaNet), true).writeToMultiline(fineWriter);
        }
        if (log && LOG.isLoggable(Level.FINER)) {
            finerWriter = new LogWriter(LOG, Level.FINER);
            LOG.finer("expanded stoichiometric matrix");
            stoich.writeToMultiline(finerWriter);
            LOG.finer("kernel matrix (unmapped):");
            kernel.writeToMultiline(finerWriter);
            LOG.finer("kernel matrix:");
            ReactionMapping.unsortKernelMatrixRows(kernel, rowMapping).writeToMultiline(finerWriter);
        }
        SortUtil.sortKernel(kernel, rowMapping, metaNet, config);
        if (log && LOG.isLoggable(Level.FINE)) {
            LOG.fine("reaction-sorting  (KERNEL): " + java.util.Arrays.toString(rowMapping));
        }
        if (log && LOG.isLoggable(Level.FINER)) {
            finerWriter = new LogWriter(LOG, Level.FINER);
            LOG.finer("initial kernel matrix (sorted):");
            kernel.writeToMultiline(finerWriter);
            LOG.finer("mx * kernel:");
            EfmHelper.mulMapped(stoich, kernel, rowMapping).writeToMultiline(finerWriter);
        }
    }

    private static <N extends Number, M extends ReadableDoubleMatrix<N> & WritableMatrix<N>> M formatKernel(MetabolicNetwork metaNet, M kn, int[] rowMapping, Config config) {
        int rows = kn.getRowCount();
        int cols = kn.getColumnCount();
        NumberOperations nops = kn.getNumberOperations();
        Object zero = nops.valueOf(config.zero().mZeroPos);
        Object oneU = nops.add(nops.one(), zero);
        Object oneL = nops.subtract(nops.one(), zero);
        BitSet pivots = new BitSet(cols);
        int rowEnd = rows;
        int row = 0;
        while (row < rowEnd) {
            if (pivots.get(row)) {
                ++row;
                continue;
            }
            int cnt0 = 0;
            int pos1 = -1;
            int col = 0;
            while (col < cols) {
                if (kn.getSignumAt(row, col) == 0) {
                    ++cnt0;
                } else {
                    Object val = kn.getNumberValueAt(row, col);
                    Object abs = nops.abs(val);
                    if (nops.compare(abs, zero) < 0) {
                        ++cnt0;
                        ((WritableMatrix)kn).setValueAt(row, col, nops.zero());
                    } else if (pos1 == -1 && nops.isOne(val)) {
                        pos1 = col;
                    } else {
                        if (pos1 != -1 || nops.compare(val, oneU) >= 0 || nops.compare(val, oneL) <= 0) break;
                        pos1 = col;
                        ((WritableMatrix)kn).setValueAt(row, col, nops.one());
                    }
                }
                ++col;
            }
            if (pos1 != -1 && cnt0 == cols - 1) {
                int tmp;
                if (pivots.get(pos1)) {
                    if (row == --rowEnd) continue;
                    ((WritableMatrix<N>)kn).swapRows(row, rowEnd);
                    tmp = rowMapping[row];
                    rowMapping[row] = rowMapping[rowEnd];
                    rowMapping[rowEnd] = tmp;
                    continue;
                }
                pivots.set(pos1);
                if (row != pos1) {
                    ((WritableMatrix<N>)kn).swapRows(row, pos1);
                    tmp = rowMapping[row];
                    rowMapping[row] = rowMapping[pos1];
                    rowMapping[pos1] = tmp;
                    continue;
                }
                ++row;
                continue;
            }
            ++row;
        }
        if (pivots.length() == cols && pivots.cardinality() == cols) {
            return EfmHelper.reestablishReactionCategoryOrder(metaNet, kn, rowMapping, config);
        }
        String msg = "identity matrix not found in big integer rational matrix, found " + pivots.cardinality() + " of " + cols + ": " + pivots;
        LOG.warning(msg);
        throw new RuntimeException(msg);
    }

    private static <N extends Number, M extends ReadableDoubleMatrix<N> & WritableMatrix<N>> M reestablishReactionCategoryOrder(MetabolicNetwork metaNet, M kn, int[] rowMapping, Config config) {
        int rows;
        LogWriter logFinest = new LogWriter(LOG, Level.FINEST);
        if (Loggers.isLoggable(LOG, Level.FINEST)) {
            LOG.finest("formatted kernel before reestablishing reaction category sorting:");
            kn.writeToMultiline(logFinest);
        }
        NumberOperations nops = kn.getNumberOperations();
        ReactionMapping rmap = new ReactionMapping(config, metaNet, rowMapping);
        int cols = kn.getColumnCount();
        int rowsActive = rows = kn.getRowCount();
        ReactionMapping.Category[] categoryArray = ReactionMapping.Category.values();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReactionMapping.Category cat = categoryArray[n2];
            if (cat.isSpecial()) {
                int row = 0;
                while (row < cols) {
                    if (cat == rmap.getReactionCategoryBySortedIndex(row)) {
                        LOG.finest("row " + row + " is " + (Object)((Object)cat));
                        LOG.finest("swapping rows " + row + " and " + --rowsActive);
                        ((WritableMatrix<N>)kn).swapRows(row, rowsActive);
                        Arrays.swap(rowMapping, row, rowsActive);
                        if (Loggers.isLoggable(LOG, Level.FINEST)) {
                            LOG.finest("formatted after swapping last/" + row);
                            kn.writeToMultiline(logFinest);
                        }
                        if (kn.getSignumAt(row, row) == 0 || rmap.getReactionCategoryBySortedIndex(row).isSpecial()) {
                            int nonZeroRow = -1;
                            int i = cols;
                            while (i < rowsActive) {
                                if (kn.getSignumAt(i, row) != 0) {
                                    if (rmap.getReactionCategoryBySortedIndex(i).isSpecial()) {
                                        LOG.finest("swap candidate " + i + " is " + (Object)((Object)rmap.getReactionCategoryBySortedIndex(i)));
                                    } else {
                                        nonZeroRow = i;
                                        break;
                                    }
                                }
                                ++i;
                            }
                            if (nonZeroRow < 0) {
                                kn.writeToMultiline(new LogWriter(LOG, Level.WARNING));
                                throw new RuntimeException("no replacement row found with non-zero pivot to reastablish row-echelon form of kernel matrix for row " + row);
                            }
                            LOG.finest("swapping rows " + row + " and " + nonZeroRow);
                            ((WritableMatrix<N>)kn).swapRows(row, nonZeroRow);
                            Arrays.swap(rowMapping, row, nonZeroRow);
                            if (Loggers.isLoggable(LOG, Level.FINEST)) {
                                LOG.finest("formatted after swapping rows " + row + " and " + nonZeroRow);
                                kn.writeToMultiline(logFinest);
                            }
                        }
                        if (!nops.isOne(kn.getNumberValueAt(row, row))) {
                            Object piv = kn.getNumberValueAt(row, row);
                            int r = cols;
                            while (r < rows) {
                                Object div = nops.divide(kn.getNumberValueAt(r, row), piv);
                                ((WritableMatrix)kn).setValueAt(r, row, nops.reduce(div));
                                ++r;
                            }
                            ((WritableMatrix)kn).setValueAt(row, row, nops.one());
                        }
                        int col = 0;
                        while (col < cols) {
                            if (col != row && kn.getSignumAt(row, col) != 0) {
                                Object colpiv = kn.getNumberValueAt(row, col);
                                int r = cols;
                                while (r < rows) {
                                    Object pivval = kn.getNumberValueAt(r, row);
                                    Object val = kn.getNumberValueAt(r, col);
                                    Object sub = nops.multiply(pivval, colpiv);
                                    Object newval = nops.subtract(val, sub);
                                    ((WritableMatrix)kn).setValueAt(r, col, nops.reduce(newval));
                                    ++r;
                                }
                                ((WritableMatrix)kn).setValueAt(row, col, nops.zero());
                            }
                            ++col;
                        }
                    }
                    ++row;
                }
            }
            ++n2;
        }
        if (Loggers.isLoggable(LOG, Level.FINEST)) {
            LOG.finest("formatted kernel after reestablishing reaction category sorting:");
            kn.writeToMultiline(logFinest);
        }
        return kn;
    }

    public static <N extends Number> ReadableMatrix<N> mulMapped(ReadableMatrix<N> stoich, ReadableMatrix<N> kn, int[] rowMapping) {
        ReadableMatrix<N> knUnmapped = rowMapping == null ? kn : ReactionMapping.unsortKernelMatrixRows(kn, rowMapping);
        return Mul.multiplyGeneric(stoich, knUnmapped);
    }

    private static double[] mapRows(double[] values, int[] rowMapping) {
        double[] res = new double[values.length];
        int ii = 0;
        while (ii < res.length) {
            res[rowMapping[ii]] = values[ii];
            ++ii;
        }
        return res;
    }

    private static int[] rowUnmappings(int[] rowMapping) {
        int[] unmapping = new int[rowMapping.length];
        int ii = 0;
        while (ii < unmapping.length) {
            unmapping[rowMapping[ii]] = ii;
            ++ii;
        }
        return unmapping;
    }
}

