/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.outcore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.FixedWidthTable;
import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.Partition;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentInterNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentLeafNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNodeEntity;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNodeEntityMarshaller;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentBitPatternTree
implements BitPatternTree {
    private final BitPatternTree.Kind kind;
    private final ConcurrentTable<PersistentNodeEntity> table;
    private final int bitSetSize;
    private final PersistentNode root;
    private static final int MAX_LEAF_SIZE = 4;

    private PersistentBitPatternTree(Thread owner, BitPatternTree.Kind kind, FixedWidthTable<PersistentNodeEntity> table, int bitSetSize) throws IOException {
        this.kind = kind;
        this.table = new ConcurrentTable(table, owner);
        this.bitSetSize = bitSetSize;
        this.root = table.get(0).toNode(this, null, null);
    }

    private <Col extends Column, N extends Number> PersistentBitPatternTree(Thread owner, File tmpDir, ColumnHome<N, Col> columnHome, EfmModel efmModel, AdjEnumModel<Col> itModel, BitPatternTree.Kind kind, int[] selectiveBits, SortableMemory<Col> columns) throws IOException {
        this.kind = kind;
        File file = PersistentBitPatternTree.getTreeFile(tmpDir, efmModel.getConfig(), efmModel, itModel, kind);
        int cols = columns.getColumnCount();
        Partition partition = ColumnUtil.partitionColumns(columns, selectiveBits[0], 0, cols);
        this.bitSetSize = itModel.getCurrentState().getBooleanSize();
        this.table = new ConcurrentTable(FixedWidthTable.create(file, new PersistentNodeEntityMarshaller(this.bitSetSize), Cache.PersistentBitPatternTree.getCacheTableSize(), Cache.PersistentBitPatternTree.getCacheEntrySize()), owner);
        this.root = this.createNode(columnHome, this.table, selectiveBits, 0, columns, 0, cols, partition);
        this.table.flush();
    }

    @Override
    public BitPatternTree.Kind kind() {
        return this.kind;
    }

    @Override
    public int bitSetSize() {
        return this.bitSetSize;
    }

    @Override
    public Node root() {
        return this.root;
    }

    @Override
    public void closeForCurrentThread() throws IOException {
        this.table.close(false);
    }

    @Override
    public void close() throws IOException {
        this.table.close(true);
    }

    public PersistentNodeEntity getEntity(int tableIndex) throws IOException {
        return this.table.get(tableIndex);
    }

    public static <Col extends Column, N extends Number> PersistentBitPatternTree open(Thread owner, File folder, ColumnHome<N, Col> columnHome, EfmModel efmModel, AdjEnumModel<Col> itModel, BitPatternTree.Kind kind) throws IOException {
        int bitSetSize = itModel.getCurrentState().getBooleanSize();
        File file = PersistentBitPatternTree.getTreeFile(folder, efmModel.getConfig(), efmModel, itModel, kind);
        FixedWidthTable<PersistentNodeEntity> table = FixedWidthTable.open(file, new PersistentNodeEntityMarshaller(bitSetSize), Cache.PersistentBitPatternTree.getCacheTableSize(), Cache.PersistentBitPatternTree.getCacheEntrySize());
        return new PersistentBitPatternTree(owner, kind, table, bitSetSize);
    }

    public static <Col extends Column, N extends Number> PersistentBitPatternTree create(Thread owner, File folder, ColumnHome<N, Col> columnHome, EfmModel efmModel, AdjEnumModel<Col> itModel, BitPatternTree.Kind kind, int[] selectiveBits, SortableMemory<Col> columns) throws IOException {
        return new PersistentBitPatternTree(owner, folder, columnHome, efmModel, itModel, kind, selectiveBits, columns);
    }

    private static File getTreeFile(File folder, Config config, EfmModel model, AdjEnumModel<? extends Column> iterationModel, BitPatternTree.Kind kind) {
        return new File(folder, "bstree-" + iterationModel.getIterationIndex() + "-" + kind.toChar() + ".tbl");
    }

    private <Col extends Column, N extends Number> PersistentNode createNode(ColumnHome<N, Col> columnHome, Table<PersistentNodeEntity> table, int[] selectiveBits, int curSelectiveBit, SortableMemory<Col> columns, int start, int end, Partition lastPartition) throws IOException {
        if (end - start <= 4) {
            return this.createLeafNode(columnHome, selectiveBits, curSelectiveBit, columns, start, end, lastPartition);
        }
        return this.createInterNode(columnHome, selectiveBits, curSelectiveBit, columns, start, end, lastPartition);
    }

    protected <Col extends Column, N extends Number> PersistentInterNode createInterNode(ColumnHome<N, Col> columnHome, int[] selectiveBits, int curSelectiveBit, SortableMemory<Col> columns, int start, int end, Partition lastPartition) throws IOException {
        while (lastPartition.getMedian() == start || lastPartition.getMedian() == end) {
            lastPartition = ColumnUtil.partitionColumns(columns, selectiveBits[++curSelectiveBit], start, end);
        }
        IBitSet union = lastPartition.unionPattern();
        int median = lastPartition.getMedian();
        int myTableIndex = this.table.size();
        PersistentNodeEntity entity = PersistentNodeEntity.createForInterNode(union, 0, 0);
        this.table.add(entity);
        Partition partitionLeft = ColumnUtil.partitionColumns(columns, selectiveBits[++curSelectiveBit], start, median);
        Partition partitionRight = ColumnUtil.partitionColumns(columns, selectiveBits[curSelectiveBit], median, end);
        int leftTableIndex = this.table.size();
        PersistentNode left = this.createNode(columnHome, this.table, selectiveBits, curSelectiveBit, columns, start, median, partitionLeft);
        int rightTableIndex = this.table.size();
        PersistentNode right = this.createNode(columnHome, this.table, selectiveBits, curSelectiveBit, columns, median, end, partitionRight);
        entity = PersistentNodeEntity.createForInterNode(union, leftTableIndex, rightTableIndex);
        this.table.set(myTableIndex, entity);
        return entity.toInterNode(this, left, right);
    }

    protected <Col extends Column, N extends Number> PersistentLeafNode createLeafNode(ColumnHome<N, Col> columnHome, int[] selectiveBits, int curSelectiveBit, SortableMemory<Col> columns, int start, int end, Partition lastPartition) throws IOException {
        IBitSet union = lastPartition.unionPattern();
        PersistentNodeEntity entity = PersistentNodeEntity.createForLeaf(union, start, end);
        this.table.add(entity);
        return entity.toLeafNode(this);
    }
}

