/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.impl;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.tree.AdjacencyFilter;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.InterNode;
import ch.javasoft.metabolic.efm.tree.LeafNode;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.impl.AbstractTreePairTraverser;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreePairTraverser<T extends ConcurrentToken>
extends AbstractTreePairTraverser<T> {
    protected final EfmModel efmModel;
    protected final AdjacencyPrecondition<T> precondition;
    protected final AdjacencyFilter<T> filter;

    public DefaultTreePairTraverser(EfmModel efmModel, AdjacencyPrecondition<T> precondition, AdjacencyFilter<T> filter) {
        this.efmModel = efmModel;
        this.precondition = precondition;
        this.filter = filter;
    }

    @Override
    public <Col extends Column, N extends Number> void traverseIN(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, Node other) throws IOException {
        if (this.precondition.enterIfMet(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other)) {
            other.traverseI(this, columnHome, iterationModel, token, otherDepth, myDepth, !meIsPos, me);
            this.precondition.leave(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other);
        } else {
            token.notifyProgressIncrement(myDepth + otherDepth);
        }
    }

    @Override
    public <Col extends Column, N extends Number> void traverseLN(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, LeafNode me, Node other) throws IOException {
        if (this.precondition.enterIfMet(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other)) {
            other.traverseL(this, columnHome, iterationModel, token, otherDepth, myDepth, !meIsPos, me);
            this.precondition.leave(columnHome, iterationModel, token, myDepth, otherDepth, meIsPos, me, other);
        } else {
            token.notifyProgressIncrement(myDepth + otherDepth);
        }
    }

    @Override
    public <Col extends Column, N extends Number> void traverseII(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, InterNode other) throws IOException {
        this.traverseNN(columnHome, iterationModel, token, myDepth + 1, otherDepth + 1, meIsPos, me.left(), other.left());
        this.traverseNN(columnHome, iterationModel, token, myDepth + 1, otherDepth + 1, meIsPos, me.left(), other.right());
        this.traverseNN(columnHome, iterationModel, token, myDepth + 1, otherDepth + 1, meIsPos, me.right(), other.left());
        this.traverseNN(columnHome, iterationModel, token, myDepth + 1, otherDepth + 1, meIsPos, me.right(), other.right());
    }

    @Override
    public <Col extends Column, N extends Number> void traverseIL(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, LeafNode other) throws IOException {
        this.traverseLN(columnHome, iterationModel, token, otherDepth, myDepth + 1, !meIsPos, other, me.left());
        this.traverseLN(columnHome, iterationModel, token, otherDepth, myDepth + 1, !meIsPos, other, me.right());
    }

    @Override
    public <Col extends Column, N extends Number> void traverseLL(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean meIsPos, LeafNode me, LeafNode other) throws IOException {
        SortableMemory<Col> otherCols;
        SortableMemory<Col> myCols;
        if (meIsPos) {
            myCols = iterationModel.getMemoryPos();
            otherCols = iterationModel.getMemoryNeg();
        } else {
            myCols = iterationModel.getMemoryNeg();
            otherCols = iterationModel.getMemoryPos();
        }
        int meS = me.getLeafColumnStart();
        int meE = me.getLeafColumnEnd();
        int otS = other.getLeafColumnStart();
        int otE = other.getLeafColumnEnd();
        AdjCandidates<Col> adjCandidates = new AdjCandidates<Col>(iterationModel.getMemoryPos(), iterationModel.getMemoryNeg(), (meE - meS) * (otE - otS));
        IBitSet commonPattern = null;
        int i = meS;
        while (i < meE) {
            int j = otS;
            while (j < otE) {
                if (this.precondition.isMet(columnHome, iterationModel, token, meIsPos ? i : j, meIsPos ? j : i)) {
                    int index = adjCandidates.size();
                    adjCandidates.add(myCols, i, otherCols, j);
                    IBitSet inter = adjCandidates.getIntersection(index);
                    int icard = inter.cardinality();
                    int pcard = adjCandidates.getColumnPos(index).bitValues().cardinality();
                    int ncard = adjCandidates.getColumnNeg(index).bitValues().cardinality();
                    if (pcard - icard == 1 || ncard - icard == 1) {
                        adjCandidates.appendLastColumn(columnHome, this.efmModel, iterationModel);
                    } else if (commonPattern == null) {
                        commonPattern = inter;
                    } else {
                        commonPattern.and(inter);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (this.filter.filter(columnHome, iterationModel, token, adjCandidates, commonPattern)) {
            adjCandidates.appendNewColumns(columnHome, this.efmModel, iterationModel);
        }
        token.notifyProgressIncrement(myDepth + otherDepth);
    }
}

