/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.progress;

import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.progress.AbstractStringProgressWriter;
import ch.javasoft.metabolic.efm.progress.FileProgressWriter;
import ch.javasoft.metabolic.efm.progress.JProgress;
import ch.javasoft.metabolic.efm.progress.ProgressNotifiable;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProgressType {
    None{

        @Override
        public ProgressNotifiable createProgressNotifiable(Config config, AdjEnumModel<?> itModel) {
            return null;
        }
    }
    ,
    File{

        @Override
        public ProgressNotifiable createProgressNotifiable(Config config, AdjEnumModel<?> itModel) {
            File tempDir = null;
            try {
                tempDir = config.getTempDir().getPersonalizedDir();
            }
            catch (Exception e) {
                tempDir = config.getTempDir().getBaseDir();
            }
            File progFile = new File(tempDir, "progress-" + itModel.getIterationIndex() + ".txt");
            return new FileProgressWriter(progFile, AbstractStringProgressWriter.Mode.Partition, config.getProgressPartition());
        }
    }
    ,
    Swing{

        @Override
        public ProgressNotifiable createProgressNotifiable(Config config, AdjEnumModel<?> itModel) throws IOException {
            return new JProgress(AbstractStringProgressWriter.Mode.Partition, config.getProgressPartition(), itModel.getIterationIndex(), itModel.getMemoryPos().getColumnCount(), itModel.getMemoryNeg().getColumnCount());
        }
    };


    private ProgressType() {
    }

    public String getXmlValue() {
        return this.name().toLowerCase();
    }

    public static ProgressType parse(String xmlValue) {
        ProgressType[] progressTypeArray = ProgressType.values();
        int n = progressTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressType type = progressTypeArray[n2];
            if (type.getXmlValue().equals(xmlValue)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no such progress type: " + xmlValue);
    }

    public abstract ProgressNotifiable createProgressNotifiable(Config var1, AdjEnumModel<?> var2) throws IOException;

    /* synthetic */ ProgressType(String string, int n, ProgressType progressType) {
        this();
    }
}

