/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.filter.ColumnFilter;
import ch.javasoft.metabolic.efm.column.filter.CompoundColumnFilter;
import ch.javasoft.metabolic.efm.column.filter.EnforcedFluxColumnFilter;
import ch.javasoft.metabolic.efm.column.filter.FutileCycleColumnFilter;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifierFactory;
import ch.javasoft.metabolic.efm.model.DefaultEfmModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.util.MatrixUtil;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.ops.Hsl;
import ch.javasoft.smx.ops.HslGateway;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.logging.LogPrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNetworkEfmModel
extends DefaultEfmModel
implements NetworkEfmModel {
    private final MetabolicNetwork metabolicNetwork;
    private final ReactionMapping reactionMapping;
    private final ColumnFilter columnFilter;
    private final int outOfLoopReactionCnt;

    public <N extends Number, Col extends Column> AbstractNetworkEfmModel(ColumnHome<N, Col> columnHome, MetabolicNetwork net, Config config, ColumnInspectorModifierFactory columnInspectorModifierFactory) {
        super(AbstractNetworkEfmModel.init(columnHome, net, config, columnInspectorModifierFactory));
        this.metabolicNetwork = net;
        this.columnFilter = new CompoundColumnFilter(new FutileCycleColumnFilter(this), new EnforcedFluxColumnFilter());
        this.reactionMapping = new ReactionMapping(config, this.metabolicNetwork, this.getReactionSorting());
        this.outOfLoopReactionCnt = this.reactionMapping.getExpandedReactionCountOutOfIterationLoop();
    }

    private static <N extends Number, Col extends Column> DefaultEfmModel.Init init(ColumnHome<N, Col> columnHome, MetabolicNetwork net, Config config, ColumnInspectorModifierFactory columnInspectorModifierFactory) {
        DefaultEfmModel.Init init = new DefaultEfmModel.Init();
        BigIntegerRationalMatrix stoichRational = MatrixUtil.convertToBigIntegerRationalMatrix(net.getStoichiometricMatrix(), config.zero(), false);
        boolean[] split = AbstractNetworkEfmModel.getReacsToSplit(net, config);
        Number[][] expStoich = (BigFraction[][])StoichiometricMatrices.createStoichiometricMatrixExpandReversible((ReadableMatrix)stoichRational, (boolean[])split);
        init.config = config;
        init.stoichiometricMatrixRational = stoichRational.newInstance(expStoich, true).toReadableMatrix(false);
        init.metaboliteSorting = AbstractNetworkEfmModel.createInitialMapping(expStoich.length);
        init.reactionSorting = AbstractNetworkEfmModel.createInitialMapping(expStoich.length == 0 ? 0 : expStoich[0].length);
        init.stoichRank = columnHome.rank(init.stoichiometricMatrixRational, config.zero());
        init.columnInspectorModifierFactory = columnInspectorModifierFactory;
        return init;
    }

    private static Hsl.Result_mc66 sortStoichMc66(ReadableMatrix<?> stoich) {
        IntArray irn = new IntArray();
        IntArray jcn = new IntArray();
        int i = 0;
        while (i < stoich.getRowCount()) {
            int j = 0;
            while (j < stoich.getColumnCount()) {
                if (stoich.getSignumAt(i, j) != 0) {
                    irn.add(i + 1);
                    jcn.add(j + 1);
                }
                ++j;
            }
            ++i;
        }
        return HslGateway.callMc66(stoich.getRowCount(), stoich.getColumnCount(), irn.toArray(), jcn.toArray(), 5);
    }

    private static int[] createInitialMapping(boolean[] split, Hsl.Result_mc66 sort66) {
        IntArray sort = new IntArray();
        int add = 0;
        int i = 0;
        while (i < split.length) {
            sort.add(sort66.column_order[i] - 1 + add);
            if (split[i]) {
                sort.add(sort66.column_order[i] - 1 + ++add);
            }
            ++i;
        }
        return sort.toArray();
    }

    private static <N extends Number> ReadableMatrix<N> sortStoich(ReadableMatrix<N> stoich, Hsl.Result_mc66 sort66) {
        WritableMatrix<N> mx = stoich.newInstance(stoich.getRowCount(), stoich.getColumnCount());
        int i = 0;
        while (i < sort66.row_order.length) {
            int j = 0;
            while (j < sort66.column_order.length) {
                mx.setValueAt(i, j, stoich.getNumberValueAt(sort66.row_order[i] - 1, j));
                ++j;
            }
            ++i;
        }
        return mx.toReadableMatrix(false);
    }

    private static boolean[] getReacsToSplit(MetabolicNetwork net, Config config) {
        boolean[] split = new boolean[net.getReactions().length()];
        int index = 0;
        for (Reaction reaction : net.getReactions()) {
            split[index] = ReactionMapping.isSplitReaction(config, net, reaction);
            ++index;
        }
        return split;
    }

    @Override
    public MetabolicNetwork getMetabolicNetwork() {
        return this.metabolicNetwork;
    }

    @Override
    public ColumnFilter getColumnFilter() {
        return this.columnFilter;
    }

    @Override
    public ReactionMapping getReactionMapping() {
        return this.reactionMapping;
    }

    @Override
    public int getOutOfIterationLoopCount() {
        return this.outOfLoopReactionCnt;
    }

    private static int[] createInitialMapping(int count) {
        int[] mapping = new int[count];
        int i = 0;
        while (i < count) {
            mapping[i] = i;
            ++i;
        }
        return mapping;
    }

    @Override
    public <N extends Number> void log(ColumnHome<N, ?> columnHome, Logger logger) {
        super.log(columnHome, logger);
        ReadableMatrix<BigFraction> stoich = this.getStoichRational();
        logger.info("stoich expanded has dimensions " + stoich.getRowCount() + "x" + stoich.getColumnCount());
        if (logger.isLoggable(Level.FINER)) {
            LogPrintWriter finerWriter = new LogPrintWriter(logger, Level.FINER);
            finerWriter.println("stoichiometric matrix");
            this.metabolicNetwork.getStoichiometricMatrix().writeToMultiline(finerWriter);
            finerWriter.println("expanded stoichiometric matrix");
            stoich.writeToMultiline(finerWriter);
        }
    }
}

