/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl.file;

import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.dist.DistributedAdjEnum;
import ch.javasoft.metabolic.efm.dist.DistributedInfo;
import ch.javasoft.metabolic.efm.dist.impl.DistClient;
import ch.javasoft.metabolic.efm.dist.impl.file.Args;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.ModelPersister;
import ch.javasoft.metabolic.efm.progress.IntProgressAggregator;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.logging.LogWriter;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileBasedDistJob {
    private static final String getHostName() throws IOException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static void main(String[] args) {
        String strTmpDir = Args.TempDir.getFromArgs(args);
        String strLogLevel = Args.LogLevel.getFromArgs(args);
        try {
            File tmpDir = new File(strTmpDir);
            File logFile = new File(tmpDir, String.valueOf(FileBasedDistJob.getHostName()) + ".log");
            Level logLevel = Level.parse(strLogLevel);
            Loggers.logToFile(logFile, logLevel);
            Logger logger = Loggers.getLogger(FileBasedDistJob.class.getSimpleName());
            FileBasedDistJob.main(args, logger);
        }
        catch (Exception e) {
            throw ExceptionUtil.toRuntimeException(e);
        }
    }

    static void main(String[] args, Logger logger) throws Exception {
        String strTmpDir = Args.TempDir.getFromArgs(args);
        String strConfigFile = Args.ConfigFile.getFromArgs(args);
        String strStoichFile = Args.StoichFile.getFromArgs(args);
        String strEfmModelFile = Args.EfmModelFile.getFromArgs(args);
        String strAdjModelFile = Args.AdjEnumModelFile.getFromArgs(args);
        String strMasterHost = Args.MasterHost.getFromArgs(args);
        int nodeIndex = Args.NodeIndex.getIntFromArgs(args);
        int masterPort = Args.MasterPort.getIntFromArgs(args);
        File tmpDir = new File(strTmpDir);
        File cfgFile = new File(tmpDir, strConfigFile);
        File stoichFile = new File(tmpDir, strStoichFile);
        File efmFile = new File(tmpDir, strEfmModelFile);
        File adjFile = new File(tmpDir, strAdjModelFile);
        Config config = Config.readFrom(cfgFile);
        DistributedAdjEnum delegate = config.getAdjMethodFactory().createDistributedAdjEnumFromConfig();
        config.getTempDir().mkdirPersonalized(tmpDir.getName(), true);
        config.log(logger, Level.FINER);
        ModelPersister persister = delegate.getModelPersister();
        ReadableMatrix stoich = persister.readStoich(stoichFile);
        EfmModel efmModel = persister.readEfmModel(config, stoich, efmFile);
        ColumnHome<?, ?> columnHome = efmModel.getArithmetic().getColumnHome();
        long id = Thread.currentThread().getId();
        logger.fine("thread: " + id);
        logger.fine("host: " + FileBasedDistJob.getHostName());
        logger.fine("args: " + Arrays.toString(args));
        efmModel.log(columnHome, logger);
        if (Loggers.isLoggable(logger, Level.FINEST)) {
            logger.finest("stoich: ");
            efmModel.getStoichRational().writeToMultiline(new LogWriter(logger, Level.FINEST));
        }
        DistClient client = new DistClient(columnHome, persister, adjFile, strMasterHost, masterPort);
        AdjEnumModel<?> adjModel = client.getAdjEnumModel();
        DistributedInfo distInfo = new DistributedInfo(efmModel.getConfig().getDistributedConfig(), nodeIndex);
        IntProgressAggregator prog = new IntProgressAggregator(client.getProgressAggregator());
        delegate.execDistributed(columnHome, efmModel.getConfig(), efmModel, adjModel, distInfo, client, prog);
    }
}

