/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.config;

import ch.javasoft.io.Files;
import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.compress.config.MetabolicCompressionConfig;
import ch.javasoft.metabolic.compress.config.XmlConfigException;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.adj.AdjMethodFactory;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.DistributedConfig;
import ch.javasoft.metabolic.efm.config.Generator;
import ch.javasoft.metabolic.efm.config.Normalize;
import ch.javasoft.metabolic.efm.config.XmlAttribute;
import ch.javasoft.metabolic.efm.config.XmlElement;
import ch.javasoft.metabolic.efm.impl.SequentialDoubleDescriptionImpl;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.incore.InCoreMemoryFactory;
import ch.javasoft.metabolic.efm.model.EfmModelFactory;
import ch.javasoft.metabolic.efm.model.nullspace.NullspaceEfmModelFactory;
import ch.javasoft.metabolic.efm.progress.ProgressType;
import ch.javasoft.metabolic.efm.util.TempDir;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final String CONFIG_FILE = "config/metabolic-efm.xml";
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final String DEFAULT_APP_NAME = "efmtool";
    public static final String HELP_NAME = "efm-help";
    public static final String USAGE_NAME = "efm-usage";
    public static final String VERSION_NAME = "efm-version";
    private final XmlConfig mXmlConfig;
    private final AdjMethodFactory mAdjFactory;
    private final Zero mZero;
    private final String mAdjMethod;
    private final String mRowOrdering;
    private final boolean mSelfTest;
    private final boolean mParseOnly;
    private final int mMaxThreads;
    private final Normalize mNormalize;
    private final Arithmetic mArithmetic;
    private final int mPrecision;
    private final int mProgressPartition;
    private final ProgressType mProgressType;
    private final DistributedConfig mDistributedConfig;
    private final Generator mGenerator;
    private final TempDir mTempDir;
    private final Set<String> mReactionsToSuppress;
    private final Set<String> mReactionsToEnforce;
    private final Set<String> mReactionsNoSplit;
    private final String mFlag;
    private final CompressionMethod[] mCompressionMethods;
    private final boolean mPreprocessDuplicateGenes;

    public Config(Zero zero, String adjMethod, String rowOrdering, CompressionMethod[] compressionMethods, boolean preprocessDuplicateGenes, boolean selfTest, boolean parseOnly, int maxThreads, Arithmetic arithmetic, int precision, Generator generator, Normalize normalize, String reactionsToSuppress, String reactionsToEnforce, String reactionsNoSplit, File tempDir, int progressPartition, ProgressType progressType, String flag, DistributedConfig distConfig) {
        this(zero, adjMethod, rowOrdering, compressionMethods, preprocessDuplicateGenes, selfTest, parseOnly, maxThreads, arithmetic, precision, generator, normalize, Config.toSet(reactionsToSuppress), Config.toSet(reactionsToEnforce), Config.toSet(reactionsNoSplit), tempDir, progressPartition, progressType, flag, distConfig);
    }

    public Config(Zero zero, String adjMethod, String rowOrdering, CompressionMethod[] compressionMethods, boolean preprocessDuplicateGenes, boolean selfTest, boolean parseOnly, int maxThreads, Arithmetic arithmetic, int precision, Generator generator, Normalize normalize, Set<String> reactionsToSuppress, Set<String> reactionsToEnforce, Set<String> reactionsNoSplit, File tempDir, int progressPartition, ProgressType progressType, String flag, DistributedConfig distConfig) {
        this(null, zero, adjMethod, rowOrdering, compressionMethods, preprocessDuplicateGenes, selfTest, parseOnly, maxThreads, arithmetic, precision, generator, normalize, reactionsToSuppress, reactionsToEnforce, reactionsNoSplit, tempDir, progressPartition, progressType, flag, distConfig);
    }

    public Config(XmlConfig xmlConfig, Zero zero, String adjMethod, String rowOrdering, CompressionMethod[] compressionMethods, boolean preprocessDuplicateGenes, boolean selfTest, boolean parseOnly, int maxThreads, Arithmetic arithmetic, int precision, Generator generator, Normalize normalize, String reactionsToSuppress, String reactionsToEnforce, String reactionsNoSplit, File tempDir, int progressPartition, ProgressType progressType, String flag, DistributedConfig distConfig) {
        this(xmlConfig, zero, adjMethod, rowOrdering, compressionMethods, preprocessDuplicateGenes, selfTest, parseOnly, maxThreads, arithmetic, precision, generator, normalize, Config.toSet(reactionsToSuppress), Config.toSet(reactionsToEnforce), Config.toSet(reactionsNoSplit), tempDir, progressPartition, progressType, flag, distConfig);
    }

    public Config(XmlConfig xmlConfig, Zero zero, String adjMethod, String rowOrdering, CompressionMethod[] compressionMethods, boolean preprocessDuplicateGenes, boolean selfTest, boolean parseOnly, int maxThreads, Arithmetic arithmetic, int precision, Generator generator, Normalize normalize, Set<String> reactionsToSuppress, Set<String> reactionsToEnforce, Set<String> reactionsNoSplit, File tempDir, int progressPartition, ProgressType progressType, String flag, DistributedConfig distConfig) {
        this.mZero = zero;
        this.mAdjMethod = adjMethod == null || adjMethod.length() == 0 || DEFAULT_CONFIG_NAME.equalsIgnoreCase(adjMethod) ? "pattern-tree-minzero" : adjMethod;
        this.mRowOrdering = rowOrdering == null || rowOrdering.length() == 0 || DEFAULT_CONFIG_NAME.equalsIgnoreCase(rowOrdering) ? "MostZerosOrAbsLexMin" : rowOrdering;
        this.mSelfTest = selfTest;
        this.mParseOnly = parseOnly;
        this.mPreprocessDuplicateGenes = preprocessDuplicateGenes;
        this.mCompressionMethods = compressionMethods == null ? CompressionMethod.STANDARD : compressionMethods;
        this.mMaxThreads = maxThreads <= 0 ? Runtime.getRuntime().availableProcessors() : maxThreads;
        this.mArithmetic = arithmetic;
        this.mGenerator = generator;
        this.mPrecision = precision;
        this.mProgressPartition = progressPartition;
        this.mProgressType = progressType;
        this.mNormalize = normalize;
        this.mTempDir = new TempDir(tempDir);
        this.mReactionsToSuppress = reactionsToSuppress;
        this.mReactionsToEnforce = reactionsToEnforce;
        this.mReactionsNoSplit = reactionsNoSplit;
        this.mXmlConfig = xmlConfig;
        this.mFlag = flag;
        this.mDistributedConfig = distConfig == null ? Config.getDistributedConfig(xmlConfig) : distConfig;
        this.mAdjFactory = Config.initAdjFactory(this);
    }

    private static AdjMethodFactory initAdjFactory(Config config) {
        try {
            return new AdjMethodFactory(config);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot initialize AdjFactories, e=" + e, e);
        }
    }

    private static DistributedConfig getDistributedConfig(XmlConfig xmlConfig) {
        try {
            if (xmlConfig == null) {
                return new DistributedConfig();
            }
            Element efmImplConfig = Config.getConfigEfmImplConfig(xmlConfig);
            Element efmDistConfig = XmlUtil.getOptionalSingleChildElement(efmImplConfig, XmlElement.distribute);
            if (efmDistConfig == null) {
                return new DistributedConfig();
            }
            return new DistributedConfig(efmDistConfig);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Set<String> toSet(String reacs) {
        if (reacs == null || reacs.trim().length() == 0) {
            return new LinkedHashSet<String>(0);
        }
        return Arrays.asSet(reacs.trim().split("[\\s,]+"));
    }

    private static File getDefaultTempDir() {
        File localTemp = new File("/local/tmp/");
        if (localTemp.exists() && localTemp.isDirectory() && localTemp.canRead() && localTemp.canWrite()) {
            return localTemp;
        }
        return Files.getTempDir();
    }

    public Zero zero() {
        return this.mZero;
    }

    public AdjMethodFactory getAdjMethodFactory() {
        return this.mAdjFactory;
    }

    public String getAdjMethod() {
        return this.mAdjMethod;
    }

    public String getRowOrdering() {
        return this.mRowOrdering;
    }

    public Arithmetic getArithmetic() {
        return this.mArithmetic;
    }

    public Generator getGenerator() {
        return this.mGenerator;
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public Normalize getNormalize() {
        return this.mNormalize;
    }

    public int getProgressPartition() {
        return this.mProgressPartition;
    }

    public ProgressType getProgressType() {
        return this.mProgressType;
    }

    public String getFlag() {
        return this.mFlag;
    }

    public boolean compressNetwork(boolean includeDuplicateGenesCompression) {
        if (this.mCompressionMethods == null || this.mCompressionMethods.length == 0) {
            return false;
        }
        if (this.mCompressionMethods.length > 1) {
            return true;
        }
        return includeDuplicateGenesCompression || this.mCompressionMethods[0] != CompressionMethod.DuplicateGene;
    }

    public boolean getPreprocessDuplicateGenes() {
        return this.mPreprocessDuplicateGenes;
    }

    public CompressionMethod[] getCompressionMethods(boolean includeDuplicateGenesCompression) {
        if (!includeDuplicateGenesCompression) {
            return CompressionMethod.removeDuplicateGeneMethods(this.mCompressionMethods);
        }
        return this.mCompressionMethods;
    }

    public boolean selfTest() {
        return this.mSelfTest;
    }

    public boolean parseOnly() {
        return this.mParseOnly;
    }

    public Set<String> getReactionsToSuppress() {
        return this.mReactionsToSuppress;
    }

    public Set<String> getReactionsToEnforce() {
        return this.mReactionsToEnforce;
    }

    public Set<String> getReactionsNoSplit() {
        return this.mReactionsNoSplit;
    }

    public DistributedConfig getDistributedConfig() {
        return this.mDistributedConfig;
    }

    public static boolean initForJUnitTest(String adjMethod, CompressionMethod[] cmpMethods, Arithmetic arithmetic) {
        Zero zero = arithmetic == Arithmetic.fractional ? new Zero(0.0) : new Zero();
        Config defCfg = new Config(zero, adjMethod, "MostZerosOrAbsLexMin", cmpMethods, true, false, false, Runtime.getRuntime().availableProcessors(), arithmetic, -1, Generator.Efm, Normalize.norm2, null, null, null, Config.getDefaultTempDir(), 100, ProgressType.Swing, null, null);
        return Config.initForJUnitTest(defCfg);
    }

    public static boolean initForJUnitTest(String adjMethod, String rowOrdering, CompressionMethod[] cmpMethods, Arithmetic arithmetic) {
        Config defCfg = new Config(arithmetic.getDefaultZero(), adjMethod, rowOrdering, cmpMethods, true, false, false, Runtime.getRuntime().availableProcessors(), arithmetic, -1, Generator.Efm, Normalize.norm2, null, null, null, Config.getDefaultTempDir(), 100, ProgressType.Swing, null, null);
        return Config.initForJUnitTest(defCfg);
    }

    public static boolean initForJUnitTest(String adjMethod, String rowOrdering, CompressionMethod[] cmpMethods, boolean selfTest, Arithmetic arithmetic) {
        Config defCfg = new Config(arithmetic.getDefaultZero(), adjMethod, rowOrdering, cmpMethods, true, false, selfTest, Runtime.getRuntime().availableProcessors(), arithmetic, -1, Generator.Efm, Normalize.norm2, null, null, null, Config.getDefaultTempDir(), 100, ProgressType.Swing, null, null);
        return Config.initForJUnitTest(defCfg);
    }

    public static boolean initForJUnitTest(String adjMethod, String rowOrdering, CompressionMethod[] cmpMethods, boolean selfTest, Arithmetic arithmetic, Norm normalize) {
        Config defCfg = new Config(arithmetic.getDefaultZero(), adjMethod, rowOrdering, cmpMethods, true, false, selfTest, Runtime.getRuntime().availableProcessors(), arithmetic, -1, Generator.Efm, Normalize.valueOf(normalize), null, null, null, Config.getDefaultTempDir(), 100, ProgressType.Swing, null, null);
        return Config.initForJUnitTest(defCfg);
    }

    public static boolean initForJUnitTest(String adjMethod, String rowOrdering, CompressionMethod[] cmpMethods, boolean selfTest, Arithmetic arithmetic, Norm normalize, int maxThreads) {
        Config defCfg = new Config(arithmetic.getDefaultZero(), adjMethod, rowOrdering, cmpMethods, true, false, selfTest, maxThreads, arithmetic, -1, Generator.Efm, Normalize.valueOf(normalize), null, null, null, Config.getDefaultTempDir(), 100, ProgressType.Swing, null, null);
        return Config.initForJUnitTest(defCfg);
    }

    public static boolean initForJUnitTest(String adjMethod, String rowOrdering, CompressionMethod[] cmpMethods, boolean selfTest, Arithmetic arithmetic, Norm normalize, int maxThreads, ProgressType progressType) {
        Config defCfg = new Config(arithmetic.getDefaultZero(), adjMethod, rowOrdering, cmpMethods, true, false, selfTest, maxThreads, arithmetic, -1, Generator.Efm, Normalize.valueOf(normalize), null, null, null, Config.getDefaultTempDir(), 100, progressType, null, null);
        return Config.initForJUnitTest(defCfg);
    }

    public static boolean initForJUnitTest(Config defaultConfig) {
        try {
            Config.getConfig();
            return false;
        }
        catch (IllegalStateException ex) {
            ElementaryFluxModes.setImpl(new SequentialDoubleDescriptionImpl(defaultConfig, new NullspaceEfmModelFactory(), new InCoreMemoryFactory()));
            Config.traceArgs(Loggers.getRootLogger(), Level.INFO, "initForJUnitTest() with following (derived) arguments: ", defaultConfig.getAsArgs());
            return true;
        }
    }

    public static Config getConfig() throws IllegalStateException {
        ElementaryFluxModes.Impl impl = ElementaryFluxModes.getImpl();
        if (impl == null) {
            throw new IllegalStateException("no impl set in ElementaryFluxModes");
        }
        Config config = impl.getConfig();
        if (config == null) {
            throw new IllegalStateException("no config in ElementaryFluxModes.getImpl()");
        }
        return config;
    }

    public static Config getFromXmlConfig(XmlConfig xmlConfig) throws ch.javasoft.xml.config.XmlConfigException {
        CompressionMethod[] cmpMethods;
        boolean preprocessDuplicateGenes;
        int progPartition;
        Element efmCompConfig = Config.getConfigMetabolicCompression(xmlConfig);
        Element efmImplConfig = Config.getConfigEfmImplConfig(xmlConfig);
        Element efmOutputConfig = Config.getConfigEfmOutput(xmlConfig);
        Element efmNumConfig = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.numeric);
        Element efmDistConfig = XmlUtil.getOptionalSingleChildElement(efmImplConfig, XmlElement.distribute);
        Element elGenerator = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.generator);
        Element elReacsToSup = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.reactions_to_suppress);
        Element elReacsToEnf = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.reactions_to_enforce);
        Element elReacsNoSplit = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.reactions_no_split);
        Element elTmpDir = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.temp_dir);
        Element elProgress = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.progress);
        Element elFlag = XmlUtil.getOptionalSingleChildElement(efmImplConfig, XmlElement.flag);
        String rowOrdering = Config.getAttributeValue(efmImplConfig, XmlElement.row_ordering, XmlAttribute.value);
        String adjMethod = Config.getAttributeValue(efmImplConfig, XmlElement.adjacency_method, XmlAttribute.value);
        int maxThreads = Integer.parseInt(Config.getAttributeValue(efmImplConfig, XmlElement.maxthreads, XmlAttribute.value));
        Element elArithmetic = XmlUtil.getRequiredSingleChildElement(efmNumConfig, XmlElement.arithmetic);
        Element elPrecision = XmlUtil.getRequiredSingleChildElement(efmNumConfig, XmlElement.precision);
        Element elZero = XmlUtil.getRequiredSingleChildElement(efmNumConfig, XmlElement.zero);
        int precision = XmlElement.parsePrecision(elPrecision.attribute(XmlAttribute.value.getXmlName()));
        double dblZero = XmlElement.parseZero(elZero.attribute(XmlAttribute.value.getXmlName()));
        Arithmetic arithmetic = Arithmetic.parse(elArithmetic.attribute(XmlAttribute.value.getXmlName()));
        Normalize normalize = Normalize.parse(efmOutputConfig.attribute(XmlAttribute.normalize.getXmlName()));
        Generator generator = Generator.parse(elGenerator.attribute(XmlAttribute.value.getXmlName()));
        String reacsToSuppress = XmlUtil.getRequiredAttributeValue(elReacsToSup, XmlAttribute.value);
        String reacsToEnforce = XmlUtil.getRequiredAttributeValue(elReacsToEnf, XmlAttribute.value);
        String reacsNoSplit = XmlUtil.getRequiredAttributeValue(elReacsNoSplit, XmlAttribute.value);
        Zero zero = Double.isNaN(dblZero) ? arithmetic.getDefaultZero() : new Zero(dblZero);
        File tmpDir = new File(XmlUtil.getRequiredAttributeValue(elTmpDir, XmlAttribute.name));
        String strProgType = XmlUtil.getRequiredAttributeValue(elProgress, XmlAttribute.type);
        String strProgPartition = XmlUtil.getRequiredAttributeValue(elProgress, XmlAttribute.partition);
        String flag = elFlag == null ? null : XmlUtil.getOptionalAttributeValue(elFlag, XmlAttribute.value, null);
        try {
            progPartition = Integer.parseInt(strProgPartition);
        }
        catch (Exception ex) {
            throw new ch.javasoft.xml.config.XmlConfigException("invalid value for progress partition, expected integer value, but found: " + strProgPartition, (Node)elProgress);
        }
        ProgressType progType = ProgressType.parse(strProgType);
        MetabolicCompressionConfig cmpCfg = new MetabolicCompressionConfig(efmCompConfig);
        try {
            preprocessDuplicateGenes = cmpCfg.getPreprocessDuplicateGenes();
            cmpMethods = cmpCfg.getCompressionMethods();
        }
        catch (XmlConfigException ex) {
            throw new ch.javasoft.xml.config.XmlConfigException(ex.getMessage(), ex.getNode());
        }
        if (flag == null || (flag = flag.trim()).length() == 0) {
            flag = null;
        }
        DistributedConfig distConfig = new DistributedConfig(efmDistConfig);
        boolean selfTest = Boolean.parseBoolean(Config.getAttributeValue(efmImplConfig, XmlElement.self_test, XmlAttribute.value));
        boolean parseOnly = Boolean.parseBoolean(Config.getAttributeValue(efmImplConfig, XmlElement.parse_only, XmlAttribute.value));
        return new Config(xmlConfig, zero, adjMethod, rowOrdering, cmpMethods, preprocessDuplicateGenes, selfTest, parseOnly, maxThreads, arithmetic, precision, generator, normalize, reacsToSuppress, reacsToEnforce, reacsNoSplit, tmpDir, progPartition, progType, flag, distConfig);
    }

    public XmlConfig getXmlConfig() throws IOException {
        try {
            if (this.mXmlConfig != null) {
                return this.mXmlConfig;
            }
            return Config.resolveXmlConfig(this.getAsArgs());
        }
        catch (DocumentException e) {
            throw ExceptionUtil.toIOException(e);
        }
        catch (ch.javasoft.xml.config.XmlConfigException e) {
            throw ExceptionUtil.toIOException(e);
        }
    }

    public static XmlConfig resolveXmlConfig(String[] args) throws FileNotFoundException, DocumentException, ch.javasoft.xml.config.XmlConfigException {
        XmlConfig xmlConfig = Config.parseXmlConfig(args);
        try {
            xmlConfig.getDefaultConfigDocument();
        }
        catch (XmlArgException ex) {
            if (ex.isOption()) {
                System.err.println("ERROR:   missing " + ex.getOptionWithIndex() + " option");
            }
            System.err.println("DETAILS: " + ex.getLocalizedMessage());
            ex.printStackTrace();
            System.err.println("use --help option to display help message");
            throw ex;
        }
        catch (MissingReferableException ex) {
            if ("config[default]/metabolic-parse/parse".equals(ex.getPath())) {
                System.err.println("ERROR:   invalid input kind option '" + ex.getReferable() + "'");
            }
            System.err.println("DETAILS: " + ex.getLocalizedMessage());
            System.err.println("use --help option to display help message");
            throw ex;
        }
        catch (ch.javasoft.xml.config.XmlConfigException ex) {
            throw ex;
        }
        return xmlConfig;
    }

    public static XmlConfig parseXmlConfig(String[] args) throws FileNotFoundException, DocumentException {
        InputStream in;
        String config = DEFAULT_CONFIG_NAME;
        if (args.length >= 1 && !args[0].startsWith("-")) {
            in = new FileInputStream(args[0]);
            if (args.length >= 2 && !args[1].startsWith("-")) {
                config = args[1];
            }
        } else {
            File file = new File(CONFIG_FILE);
            in = file.canRead() ? new FileInputStream(CONFIG_FILE) : Config.class.getResourceAsStream("/config/metabolic-efm.xml");
            if (in == null) {
                throw new FileNotFoundException("/config/metabolic-efm.xml");
            }
        }
        XmlConfig xmlConfig = XmlConfig.getXmlConfig(in, args);
        xmlConfig.setAppName(DEFAULT_APP_NAME);
        if (config != null) {
            xmlConfig.setDefaultConfigName(config);
        }
        return xmlConfig;
    }

    public static void printVersion(PrintStream stream, XmlConfig xmlConfig) throws ch.javasoft.xml.config.XmlConfigException {
        xmlConfig.printUsage(stream, VERSION_NAME);
    }

    public static void printHelp(PrintStream stream, XmlConfig xmlConfig) throws ch.javasoft.xml.config.XmlConfigException {
        xmlConfig.printUsage(stream, HELP_NAME);
    }

    public static void printUsage(PrintStream stream, XmlConfig xmlConfig) throws ch.javasoft.xml.config.XmlConfigException {
        xmlConfig.printUsage(stream, USAGE_NAME);
    }

    private String[] getAsArgs() {
        return new String[]{"-rowordering", this.mRowOrdering, "-adjacency-method", this.mAdjMethod, "-maxthreads", String.valueOf(this.mMaxThreads), "-arithmetic", this.mArithmetic.getNiceName(), "-precision", String.valueOf(this.mPrecision), "-zero", String.valueOf(this.mZero.mZeroPos), "-normalize", this.mNormalize.name(), "-generator", this.mGenerator.name(), "-tmpdir", this.mTempDir.getBaseDir().getAbsolutePath(), "-level", Loggers.getRootLogger().getLevel().getName(), "-compression", DEFAULT_CONFIG_NAME, "-kind", "built-in", "-in", "unknown", "unknown", "-out", "count"};
    }

    public void writeTo(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            this.writeTo(writer);
        }
        finally {
            writer.close();
        }
    }

    public static Config readFrom(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            Config config = Config.getFromXmlConfig(XmlConfig.fromXmlDocument(reader));
            return config;
        }
        catch (ch.javasoft.xml.config.XmlConfigException e) {
            throw ExceptionUtil.toIOException(e);
        }
        catch (DocumentException e) {
            throw ExceptionUtil.toIOException(e);
        }
        finally {
            reader.close();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.getXmlConfig().writeTo(out);
    }

    public void writeTo(Writer writer) throws IOException {
        this.getXmlConfig().writeTo(writer);
    }

    public static String getAttributeValue(Element efmImplConfig, XmlElement element, XmlAttribute attribute) throws ch.javasoft.xml.config.XmlConfigException {
        Element el = XmlUtil.getRequiredSingleChildElement(efmImplConfig, element);
        return XmlUtil.getRequiredAttributeValue(el, attribute);
    }

    public int getMaxThreads() {
        return this.mMaxThreads;
    }

    public TempDir getTempDir() {
        return this.mTempDir;
    }

    public static Element getConfigMetabolicCompression(XmlConfig config) throws ch.javasoft.xml.config.XmlConfigException {
        Element defConfig = config.getDefaultConfigElement();
        return XmlUtil.getRequiredSingleChildElement(defConfig, XmlElement.metabolic_compression);
    }

    public static Element getConfigMetabolicEfm(XmlConfig config) throws ch.javasoft.xml.config.XmlConfigException {
        Element defConfig = config.getDefaultConfigElement();
        return XmlUtil.getRequiredSingleChildElement(defConfig, XmlElement.metabolic_efm);
    }

    public static Element getConfigEfmImpl(XmlConfig config) throws ch.javasoft.xml.config.XmlConfigException {
        return XmlUtil.getRequiredSingleChildElement(Config.getConfigMetabolicEfm(config), XmlElement.efm_impl);
    }

    public static Element getConfigEfmImplConfig(XmlConfig config) throws ch.javasoft.xml.config.XmlConfigException {
        return XmlUtil.getRequiredSingleChildElement(Config.getConfigEfmImpl(config), XmlElement.config);
    }

    public static Element getConfigEfmOutput(XmlConfig config) throws ch.javasoft.xml.config.XmlConfigException {
        return XmlUtil.getRequiredSingleChildElement(Config.getConfigMetabolicEfm(config), XmlElement.efm_output);
    }

    public static ElementaryFluxModes.Impl getEfmImpl(XmlConfig config, Element efmImplConfig) throws ch.javasoft.xml.config.XmlConfigException {
        String implClass = XmlUtil.getRequiredAttributeValue(efmImplConfig, XmlAttribute.class_);
        Element elModel = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.model);
        String modelClass = XmlUtil.getRequiredAttributeValue(elModel, XmlAttribute.factory);
        Element elMemory = XmlUtil.getRequiredSingleChildElement(efmImplConfig, XmlElement.memory);
        String memoryClass = XmlUtil.getRequiredAttributeValue(elMemory, XmlAttribute.factory);
        try {
            Class<?> clsImpl = Class.forName(implClass);
            Class<?> clsModel = Class.forName(modelClass);
            Class<?> clsMemory = Class.forName(memoryClass);
            Constructor<?> cons = clsImpl.getConstructor(Config.class, EfmModelFactory.class, MemoryFactory.class);
            EfmModelFactory facModel = (EfmModelFactory)clsModel.newInstance();
            MemoryFactory facMemory = (MemoryFactory)clsMemory.newInstance();
            return (ElementaryFluxModes.Impl)cons.newInstance(Config.getFromXmlConfig(config), facModel, facMemory);
        }
        catch (Exception ex) {
            throw new ch.javasoft.xml.config.XmlConfigException("cannot instantiate efm-impl class '" + implClass + "', e=" + ex, (Node)efmImplConfig, (Throwable)ex);
        }
    }

    public void log(Logger logger, Level level) {
        if (Loggers.isLoggable(logger, level)) {
            logger.log(level, "Config:");
            logger.log(level, "..generator        : " + (Object)((Object)this.getGenerator()));
            logger.log(level, "..adj method       : " + this.getAdjMethod());
            logger.log(level, "..row ordering     : " + this.getRowOrdering());
            logger.log(level, "..arithmetic       : " + (Object)((Object)this.getArithmetic()) + " (prec: " + this.getPrecision() + " / zero: " + this.zero().mZeroPos + ")");
            logger.log(level, "..compression      : " + (this.compressNetwork(true) ? "on" : "off"));
            logger.log(level, "..compr. methods   : " + java.util.Arrays.toString((Object[])this.getCompressionMethods(true)));
            logger.log(level, "..normalize        : " + (Object)((Object)this.getNormalize()));
            logger.log(level, "..max threads      : " + this.getMaxThreads());
            logger.log(level, "..self test        : " + (this.selfTest() ? "on" : "off"));
            logger.log(level, "..progress type    : " + (Object)((Object)this.getProgressType()));
            logger.log(level, "..progress part.   : " + this.getProgressPartition());
            logger.log(level, "..suppress         : " + this.getReactionsToSuppress());
            logger.log(level, "..enforce          : " + this.getReactionsToEnforce());
            logger.log(level, "..nosplit          : " + this.getReactionsNoSplit());
            logger.log(level, "..temp dir         : " + this.getTempDir());
            logger.log(level, "..flag             : " + (this.getFlag() == null ? "(none)" : this.getFlag()));
        }
        this.getDistributedConfig().log(logger, level);
        if (this.getArithmetic().isExact() && !this.getNormalize().isExact()) {
            logger.warning("using exact arithmetic [" + (Object)((Object)this.getArithmetic()) + "], but normalization [" + (Object)((Object)this.getNormalize()) + "] might cause truncation");
        }
    }

    public static void traceArgs(PrintStream print, String prefix, String[] args) {
        print.println(Config.traceArgsString(prefix, args));
    }

    public static void traceArgs(Logger logger, Level level, String prefix, String[] args) {
        logger.log(level, Config.traceArgsString(prefix, args));
    }

    public static String traceArgsString(String prefix, String[] args) {
        StringBuilder sb = new StringBuilder(prefix);
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(args[i]);
            ++i;
        }
        return sb.toString();
    }
}

