/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.cdd.parser.CddParser;
import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.CddHelper;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.LogPkg;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import junit.framework.TestCase;

public class CddIneTest
extends TestCase {
    private static final File FOLDER_INE = new File("../cdd-data/ine");

    static {
        CompressionMethod[] compression = CompressionMethod.NONE;
        if (Config.initForJUnitTest("pattern-tree-minzero", "FewestNegPosOrMostZeros", compression, false, Arithmetic.double_, Norm.min)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testCube2() throws IOException {
        this.internalTestIne("cube2.ine");
    }

    public void testCube3() throws IOException {
        this.internalTestIne("cube3.ine");
    }

    public void testCube4() throws IOException {
        this.internalTestIne("cube4.ine");
    }

    public void testCube6() throws IOException {
        this.internalTestIne("cube6.ine");
    }

    public void testCube8() throws IOException {
        this.internalTestIne("cube8.ine");
    }

    public void testCube10() throws IOException {
        this.internalTestIne("cube10.ine");
    }

    public void testCube14() throws IOException {
        this.internalTestIne("cube14.ine");
    }

    public void testCube16() throws IOException {
        this.internalTestIne("cube16.ine");
    }

    public void testCube18() throws IOException {
        this.internalTestIne("cube18.ine");
    }

    public void testCube20() throws IOException {
        this.internalTestIne("cube20.ine");
    }

    public void testCross6() throws IOException {
        this.internalTestIne("cross6.ine");
    }

    public void testCross8() throws IOException {
        this.internalTestIne("cross8.ine");
    }

    public void testCross10() throws IOException {
        this.internalTestIne("cross10.ine");
    }

    public void testCross12() throws IOException {
        this.internalTestIne("cross12.ine");
    }

    public void testCcp4rev() throws IOException {
        this.internalTestIne("ccp4.ine");
    }

    public void testCcp5rev() throws IOException {
        this.internalTestIne("ccp5.ine");
    }

    public void testCcp6rev() throws IOException {
        this.internalTestIne("ccp6.ine");
    }

    public void testCcp7rev() throws IOException {
        this.internalTestIne("ccp7.ine");
    }

    public void testReg600_5() throws IOException {
        this.internalTestIne("reg600-5.ine");
    }

    public void testProdmT5() throws IOException {
        this.internalTestIne("prodmt5.ine");
    }

    public void testProdmT62() throws IOException {
        this.internalTestIne("prodst62.ine");
    }

    public void testMit31_20() throws IOException {
        this.internalTestIne("mit31-20.ine");
    }

    public void testMit41_16() throws IOException {
        this.internalTestIne("mit41-16.ine");
    }

    public void testMit71_61() throws IOException {
        this.internalTestIne("mit71-61.ine");
    }

    public void testMit90_86() throws IOException {
        this.internalTestIne("mit90-86.ine");
    }

    public void testMit729_9() throws IOException {
        this.internalTestIne("mit729-9.ine");
    }

    public void testStein27() throws Exception {
        this.internalTestIne("stein27.ine");
    }

    public void internalTestIne(String fileName) throws FileNotFoundException, IOException {
        File file = new File(FOLDER_INE, fileName);
        CddParser parser = new CddParser(file);
        BigFraction[][] mx = CddHelper.getMatrix(parser);
        int dims = mx.length == 0 ? 0 : mx[0].length;
        LogPkg.LOGGER.info(String.valueOf(mx.length) + "x" + mx[0].length + " matrix for cdd file: " + file.getAbsolutePath());
        mx = CddHelper.addSlackVariables(mx);
        boolean[] reversible = new boolean[mx.length == 0 ? 0 : mx[0].length];
        int i = 0;
        while (i < dims) {
            reversible[i] = true;
            ++i;
        }
        FractionNumberStoichMetabolicNetwork metaNet = new FractionNumberStoichMetabolicNetwork(new DefaultBigIntegerRationalMatrix(mx, true), reversible);
        if (!Config.getConfig().getReactionsNoSplit().isEmpty()) {
            throw new RuntimeException("non-empty no split reactions");
        }
        int i2 = 0;
        while (i2 < dims) {
            Config.getConfig().getReactionsNoSplit().add(metaNet.getReactions().get(i2).getName());
            ++i2;
        }
        ElementaryFluxModes.calculateLogCountOnly(metaNet);
    }
}

