/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress.config;

import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.compress.config.XmlAttribute;
import ch.javasoft.metabolic.compress.config.XmlConfigException;
import ch.javasoft.metabolic.compress.config.XmlElement;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.Node;

public class MetabolicCompressionConfig {
    private final Element mRoot;

    public MetabolicCompressionConfig(Element elMetabolicCompression) {
        this.mRoot = elMetabolicCompression;
    }

    public boolean getPreprocessDuplicateGenes() {
        Element el = this.mRoot.element(XmlElement.preprocess_duplicate_genes.getXmlName());
        return el == null ? false : Boolean.parseBoolean(el.attributeValue(XmlAttribute.value.getXmlName()));
    }

    public CompressionMethod[] getCompressionMethods() throws XmlConfigException {
        Element elMethods = this.mRoot.element(XmlElement.compression_methods.getXmlName());
        if (elMethods == null) {
            return CompressionMethod.NONE;
        }
        Iterator it = elMethods.elementIterator(XmlElement.method.getXmlName());
        ArrayList<CompressionMethod> cmpMethods = new ArrayList<CompressionMethod>();
        while (it.hasNext()) {
            boolean on;
            Element elMethod = (Element)it.next();
            String methodName = elMethod.attributeValue(XmlAttribute.name.getXmlName());
            String strOn = elMethod.attributeValue(XmlAttribute.value.getXmlName());
            boolean bl = on = strOn == null ? true : Boolean.parseBoolean(strOn);
            if (!on) continue;
            try {
                cmpMethods.add(CompressionMethod.valueOf(methodName));
            }
            catch (Exception ex) {
                throw new XmlConfigException("invalid compression method: " + methodName, (Node)elMethod);
            }
        }
        CompressionMethod[] res = new CompressionMethod[cmpMethods.size()];
        return cmpMethods.toArray(res);
    }
}

