/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.ops.AbstractNumberOps;
import ch.javasoft.util.numeric.IntegerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongOperations
extends AbstractNumberOps<Long> {
    private static LongOperations sInstance;

    public static LongOperations instance() {
        if (sInstance == null) {
            sInstance = new LongOperations();
        }
        return sInstance;
    }

    @Override
    public Class<Long> numberClass() {
        return Long.class;
    }

    @Override
    public Long abs(Long number) {
        return Math.abs(number);
    }

    @Override
    public Long add(Long numA, Long numB) {
        return numA + numB;
    }

    public Long[] newArray(int size) {
        return new Long[size];
    }

    public Long[][] newArray(int rows, int cols) {
        return new Long[rows][cols];
    }

    @Override
    public Long valueOf(String s) {
        return Long.valueOf(s);
    }

    @Override
    public Long valueOf(Number number) {
        if ((double)number.longValue() != number.doubleValue()) {
            throw new IllegalArgumentException("value not an integer value:  " + number);
        }
        return this.valueOf(number.longValue());
    }

    @Override
    public Long valueOf(long value) {
        return value;
    }

    @Override
    public Long valueOf(double value) {
        long lvalue = (long)value;
        if ((double)lvalue != value) {
            throw new IllegalArgumentException("value not convertable to long: " + value);
        }
        return lvalue;
    }

    @Override
    public Long divide(Long numA, Long numB) {
        return numA / numB;
    }

    @Override
    public Long invert(Long number) {
        long val = number;
        if (val == 1L || val == -1L) {
            return number;
        }
        throw new IllegalArgumentException("inversion would not yield an integer: " + val);
    }

    @Override
    public boolean isOne(Long number) {
        return number == 1L;
    }

    @Override
    public boolean isZero(Long number) {
        return number == 0L;
    }

    @Override
    public boolean isNonZero(Long number) {
        return number != 0L;
    }

    @Override
    public boolean isNegative(Long number) {
        return number < 0L;
    }

    @Override
    public boolean isPositive(Long number) {
        return number > 0L;
    }

    @Override
    public Long multiply(Long numA, Long numB) {
        return numA * numB;
    }

    @Override
    public Long negate(Long number) {
        return -number.longValue();
    }

    @Override
    public Long reduce(Long number) {
        return number;
    }

    public Long[] reduceVector(boolean cloneOnChange, Long ... vector) {
        long gcd = Math.abs(IntegerUtil.gcd(vector));
        if (gcd != 0L && gcd != 1L) {
            if (cloneOnChange) {
                vector = (Long[])vector.clone();
            }
            int i = 0;
            while (i < vector.length) {
                vector[i] = vector[i] / gcd;
                ++i;
            }
        }
        return vector;
    }

    @Override
    public Long one() {
        return 1L;
    }

    @Override
    public Long pow(Long numA, Long numB) {
        return (long)Math.pow(numA.longValue(), numB.longValue());
    }

    @Override
    public int signum(Long number) {
        long val = number;
        return val < 0L ? -1 : (val > 0L ? 1 : 0);
    }

    @Override
    public Long subtract(Long numA, Long numB) {
        return numA - numB;
    }

    @Override
    public Long zero() {
        return 0L;
    }

    @Override
    public int compare(Long o1, Long o2) {
        return o1.compareTo(o2);
    }

    @Override
    public byte[] toByteArray(Long number) {
        long v = number;
        byte[] bytes = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return bytes;
    }

    @Override
    public void writeTo(Long number, DataOutput out) throws IOException {
        out.writeLong(number);
    }

    @Override
    public Long fromByteArray(byte[] bytes) {
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    @Override
    public Long readFrom(DataInput in) throws IOException {
        return in.readLong();
    }

    @Override
    public int byteLength() {
        return 8;
    }
}

